/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class Reflection {
    private Reflection() {
    }

    public static Field field(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static MethodHandle methodHandle(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflect(clazz.getMethod(name, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static MethodHandle methodHandle(StandardErrorCode errorCode, Method method) {
        try {
            return MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new PrestoException((ErrorCodeSupplier)errorCode, (Throwable)e);
        }
    }

    public static MethodHandle methodHandle(Method method) {
        return Reflection.methodHandle(StandardErrorCode.GENERIC_INTERNAL_ERROR, method);
    }

    public static MethodHandle constructorMethodHandle(Class<?> clazz, Class<?> ... parameterTypes) {
        return Reflection.constructorMethodHandle(StandardErrorCode.GENERIC_INTERNAL_ERROR, clazz, parameterTypes);
    }

    public static MethodHandle constructorMethodHandle(StandardErrorCode errorCode, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflectConstructor(clazz.getConstructor(parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)errorCode, (Throwable)e);
        }
    }

    public static MethodHandle constructorMethodHandle(StandardErrorCode errorCode, Constructor<?> constructor) {
        try {
            return MethodHandles.lookup().unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new PrestoException((ErrorCodeSupplier)errorCode, (Throwable)e);
        }
    }
}

