/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.rewrite;

import io.prestosql.Session;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.ExplainFormat;
import io.prestosql.sql.tree.ExplainOption;
import io.prestosql.sql.tree.ExplainType;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class ExplainRewrite
implements StatementRewrite.Rewrite {
    ExplainRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameter, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, parser, queryExplainer, warningCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final QueryPreparer queryPreparer;
        private final Optional<QueryExplainer> queryExplainer;
        private final WarningCollector warningCollector;

        public Visitor(Session session, SqlParser parser, Optional<QueryExplainer> queryExplainer, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.queryPreparer = new QueryPreparer(Objects.requireNonNull(parser, "queryPreparer is null"));
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitExplain(Explain node, Void context) {
            if (node.isAnalyze()) {
                Statement statement = (Statement)this.process((Node)node.getStatement(), context);
                return new Explain(statement, node.isAnalyze(), node.isVerbose(), node.getOptions());
            }
            ExplainType.Type planType = ExplainType.Type.LOGICAL;
            ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
            List options = node.getOptions();
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainType)) continue;
                planType = ((ExplainType)option).getType();
                if (planType != ExplainType.Type.IO) break;
                planFormat = ExplainFormat.Type.JSON;
                break;
            }
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainFormat)) continue;
                planFormat = ((ExplainFormat)option).getType();
                break;
            }
            return this.getQueryPlan(node, planType, planFormat);
        }

        private Node getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
            String plan;
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(this.session, node.getStatement());
            if (planType == ExplainType.Type.VALIDATE) {
                this.queryExplainer.get().analyze(this.session, preparedQuery.getStatement(), preparedQuery.getParameters(), this.warningCollector);
                return QueryUtil.singleValueQuery((String)"Valid", (boolean)true);
            }
            switch (planFormat) {
                case GRAPHVIZ: {
                    plan = this.queryExplainer.get().getGraphvizPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                    break;
                }
                case JSON: {
                    plan = this.queryExplainer.get().getJsonPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                    break;
                }
                case TEXT: {
                    plan = this.queryExplainer.get().getPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Explain Format: " + planFormat.toString());
                }
            }
            return QueryUtil.singleValueQuery((String)"Query Plan", (String)plan);
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

