/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;

@AggregationFunction(value="$internal$sum_data_size_for_stats", hidden=true)
public final class SumDataSizeForStats {
    public static final String NAME = "$internal$sum_data_size_for_stats";

    private SumDataSizeForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState NullableLongState state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        SumDataSizeForStats.update(state, block.getEstimatedDataSizeForStats(index));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        SumDataSizeForStats.update(state, otherState.getLong());
    }

    private static void update(NullableLongState state, long size) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(size);
        } else {
            state.setLong(state.getLong() + size);
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

