/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class PulsarSplit
implements ConnectorSplit {
    private static final Logger log = Logger.get(PulsarSplit.class);
    private final long splitId;
    private final String connectorId;
    private final String schemaName;
    private final String originSchemaName;
    private final String tableName;
    private final long splitSize;
    private final String schema;
    private final SchemaType schemaType;
    private final long startPositionEntryId;
    private final long endPositionEntryId;
    private final long startPositionLedgerId;
    private final long endPositionLedgerId;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final SchemaInfo schemaInfo;
    private final PositionImpl startPosition;
    private final PositionImpl endPosition;
    private final String schemaInfoProperties;
    private final OffloadPoliciesImpl offloadPolicies;

    @JsonCreator
    public PulsarSplit(@JsonProperty(value="splitId") long splitId, @JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="originSchemaName") String originSchemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="splitSize") long splitSize, @JsonProperty(value="schema") String schema, @JsonProperty(value="schemaType") SchemaType schemaType, @JsonProperty(value="startPositionEntryId") long startPositionEntryId, @JsonProperty(value="endPositionEntryId") long endPositionEntryId, @JsonProperty(value="startPositionLedgerId") long startPositionLedgerId, @JsonProperty(value="endPositionLedgerId") long endPositionLedgerId, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="schemaInfoProperties") String schemaInfoProperties, @JsonProperty(value="offloadPolicies") OffloadPoliciesImpl offloadPolicies) throws IOException {
        this.splitId = splitId;
        Objects.requireNonNull(schemaName, "schema name is null");
        this.originSchemaName = originSchemaName;
        this.schemaName = Objects.requireNonNull(schemaName, "schema name is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.splitSize = splitSize;
        this.schema = schema;
        this.schemaType = schemaType;
        this.startPositionEntryId = startPositionEntryId;
        this.endPositionEntryId = endPositionEntryId;
        this.startPositionLedgerId = startPositionLedgerId;
        this.endPositionLedgerId = endPositionLedgerId;
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.startPosition = PositionImpl.get(startPositionLedgerId, startPositionEntryId);
        this.endPosition = PositionImpl.get(endPositionLedgerId, endPositionEntryId);
        this.schemaInfoProperties = schemaInfoProperties;
        this.offloadPolicies = offloadPolicies;
        ObjectMapper objectMapper = new ObjectMapper();
        this.schemaInfo = SchemaInfoImpl.builder().name(originSchemaName).type(schemaType).schema(schema.getBytes("ISO8859-1")).properties((Map)objectMapper.readValue(schemaInfoProperties, Map.class)).build();
    }

    @JsonProperty
    public long getSplitId() {
        return this.splitId;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public long getSplitSize() {
        return this.splitSize;
    }

    @JsonProperty
    public String getOriginSchemaName() {
        return this.originSchemaName;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public long getStartPositionEntryId() {
        return this.startPositionEntryId;
    }

    @JsonProperty
    public long getEndPositionEntryId() {
        return this.endPositionEntryId;
    }

    @JsonProperty
    public long getStartPositionLedgerId() {
        return this.startPositionLedgerId;
    }

    @JsonProperty
    public long getEndPositionLedgerId() {
        return this.endPositionLedgerId;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public PositionImpl getStartPosition() {
        return this.startPosition;
    }

    public PositionImpl getEndPosition() {
        return this.endPosition;
    }

    @JsonProperty
    public String getSchemaInfoProperties() {
        return this.schemaInfoProperties;
    }

    @JsonProperty
    public OffloadPoliciesImpl getOffloadPolicies() {
        return this.offloadPolicies;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)HostAddress.fromParts((String)"localhost", (int)12345));
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return "PulsarSplit{splitId=" + this.splitId + ", connectorId='" + this.connectorId + '\'' + ", originSchemaName='" + this.originSchemaName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", tableName='" + this.tableName + '\'' + ", splitSize=" + this.splitSize + ", schema='" + this.schema + '\'' + ", schemaType=" + this.schemaType + ", startPositionEntryId=" + this.startPositionEntryId + ", endPositionEntryId=" + this.endPositionEntryId + ", startPositionLedgerId=" + this.startPositionLedgerId + ", endPositionLedgerId=" + this.endPositionLedgerId + ", schemaInfoProperties=" + this.schemaInfoProperties + (this.offloadPolicies == null ? "" : this.offloadPolicies.toString()) + '}';
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }
}

