/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.operator.OperatorContext;
import io.prestosql.spi.Page;
import java.util.List;
import java.util.Objects;

public final class NestedLoopJoinPages {
    private final ImmutableList<Page> pages;
    private final DataSize estimatedSize;

    NestedLoopJoinPages(List<Page> pages, DataSize estimatedSize, OperatorContext operatorContext) {
        Objects.requireNonNull(pages, "pages is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(estimatedSize, "estimatedSize is null");
        this.pages = ImmutableList.copyOf(pages);
        this.estimatedSize = estimatedSize;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public DataSize getEstimatedSize() {
        return this.estimatedSize;
    }
}

