/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.RenameColumn;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(RenameColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        TableHandle tableHandle = metadata.getTableHandle(session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName));
        String source = statement.getSource().getValue().toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanRenameColumn(session.toSecurityContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        ColumnHandle columnHandle = columnHandles.get(source);
        if (columnHandle == null) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", source);
        }
        if (columnHandles.containsKey(target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot rename hidden column", new Object[0]);
        }
        metadata.renameColumn(session, tableHandle, columnHandle, target);
        return Futures.immediateFuture(null);
    }
}

