/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.prestosql.sql.ExpressionFormatter;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Expression;
import java.io.IOException;
import javax.inject.Inject;

public final class ExpressionSerialization {
    private ExpressionSerialization() {
    }

    public static class ExpressionDeserializer
    extends JsonDeserializer<Expression> {
        private final SqlParser sqlParser;

        @Inject
        public ExpressionDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return ExpressionUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class), new ParsingOptions()));
        }
    }

    public static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(ExpressionFormatter.formatExpression((Expression)expression));
        }
    }
}

