/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;

@ScalarFunction(value="slice")
@Description(value="Subsets an array given an offset (1-indexed) and length")
public final class ArraySliceFunction {
    private ArraySliceFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block slice(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long fromIndex, @SqlType(value="bigint") long length) {
        long toIndex;
        Failures.checkCondition(length >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "length must be greater than or equal to 0", new Object[0]);
        Failures.checkCondition(fromIndex != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1", new Object[0]);
        int size = array.getPositionCount();
        if (size == 0) {
            return array;
        }
        if (fromIndex < 0L) {
            fromIndex = (long)size + fromIndex + 1L;
        }
        if (fromIndex >= (toIndex = Math.min(fromIndex + length, (long)(size + 1))) || fromIndex < 1L) {
            return type.createBlockBuilder(null, 0).build();
        }
        return array.getRegion((int)(fromIndex - 1L), (int)(toIndex - fromIndex));
    }
}

