/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.AllOrNone;
import io.prestosql.spi.predicate.DiscreteValues;
import io.prestosql.spi.predicate.Ranges;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.predicate.ValuesProcessor;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EquatableValueSet
implements ValueSet {
    private final Type type;
    private final boolean whiteList;
    private final Set<ValueEntry> entries;

    @JsonCreator
    public EquatableValueSet(@JsonProperty(value="type") Type type, @JsonProperty(value="whiteList") boolean whiteList, @JsonProperty(value="entries") Set<ValueEntry> entries) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(entries, "entries is null");
        if (!type.isComparable()) {
            throw new IllegalArgumentException("Type is not comparable: " + type);
        }
        if (type.isOrderable()) {
            throw new IllegalArgumentException("Use SortedRangeSet instead");
        }
        this.type = type;
        this.whiteList = whiteList;
        this.entries = Collections.unmodifiableSet(new LinkedHashSet<ValueEntry>(entries));
    }

    static EquatableValueSet none(Type type) {
        return new EquatableValueSet(type, true, Collections.emptySet());
    }

    static EquatableValueSet all(Type type) {
        return new EquatableValueSet(type, false, Collections.emptySet());
    }

    static EquatableValueSet of(Type type, Object first, Object ... rest) {
        LinkedHashSet<ValueEntry> set = new LinkedHashSet<ValueEntry>(rest.length + 1);
        set.add(ValueEntry.create(type, first));
        for (Object value : rest) {
            set.add(ValueEntry.create(type, value));
        }
        return new EquatableValueSet(type, true, set);
    }

    static EquatableValueSet copyOf(Type type, Collection<Object> values) {
        return new EquatableValueSet(type, true, values.stream().map(value -> ValueEntry.create(type, value)).collect(EquatableValueSet.toLinkedSet()));
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isWhiteList() {
        return this.whiteList;
    }

    @JsonProperty
    public Set<ValueEntry> getEntries() {
        return this.entries;
    }

    public Collection<Object> getValues() {
        return Collections.unmodifiableCollection(this.entries.stream().map(ValueEntry::getValue).collect(Collectors.toList()));
    }

    public int getValuesCount() {
        return this.entries.size();
    }

    @Override
    public boolean isNone() {
        return this.whiteList && this.entries.isEmpty();
    }

    @Override
    public boolean isAll() {
        return !this.whiteList && this.entries.isEmpty();
    }

    @Override
    public boolean isSingleValue() {
        return this.whiteList && this.entries.size() == 1;
    }

    @Override
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("EquatableValueSet does not have just a single value");
        }
        return this.entries.iterator().next().getValue();
    }

    @Override
    public boolean isDiscreteSet() {
        return this.whiteList && !this.entries.isEmpty();
    }

    @Override
    public List<Object> getDiscreteSet() {
        if (!this.isDiscreteSet()) {
            throw new IllegalStateException("EquatableValueSet is not a discrete set");
        }
        return this.entries.stream().map(ValueEntry::getValue).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.whiteList == this.entries.contains(ValueEntry.create(this.type, value));
    }

    @Override
    public DiscreteValues getDiscreteValues() {
        return new DiscreteValues(){

            @Override
            public boolean isWhiteList() {
                return EquatableValueSet.this.isWhiteList();
            }

            @Override
            public Collection<Object> getValues() {
                return EquatableValueSet.this.getValues();
            }

            @Override
            public int getValuesCount() {
                return EquatableValueSet.this.getValuesCount();
            }
        };
    }

    @Override
    public ValuesProcessor getValuesProcessor() {
        return new ValuesProcessor(){

            @Override
            public <T> T transform(Function<Ranges, T> rangesFunction, Function<DiscreteValues, T> valuesFunction, Function<AllOrNone, T> allOrNoneFunction) {
                return valuesFunction.apply(EquatableValueSet.this.getDiscreteValues());
            }

            @Override
            public void consume(Consumer<Ranges> rangesConsumer, Consumer<DiscreteValues> valuesConsumer, Consumer<AllOrNone> allOrNoneConsumer) {
                valuesConsumer.accept(EquatableValueSet.this.getDiscreteValues());
            }
        };
    }

    @Override
    public EquatableValueSet intersect(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.whiteList && otherValueSet.isWhiteList()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.intersect(this.entries, otherValueSet.entries));
        }
        if (this.whiteList) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.subtract(this.entries, otherValueSet.entries));
        }
        if (otherValueSet.isWhiteList()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.subtract(otherValueSet.entries, this.entries));
        }
        return new EquatableValueSet(this.type, false, EquatableValueSet.union(otherValueSet.entries, this.entries));
    }

    @Override
    public boolean overlaps(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.whiteList && otherValueSet.isWhiteList()) {
            return EquatableValueSet.setsOverlap(this.entries, otherValueSet.entries);
        }
        if (this.whiteList) {
            return !otherValueSet.entries.containsAll(this.entries);
        }
        if (otherValueSet.isWhiteList()) {
            return !this.entries.containsAll(otherValueSet.entries);
        }
        return true;
    }

    @Override
    public EquatableValueSet union(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.whiteList && otherValueSet.isWhiteList()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.union(this.entries, otherValueSet.entries));
        }
        if (this.whiteList) {
            return new EquatableValueSet(this.type, false, EquatableValueSet.subtract(otherValueSet.entries, this.entries));
        }
        if (otherValueSet.isWhiteList()) {
            return new EquatableValueSet(this.type, false, EquatableValueSet.subtract(this.entries, otherValueSet.entries));
        }
        return new EquatableValueSet(this.type, false, EquatableValueSet.intersect(otherValueSet.entries, this.entries));
    }

    @Override
    public EquatableValueSet complement() {
        return new EquatableValueSet(this.type, !this.whiteList, this.entries);
    }

    @Override
    public String toString() {
        return String.format("%s[... (%d elements) ...]", this.whiteList ? "" : "EXCLUDES", this.entries.size());
    }

    @Override
    public String toString(ConnectorSession session) {
        return (this.whiteList ? "[ " : "EXCLUDES[ ") + this.entries.stream().map(entry -> this.type.getObjectValue(session, entry.getBlock(), 0).toString()).collect(Collectors.joining(", ")) + " ]";
    }

    private static <T> Set<T> intersect(Set<T> set1, Set<T> set2) {
        if (set1.size() > set2.size()) {
            return EquatableValueSet.intersect(set2, set1);
        }
        return set1.stream().filter(set2::contains).collect(EquatableValueSet.toLinkedSet());
    }

    private static <T> boolean setsOverlap(Set<T> set1, Set<T> set2) {
        if (set1.size() > set2.size()) {
            return EquatableValueSet.setsOverlap(set2, set1);
        }
        for (T element : set1) {
            if (!set2.contains(element)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        return Stream.concat(set1.stream(), set2.stream()).collect(EquatableValueSet.toLinkedSet());
    }

    private static <T> Set<T> subtract(Set<T> set1, Set<T> set2) {
        return set1.stream().filter(value -> !set2.contains(value)).collect(EquatableValueSet.toLinkedSet());
    }

    private EquatableValueSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof EquatableValueSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a EquatableValueSet: %s", other.getClass()));
        }
        return (EquatableValueSet)other;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.whiteList, this.entries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquatableValueSet other = (EquatableValueSet)obj;
        return Objects.equals(this.type, other.type) && this.whiteList == other.whiteList && Objects.equals(this.entries, other.entries);
    }

    private static <T> Collector<T, ?, Set<T>> toLinkedSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static class ValueEntry {
        private final Type type;
        private final Block block;

        @JsonCreator
        public ValueEntry(@JsonProperty(value="type") Type type, @JsonProperty(value="block") Block block) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.block = Objects.requireNonNull(block, "block is null");
            if (block.getPositionCount() != 1) {
                throw new IllegalArgumentException("Block should only have one position");
            }
        }

        public static ValueEntry create(Type type, Object value) {
            return new ValueEntry(type, Utils.nativeValueToBlock(type, value));
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public Block getBlock() {
            return this.block;
        }

        public Object getValue() {
            return Utils.blockToNativeValue(this.type, this.block);
        }

        public int hashCode() {
            return (int)this.type.hash(this.block, 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ValueEntry other = (ValueEntry)obj;
            return Objects.equals(this.type, other.type) && this.type.equalTo(this.block, 0, other.block, 0);
        }
    }
}

