/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.function.Consumer;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LeaderElection;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PulsarLedgerAuditorManager
implements LedgerAuditorManager {
    private static final Logger log = LoggerFactory.getLogger(PulsarLedgerAuditorManager.class);
    private static final String ELECTION_PATH = "leader";
    private final CoordinationService coordinationService;
    private final LeaderElection<String> leaderElection;
    private LeaderElectionState leaderElectionState;
    private String bookieId;
    private boolean sessionExpired = false;

    PulsarLedgerAuditorManager(MetadataStoreExtended store, String ledgersRoot) {
        this.coordinationService = new CoordinationServiceImpl(store);
        String electionPath = ledgersRoot + "/underreplication/leader";
        this.leaderElection = this.coordinationService.getLeaderElection(String.class, electionPath, this::handleStateChanges);
        this.leaderElectionState = LeaderElectionState.NoLeader;
        store.registerSessionListener(event -> {
            if (SessionEvent.SessionLost == event) {
                PulsarLedgerAuditorManager pulsarLedgerAuditorManager = this;
                synchronized (pulsarLedgerAuditorManager) {
                    this.sessionExpired = true;
                    this.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateChanges(LeaderElectionState state) {
        log.info("Auditor leader election state: {} -- BookieId: {}", (Object)state, (Object)this.bookieId);
        PulsarLedgerAuditorManager pulsarLedgerAuditorManager = this;
        synchronized (pulsarLedgerAuditorManager) {
            this.leaderElectionState = state;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tryToBecomeAuditor(String bookieId, Consumer<LedgerAuditorManager.AuditorEvent> listener) {
        this.bookieId = bookieId;
        LeaderElectionState les = this.leaderElection.elect(bookieId).join();
        PulsarLedgerAuditorManager pulsarLedgerAuditorManager = this;
        synchronized (pulsarLedgerAuditorManager) {
            this.leaderElectionState = les;
        }
        try {
            while (true) {
                pulsarLedgerAuditorManager = this;
                synchronized (pulsarLedgerAuditorManager) {
                    if (this.sessionExpired) {
                        throw new IllegalStateException("Zookeeper session expired, give up to become auditor.");
                    }
                    if (this.leaderElectionState == LeaderElectionState.Leading) {
                        return;
                    }
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public BookieId getCurrentAuditor() {
        return this.leaderElection.getLeaderValue().join().map(BookieId::parse).orElse(null);
    }

    public void close() throws Exception {
        this.leaderElection.close();
        this.coordinationService.close();
    }
}

