/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkLedgerManager
implements LedgerManager,
Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractZkLedgerManager.class);
    @VisibleForTesting
    static final int ZK_CONNECT_BACKOFF_MS = 200;
    private final LedgerMetadataSerDe serDe;
    protected final AbstractConfiguration conf;
    protected final ZooKeeper zk;
    protected final String ledgerRootPath;
    protected final ConcurrentMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>> listeners = new ConcurrentHashMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>>();
    protected ScheduledExecutorService scheduler;

    protected AbstractZkLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        this.serDe = new LedgerMetadataSerDe();
        this.conf = conf;
        this.zk = zk;
        this.ledgerRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf);
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("ZkLedgerManagerScheduler"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using AbstractZkLedgerManager with root path : {}", (Object)this.ledgerRootPath);
        }
    }

    public abstract String getLedgerPath(long var1);

    protected abstract long getLedgerId(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        long ledgerId;
        LOG.debug("Received watched event {} from zookeeper based ledger manager.", (Object)event);
        if (Watcher.Event.EventType.None == event.getType()) {
            if (Watcher.Event.KeeperState.Expired == event.getState()) {
                LOG.info("ZooKeeper client expired on ledger manager.");
                HashSet keySet = new HashSet(this.listeners.keySet());
                for (Long lid : keySet) {
                    this.scheduler.submit(new ReadLedgerMetadataTask(lid));
                    LOG.info("Re-read ledger metadata for {} after zookeeper session expired.", (Object)lid);
                }
            }
            return;
        }
        String path = event.getPath();
        if (null == path) {
            return;
        }
        try {
            ledgerId = this.getLedgerId(event.getPath());
        }
        catch (IOException ioe) {
            LOG.info("Received invalid ledger path {} : ", (Object)event.getPath(), (Object)ioe);
            return;
        }
        switch (event.getType()) {
            case NodeDeleted: {
                Set listenerSet = (Set)this.listeners.get(ledgerId);
                if (null != listenerSet) {
                    Set set = listenerSet;
                    synchronized (set) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removed ledger metadata listeners on ledger {} : {}", (Object)ledgerId, (Object)listenerSet);
                        }
                        for (BookkeeperInternalCallbacks.LedgerMetadataListener l : listenerSet) {
                            l.onChanged(ledgerId, null);
                        }
                        this.listeners.remove(ledgerId, listenerSet);
                        break;
                    }
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("No ledger metadata listeners to remove from ledger {} after it's deleted.", (Object)ledgerId);
                break;
            }
            case NodeDataChanged: {
                new ReadLedgerMetadataTask(ledgerId).run();
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Received event {} on {}.", (Object)event.getType(), (Object)event.getPath());
            }
        }
    }

    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(final long ledgerId, LedgerMetadata inputMetadata) {
        byte[] data;
        final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        final long cToken = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        final LedgerMetadata metadata = inputMetadata.getMetadataFormatVersion() > 2 ? LedgerMetadataBuilder.from(inputMetadata).withId(ledgerId).withCToken(cToken).build() : inputMetadata;
        String ledgerPath = this.getLedgerPath(ledgerId);
        AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (rc == KeeperException.Code.OK.intValue()) {
                    promise.complete(new Versioned<LedgerMetadata>(metadata, new LongVersion(0L)));
                } else if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
                    LOG.info("Ledger metadata for {} appears to already exist, checking cToken", (Object)ledgerId);
                    if (metadata.getMetadataFormatVersion() > 2) {
                        CompletableFuture<Versioned<LedgerMetadata>> readFuture = AbstractZkLedgerManager.this.readLedgerMetadata(ledgerId);
                        readFuture.handle((readMetadata, exception) -> {
                            if (exception == null) {
                                if (((LedgerMetadata)readMetadata.getValue()).getCToken() == cToken) {
                                    FutureUtils.complete((CompletableFuture)promise, new Versioned<LedgerMetadata>(metadata, new LongVersion(0L)));
                                } else {
                                    LOG.warn("Failed to create ledger metadata for {} which already exists", (Object)ledgerId);
                                    promise.completeExceptionally(new BKException.BKLedgerExistException());
                                }
                            } else if (exception instanceof KeeperException.NoNodeException) {
                                LOG.warn("Ledger {} appears to have already existed and then been removed, failing with LedgerExistException", (Object)ledgerId);
                                promise.completeExceptionally(new BKException.BKLedgerExistException());
                            } else {
                                LOG.error("Could not validate node for ledger {} after LedgerExistsException", (Object)ledgerId, exception);
                                promise.completeExceptionally(new BKException.ZKException((Throwable)exception));
                            }
                            return null;
                        });
                    } else {
                        LOG.warn("Failed to create ledger metadata for {} which already exists", (Object)ledgerId);
                        promise.completeExceptionally(new BKException.BKLedgerExistException());
                    }
                } else {
                    LOG.error("Could not create node for ledger {}", (Object)ledgerId, (Object)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    promise.completeExceptionally(new BKException.ZKException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path)));
                }
            }
        };
        try {
            data = this.serDe.serialize(metadata);
        }
        catch (IOException ioe) {
            promise.completeExceptionally(new BKException.BKMetadataSerializationException(ioe));
            return promise;
        }
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        ZkUtils.asyncCreateFullPathOptimistic(this.zk, ledgerPath, data, zkAcls, CreateMode.PERSISTENT, scb, null);
        return promise;
    }

    @Override
    public CompletableFuture<Void> removeLedgerMetadata(final long ledgerId, Version version) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        int znodeVersion = -1;
        if (Version.NEW == version) {
            LOG.error("Request to delete ledger {} metadata with version set to the initial one", (Object)ledgerId);
            promise.completeExceptionally(new BKException.BKMetadataVersionException());
            return promise;
        }
        if (Version.ANY != version) {
            if (!(version instanceof LongVersion)) {
                LOG.info("Not an instance of ZKVersion: {}", (Object)ledgerId);
                promise.completeExceptionally(new BKException.BKMetadataVersionException());
                return promise;
            }
            znodeVersion = (int)((LongVersion)version).getLongVersion();
        }
        AsyncCallback.VoidCallback callbackForDelete = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    LOG.warn("Ledger node does not exist in ZooKeeper: ledgerId={}.  Returning success.", (Object)ledgerId);
                    FutureUtils.complete((CompletableFuture)promise, null);
                } else if (rc == KeeperException.Code.OK.intValue()) {
                    Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.remove(ledgerId);
                    if (null != listenerSet) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Remove registered ledger metadata listeners on ledger {} after ledger is deleted.", (Object)ledgerId);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("No ledger metadata listeners to remove from ledger {} when it's being deleted.", (Object)ledgerId);
                    }
                    FutureUtils.complete((CompletableFuture)promise, null);
                } else {
                    promise.completeExceptionally(new BKException.ZKException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path)));
                }
            }
        };
        String ledgerZnodePath = this.getLedgerPath(ledgerId);
        if (this instanceof HierarchicalLedgerManager || this instanceof LongHierarchicalLedgerManager) {
            ZkUtils.asyncDeleteFullPathOptimistic(this.zk, ledgerZnodePath, znodeVersion, callbackForDelete, ledgerZnodePath);
        } else {
            this.zk.delete(ledgerZnodePath, znodeVersion, callbackForDelete, null);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        if (null != listener) {
            Set<BookkeeperInternalCallbacks.LedgerMetadataListener> listenerSet;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
            }
            if ((listenerSet = (HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>)this.listeners.get(ledgerId)) == null) {
                HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> newListenerSet = new HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>();
                Set oldListenerSet = this.listeners.putIfAbsent(ledgerId, newListenerSet);
                listenerSet = null != oldListenerSet ? oldListenerSet : newListenerSet;
            }
            HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> hashSet = listenerSet;
            synchronized (hashSet) {
                listenerSet.add(listener);
            }
            new ReadLedgerMetadataTask(ledgerId).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        Set listenerSet = (Set)this.listeners.get(ledgerId);
        if (listenerSet != null) {
            Set set = listenerSet;
            synchronized (set) {
                if (listenerSet.remove(listener) && LOG.isDebugEnabled()) {
                    LOG.debug("Unregistered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
                }
                if (listenerSet.isEmpty()) {
                    this.listeners.remove(ledgerId, listenerSet);
                    new CancelWatchLedgerMetadataTask(ledgerId).run();
                }
            }
        }
    }

    private void cancelMetadataWatch(final long ledgerId, Watcher watcher) {
        this.zk.removeWatches(this.getLedgerPath(ledgerId), watcher, Watcher.WatcherType.Data, true, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object o) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Cancel watch ledger {} metadata failed.", (Object)ledgerId, (Object)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cancel watch ledger {} metadata succeed.", (Object)ledgerId);
                }
            }
        }, null);
    }

    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
        return this.readLedgerMetadata(ledgerId, null);
    }

    protected CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(final long ledgerId, Watcher watcher) {
        final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        this.zk.getData(this.getLedgerPath(ledgerId), watcher, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No such ledger: " + ledgerId, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    }
                    promise.completeExceptionally(new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                    return;
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not read metadata for ledger: " + ledgerId, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    promise.completeExceptionally(new BKException.ZKException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path)));
                    return;
                }
                if (stat == null) {
                    LOG.error("Could not parse ledger metadata for ledger: {}. Stat object is null", (Object)ledgerId);
                    promise.completeExceptionally(new BKException.ZKException(new Exception("Could not parse ledger metadata for ledger: " + ledgerId + " . Stat object is null").fillInStackTrace()));
                    return;
                }
                try {
                    LongVersion version = new LongVersion(stat.getVersion());
                    LedgerMetadata metadata = AbstractZkLedgerManager.this.serDe.parseConfig(data, ledgerId, Optional.of(stat.getCtime()));
                    promise.complete(new Versioned<LedgerMetadata>(metadata, version));
                }
                catch (Throwable t) {
                    LOG.error("Could not parse ledger metadata for ledger: {}", (Object)ledgerId, (Object)t);
                    promise.completeExceptionally(new BKException.ZKException(new Exception("Could not parse ledger metadata for ledger: " + ledgerId, t).fillInStackTrace()));
                }
            }
        }, null);
        return promise;
    }

    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(final long ledgerId, final LedgerMetadata metadata, Version currentVersion) {
        byte[] data;
        final CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        if (!(currentVersion instanceof LongVersion)) {
            promise.completeExceptionally(new BKException.BKMetadataVersionException());
            return promise;
        }
        LongVersion zv = (LongVersion)currentVersion;
        try {
            data = this.serDe.serialize(metadata);
        }
        catch (IOException ioe) {
            promise.completeExceptionally(new BKException.BKMetadataSerializationException(ioe));
            return promise;
        }
        this.zk.setData(this.getLedgerPath(ledgerId), data, (int)zv.getLongVersion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (KeeperException.Code.BADVERSION.intValue() == rc) {
                    promise.completeExceptionally(new BKException.BKMetadataVersionException());
                } else if (KeeperException.Code.OK.intValue() == rc) {
                    promise.complete(new Versioned<LedgerMetadata>(metadata, new LongVersion(stat.getVersion())));
                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                    LOG.warn("Ledger node does not exist in ZooKeeper: ledgerId={}", (Object)ledgerId);
                    promise.completeExceptionally(new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                } else {
                    LOG.warn("Conditional update ledger metadata failed: {}", (Object)KeeperException.Code.get((int)rc));
                    promise.completeExceptionally(new BKException.ZKException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path)));
                }
            }
        }, null);
        return promise;
    }

    protected void asyncProcessLedgersInSingleNode(final String path, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object ctx, final int successRc, final int failureRc) {
        ZkUtils.getChildrenInSingleNode(this.zk, path, new BookkeeperInternalCallbacks.GenericCallback<List<String>>(){

            @Override
            public void operationComplete(int rc, List<String> ledgerNodes) {
                if (KeeperException.Code.NONODE.intValue() == rc) {
                    finalCb.processResult(successRc, null, ctx);
                    return;
                }
                if (KeeperException.Code.OK.intValue() != rc) {
                    finalCb.processResult(failureRc, null, ctx);
                    return;
                }
                NavigableSet<Long> zkActiveLedgers = AbstractZkLedgerManager.this.ledgerListToSet(ledgerNodes, path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing ledgers: {}", zkActiveLedgers);
                }
                if (zkActiveLedgers.size() == 0) {
                    finalCb.processResult(successRc, null, ctx);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback mcb = new BookkeeperInternalCallbacks.MultiCallback(zkActiveLedgers.size(), finalCb, ctx, successRc, failureRc);
                AbstractZkLedgerManager.this.scheduler.submit(() -> {
                    for (Long ledger : zkActiveLedgers) {
                        processor.process(ledger, mcb);
                    }
                });
            }
        });
    }

    public static boolean isSpecialZnode(String znode) {
        return "available".equals(znode) || "cookies".equals(znode) || "LAYOUT".equals(znode) || "INSTANCEID".equals(znode) || "underreplication".equals(znode) || AbstractZkLedgerManager.isLeadgerIdGeneratorZnode(znode);
    }

    public static boolean isLeadgerIdGeneratorZnode(String znode) {
        return "idgen".equals(znode) || "idgen-long".equals(znode) || znode.startsWith("ID-");
    }

    protected abstract String getLedgerParentNodeRegex();

    public boolean isLedgerParentNode(String znode) {
        return znode.matches(this.getLedgerParentNodeRegex());
    }

    protected NavigableSet<Long> ledgerListToSet(List<String> ledgerNodes, String path) {
        TreeSet<Long> zkActiveLedgers = new TreeSet<Long>();
        for (String ledgerNode : ledgerNodes) {
            if (AbstractZkLedgerManager.isSpecialZnode(ledgerNode)) continue;
            try {
                zkActiveLedgers.add(this.getLedgerId(path + "/" + ledgerNode));
            }
            catch (IOException e) {
                LOG.warn("Error extracting ledgerId from ZK ledger node: " + ledgerNode);
            }
        }
        return zkActiveLedgers;
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Error when closing zookeeper based ledger manager: ", (Throwable)e);
        }
    }

    protected class CancelWatchLedgerMetadataTask
    implements Runnable {
        final long ledgerId;

        CancelWatchLedgerMetadataTask(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        @Override
        public void run() {
            Set listeners = (Set)AbstractZkLedgerManager.this.listeners.get(this.ledgerId);
            if (!CollectionUtils.isEmpty((Collection)listeners)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Still watch ledgerId: {}, ignore this unwatch task.", (Object)this.ledgerId);
                }
                return;
            }
            AbstractZkLedgerManager.this.cancelMetadataWatch(this.ledgerId, AbstractZkLedgerManager.this);
        }
    }

    protected class ReadLedgerMetadataTask
    implements Runnable {
        final long ledgerId;

        ReadLedgerMetadataTask(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        @Override
        public void run() {
            if (null != AbstractZkLedgerManager.this.listeners.get(this.ledgerId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Re-read ledger metadata for {}.", (Object)this.ledgerId);
                }
                AbstractZkLedgerManager.this.readLedgerMetadata(this.ledgerId, AbstractZkLedgerManager.this).whenComplete((metadata, exception) -> this.handleMetadata((Versioned<LedgerMetadata>)metadata, (Throwable)exception));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ledger metadata listener for ledger {} is already removed.", (Object)this.ledgerId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMetadata(Versioned<LedgerMetadata> result, Throwable exception) {
            if (exception == null) {
                Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.get(this.ledgerId);
                if (null != listenerSet) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ledger metadata is changed for {} : {}.", (Object)this.ledgerId, result);
                    }
                    AbstractZkLedgerManager.this.scheduler.submit(() -> {
                        Set set = listenerSet;
                        synchronized (set) {
                            for (BookkeeperInternalCallbacks.LedgerMetadataListener listener : listenerSet) {
                                listener.onChanged(this.ledgerId, result);
                            }
                        }
                    });
                }
            } else if (BKException.getExceptionCode(exception) == -25) {
                Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.remove(this.ledgerId);
                if (null != listenerSet) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Removed ledger metadata listener set on ledger {} as its ledger is deleted : {}", (Object)this.ledgerId, (Object)listenerSet.size());
                    }
                    Set set = listenerSet;
                    synchronized (set) {
                        for (BookkeeperInternalCallbacks.LedgerMetadataListener listener : listenerSet) {
                            listener.onChanged(this.ledgerId, null);
                        }
                    }
                }
            } else {
                LOG.warn("Failed on read ledger metadata of ledger {}: {}", (Object)this.ledgerId, (Object)BKException.getExceptionCode(exception));
                AbstractZkLedgerManager.this.scheduler.schedule(this, 200L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

