/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import io.prestosql.server.Server;

public final class PrestoServer {
    private PrestoServer() {
    }

    public static void main(String[] args) {
        String javaVersion = Strings.nullToEmpty((String)StandardSystemProperty.JAVA_VERSION.value());
        String majorVersion = (String)Splitter.on((char)'.').split((CharSequence)javaVersion).iterator().next();
        Integer major = Ints.tryParse((String)majorVersion);
        if (major == null || major < 11) {
            System.err.println(String.format("ERROR: Presto requires Java 11+ (found %s)", javaVersion));
            System.exit(100);
        }
        String version = PrestoServer.class.getPackage().getImplementationVersion();
        new Server().start((String)MoreObjects.firstNonNull((Object)version, (Object)"unknown"));
    }
}

