/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type.setdigest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Shorts;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.cardinality.HyperLogLog;
import it.unimi.dsi.fastutil.longs.Long2ShortRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ShortSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjdk.jol.info.ClassLayout;

public class SetDigest {
    private static final byte UNCOMPRESSED_FORMAT = 1;
    public static final int NUMBER_OF_BUCKETS = 2048;
    public static final int DEFAULT_MAX_HASHES = 8192;
    private static final int SIZE_OF_ENTRY = 10;
    private static final int SIZE_OF_SETDIGEST = ClassLayout.parseClass(SetDigest.class).instanceSize();
    private static final int SIZE_OF_RBTREEMAP = ClassLayout.parseClass(Long2ShortRBTreeMap.class).instanceSize();
    private final HyperLogLog hll;
    private final Long2ShortSortedMap minhash;
    private final int maxHashes;

    public SetDigest() {
        this(8192, HyperLogLog.newInstance((int)2048), (Long2ShortSortedMap)new Long2ShortRBTreeMap());
    }

    public SetDigest(int maxHashes, int numHllBuckets) {
        this(maxHashes, HyperLogLog.newInstance((int)numHllBuckets), (Long2ShortSortedMap)new Long2ShortRBTreeMap());
    }

    public SetDigest(int maxHashes, HyperLogLog hll, Long2ShortSortedMap minhash) {
        this.maxHashes = maxHashes;
        this.hll = Objects.requireNonNull(hll, "hll is null");
        this.minhash = Objects.requireNonNull(minhash, "minhash is null");
    }

    public static SetDigest newInstance(Slice serialized) {
        Objects.requireNonNull(serialized, "serialized is null");
        BasicSliceInput input = serialized.getInput();
        Preconditions.checkArgument((input.readByte() == 1 ? 1 : 0) != 0, (Object)"Unexpected version");
        int hllLength = input.readInt();
        Slice serializedHll = Slices.allocate((int)hllLength);
        input.readBytes(serializedHll, hllLength);
        HyperLogLog hll = HyperLogLog.newInstance((Slice)serializedHll);
        Long2ShortRBTreeMap minhash = new Long2ShortRBTreeMap();
        int maxHashes = input.readInt();
        int minhashLength = input.readInt();
        BasicSliceInput valuesInput = serialized.getInput();
        valuesInput.setPosition(input.position() + (long)(minhashLength * 8));
        for (int i = 0; i < minhashLength; ++i) {
            minhash.put(input.readLong(), valuesInput.readShort());
        }
        return new SetDigest(maxHashes, hll, (Long2ShortSortedMap)minhash);
    }

    public Slice serialize() {
        LongBidirectionalIterator longBidirectionalIterator;
        DynamicSliceOutput output = new DynamicSliceOutput(this.estimatedSerializedSize());
        try {
            output.appendByte(1);
            Slice serializedHll = this.hll.serialize();
            output.appendInt(serializedHll.length());
            output.appendBytes(serializedHll);
            output.appendInt(this.maxHashes);
            output.appendInt(this.minhash.size());
            longBidirectionalIterator = this.minhash.keySet().iterator();
            while (longBidirectionalIterator.hasNext()) {
                long key = (Long)longBidirectionalIterator.next();
                output.appendLong(key);
            }
            longBidirectionalIterator = this.minhash.values().iterator();
            while (longBidirectionalIterator.hasNext()) {
                short value = (Short)longBidirectionalIterator.next();
                output.appendShort((int)value);
            }
            longBidirectionalIterator = output.slice();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        output.close();
        return longBidirectionalIterator;
    }

    public HyperLogLog getHll() {
        return this.hll;
    }

    public int estimatedInMemorySize() {
        return this.hll.estimatedInMemorySize() + this.minhash.size() * 10 + SIZE_OF_SETDIGEST + SIZE_OF_RBTREEMAP;
    }

    public int estimatedSerializedSize() {
        return 5 + this.hll.estimatedSerializedSize() + 8 + this.minhash.size() * 10;
    }

    public boolean isExact() {
        return this.minhash.size() < this.maxHashes;
    }

    public long cardinality() {
        if (this.isExact()) {
            return this.minhash.size();
        }
        return this.hll.cardinality();
    }

    public static long exactIntersectionCardinality(SetDigest a, SetDigest b) {
        Preconditions.checkState((boolean)a.isExact(), (Object)"exact intersection cannot operate on approximate sets");
        Preconditions.checkArgument((boolean)b.isExact(), (Object)"exact intersection cannot operate on approximate sets");
        return Sets.intersection((Set)a.minhash.keySet(), (Set)b.minhash.keySet()).size();
    }

    public static double jaccardIndex(SetDigest a, SetDigest b) {
        int sizeOfSmallerSet = Math.min(a.minhash.size(), b.minhash.size());
        LongRBTreeSet minUnion = new LongRBTreeSet(a.minhash.keySet());
        minUnion.addAll((LongCollection)b.minhash.keySet());
        int intersection = 0;
        int i = 0;
        LongBidirectionalIterator longBidirectionalIterator = minUnion.iterator();
        while (longBidirectionalIterator.hasNext()) {
            long key = (Long)longBidirectionalIterator.next();
            if (a.minhash.containsKey(key) && b.minhash.containsKey(key)) {
                ++intersection;
            }
            if (++i < sizeOfSmallerSet) continue;
            break;
        }
        return (double)intersection / (double)sizeOfSmallerSet;
    }

    public void add(long value) {
        this.addHash(Murmur3Hash128.hash64((long)value));
        this.hll.add(value);
    }

    public void add(Slice value) {
        this.addHash(Murmur3Hash128.hash64((Slice)value));
        this.hll.add(value);
    }

    private void addHash(long hash) {
        short value = this.minhash.get(hash);
        if (value < Short.MAX_VALUE) {
            this.minhash.put(hash, (short)(value + 1));
        }
        while (this.minhash.size() > this.maxHashes) {
            this.minhash.remove(this.minhash.lastLongKey());
        }
    }

    public void mergeWith(SetDigest other) {
        this.hll.mergeWith(other.hll);
        LongBidirectionalIterator iterator = other.minhash.keySet().iterator();
        while (iterator.hasNext()) {
            long key = iterator.nextLong();
            int count = this.minhash.get(key) + other.minhash.get(key);
            this.minhash.put(key, Shorts.saturatedCast((long)count));
        }
        while (this.minhash.size() > this.maxHashes) {
            this.minhash.remove(this.minhash.lastLongKey());
        }
    }

    public Map<Long, Short> getHashCounts() {
        return ImmutableMap.copyOf((Map)this.minhash);
    }
}

