/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.assertions;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Location;
import io.prestosql.spi.PrestoException;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.util.CheckReturnValue;

public final class PrestoExceptionAssert
extends AbstractThrowableAssert<PrestoExceptionAssert, PrestoException> {
    @CheckReturnValue
    public static PrestoExceptionAssert assertPrestoExceptionThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = Assertions.catchThrowable((ThrowableAssert.ThrowingCallable)throwingCallable);
        if (throwable == null) {
            Assertions.failBecauseExceptionWasNotThrown(PrestoException.class);
        }
        Assertions.assertThat((Throwable)throwable).isInstanceOf(PrestoException.class);
        return new PrestoExceptionAssert((PrestoException)throwable);
    }

    private PrestoExceptionAssert(PrestoException actual) {
        super((Throwable)actual, PrestoExceptionAssert.class);
    }

    public PrestoExceptionAssert hasErrorCode(ErrorCodeSupplier errorCodeSupplier) {
        try {
            Assertions.assertThat((Object)((PrestoException)((Object)this.actual)).getErrorCode()).isEqualTo((Object)errorCodeSupplier.toErrorCode());
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (PrestoExceptionAssert)this.myself;
    }

    public PrestoExceptionAssert hasLocation(int lineNumber, int columnNumber) {
        try {
            Assertions.assertThat((Optional)((PrestoException)((Object)this.actual)).getLocation()).isPresent();
            Assertions.assertThat((Object)((Location)((PrestoException)((Object)this.actual)).getLocation().get())).matches(location -> location.getColumnNumber() == columnNumber && location.getLineNumber() == lineNumber);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (PrestoExceptionAssert)this.myself;
    }
}

