/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.statistics.ColumnStatistics;
import io.prestosql.spi.statistics.DoubleRange;
import io.prestosql.spi.statistics.Estimate;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QueryBody;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.sql.tree.ShowStats;
import io.prestosql.sql.tree.SingleColumn;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.Table;
import io.prestosql.sql.tree.TableSubquery;
import io.prestosql.sql.tree.Values;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ShowStatsRewrite
implements StatementRewrite.Rewrite {
    private static final Expression NULL_DOUBLE = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)DoubleType.DOUBLE));
    private static final Expression NULL_VARCHAR = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR));

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(metadata, session, parameters, queryExplainer, accessControl, warningCollector).process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final List<Expression> parameters;
        private final Optional<QueryExplainer> queryExplainer;
        private final AccessControl accessControl;
        private final WarningCollector warningCollector;

        private Visitor(Metadata metadata, Session session, List<Expression> parameters, Optional<QueryExplainer> queryExplainer, AccessControl accessControl, WarningCollector warningCollector) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitShowStats(ShowStats node, Void context) {
            Plan plan;
            Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"Query explainer must be provided for SHOW STATS SELECT");
            Query query = this.getRelationQuery(node);
            QuerySpecification specification = (QuerySpecification)query.getQueryBody();
            try {
                plan = this.queryExplainer.get().getLogicalPlan(this.session, (Statement)QueryUtil.query((QueryBody)specification), this.parameters, this.warningCollector);
            }
            catch (AccessDeniedException e) {
                throw this.rewriteAccessDeniedException(e);
            }
            Table table = this.getTable(node, specification);
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, table.getName());
            TableHandle tableHandle = this.metadata.getTableHandle(this.session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "Table '%s' not found", table.getName()));
            TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle);
            Set<String> columnNames = this.extractStatsColumns(tableMetadata, specification.getSelect().getSelectItems());
            try {
                this.accessControl.checkCanSelectFromColumns(this.session.toSecurityContext(), tableName, columnNames);
            }
            catch (AccessDeniedException e) {
                throw this.rewriteAccessDeniedException(e);
            }
            for (String columnName : columnNames) {
                ColumnMetadata column = tableMetadata.getColumn(columnName);
                if (this.accessControl.getColumnMasks(this.session.toSecurityContext(), tableName, columnName, column.getType()).isEmpty()) continue;
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SHOW STATS for table with column masking is not supported: " + columnName);
            }
            if (!this.accessControl.getRowFilters(this.session.toSecurityContext(), tableName).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SHOW STATS is not supported for a table with row filtering");
            }
            this.validateShowStatsSubquery(node, query, specification, plan);
            return this.rewriteShowStats(table, tableHandle, tableMetadata, columnNames, columnHandles, this.getConstraint(plan));
        }

        private Query getRelationQuery(ShowStats node) {
            if (node.getRelation() instanceof Table) {
                return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)node.getRelation());
            }
            if (node.getRelation() instanceof TableSubquery) {
                return ((TableSubquery)node.getRelation()).getQuery();
            }
            throw new IllegalArgumentException("Expected either TableSubquery or Table as relation");
        }

        private Table getTable(ShowStats node, QuerySpecification specification) {
            Visitor.check(specification.getFrom().isPresent(), (Node)node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
            Visitor.check(specification.getFrom().isPresent(), (Node)node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
            Visitor.check(specification.getFrom().get() instanceof Table, (Node)node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
            return (Table)specification.getFrom().get();
        }

        private AccessDeniedException rewriteAccessDeniedException(AccessDeniedException original) {
            return new AccessDeniedException(original.getMessage().replace("Access Denied: ", "").replace("Cannot select from", "Cannot show stats for"));
        }

        private void validateShowStatsSubquery(ShowStats node, Query query, QuerySpecification querySpecification, Plan plan) {
            Optional filterNode = PlanNodeSearcher.searchFrom(plan.getRoot()).where(FilterNode.class::isInstance).findSingle();
            Visitor.check(filterNode.isEmpty(), (Node)node, "Only predicates that can be pushed down are supported in the SHOW STATS WHERE clause");
            Visitor.check(query.getWith().isEmpty(), (Node)node, "WITH is not supported by SHOW STATS SELECT clause");
            Visitor.check(querySpecification.getOrderBy().isEmpty(), (Node)node, "ORDER BY is not supported in SHOW STATS SELECT clause");
            Visitor.check(querySpecification.getLimit().isEmpty(), (Node)node, "LIMIT is not supported by SHOW STATS SELECT clause");
            Visitor.check(querySpecification.getHaving().isEmpty(), (Node)node, "HAVING is not supported in SHOW STATS SELECT clause");
            Visitor.check(querySpecification.getGroupBy().isEmpty(), (Node)node, "GROUP BY is not supported in SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getSelect().isDistinct(), (Node)node, "DISTINCT is not supported by SHOW STATS SELECT clause");
        }

        private Node rewriteShowStats(Table table, TableHandle tableHandle, TableMetadata tableMetadata, Set<String> columnNames, Map<String, ColumnHandle> columnHandles, Constraint constraint) {
            TableStatistics tableStatistics = this.metadata.getTableStatistics(this.session, tableHandle, constraint);
            List<Expression> resultRows = this.buildStatisticsRows(tableMetadata, columnHandles, columnNames, tableStatistics);
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll(Visitor.buildSelectItems(Visitor.buildColumnsNames())), (Relation)QueryUtil.aliased((Relation)new Values(resultRows), (String)("table_stats_for_" + table.getName()), Visitor.buildColumnsNames()));
        }

        private Set<String> extractStatsColumns(TableMetadata metadata, List<SelectItem> selectItems) {
            ImmutableSet.Builder columns = ImmutableSet.builder();
            for (SelectItem item : selectItems) {
                if (item instanceof AllColumns) {
                    for (ColumnMetadata column : metadata.getColumns()) {
                        if (column.isHidden()) continue;
                        columns.add((Object)column.getName());
                    }
                }
                if (!(item instanceof SingleColumn)) continue;
                SingleColumn column = (SingleColumn)item;
                Expression expression = column.getExpression();
                Visitor.check(expression instanceof Identifier, (Node)expression, "Only table columns names are supported in SHOW STATS SELECT clause");
                Identifier identifier = (Identifier)expression;
                Visitor.check(column.getAlias().isEmpty(), (Node)column, "Column aliasing is not supported in SHOW STATS SELECT clause");
                columns.add((Object)identifier.getValue());
            }
            return columns.build();
        }

        private static void check(boolean condition, Node node, String message) {
            if (!condition) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, message, new Object[0]);
            }
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        private Constraint getConstraint(Plan plan) {
            Optional scanNode = PlanNodeSearcher.searchFrom(plan.getRoot()).where(TableScanNode.class::isInstance).findSingle();
            if (scanNode.isEmpty()) {
                return Constraint.alwaysFalse();
            }
            return new Constraint(this.metadata.getTableProperties(this.session, ((TableScanNode)scanNode.get()).getTable()).getPredicate());
        }

        private static List<String> buildColumnsNames() {
            return ImmutableList.builder().add((Object)"column_name").add((Object)"data_size").add((Object)"distinct_values_count").add((Object)"nulls_fraction").add((Object)"row_count").add((Object)"low_value").add((Object)"high_value").build();
        }

        private static List<SelectItem> buildSelectItems(List<String> columnNames) {
            return (List)columnNames.stream().map(QueryUtil::unaliasedName).collect(ImmutableList.toImmutableList());
        }

        private List<Expression> buildStatisticsRows(TableMetadata tableMetadata, Map<String, ColumnHandle> columnHandles, Set<String> resultColumns, TableStatistics tableStatistics) {
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                if (columnMetadata.isHidden()) continue;
                String columnName = columnMetadata.getName();
                Type columnType = columnMetadata.getType();
                if (!resultColumns.contains(columnName)) continue;
                ColumnHandle columnHandle = columnHandles.get(columnName);
                ColumnStatistics columnStatistics = (ColumnStatistics)tableStatistics.getColumnStatistics().get(columnHandle);
                if (columnStatistics != null) {
                    rowsBuilder.add((Object)this.createColumnStatsRow(columnName, columnType, columnStatistics));
                    continue;
                }
                rowsBuilder.add((Object)this.createEmptyColumnStatsRow(columnName));
            }
            rowsBuilder.add((Object)Visitor.createTableStatsRow(tableStatistics));
            return rowsBuilder.build();
        }

        private Row createColumnStatsRow(String columnName, Type type, ColumnStatistics columnStatistics) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)new StringLiteral(columnName));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getDataSize()));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getDistinctValuesCount()));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getNullsFraction()));
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)Visitor.toStringLiteral(type, columnStatistics.getRange().map(DoubleRange::getMin)));
            rowValues.add((Object)Visitor.toStringLiteral(type, columnStatistics.getRange().map(DoubleRange::getMax)));
            return new Row((List)rowValues.build());
        }

        private Expression createEmptyColumnStatsRow(String columnName) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)new StringLiteral(columnName));
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            return new Row((List)rowValues.build());
        }

        private static Row createTableStatsRow(TableStatistics tableStatistics) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)Visitor.createEstimateRepresentation(tableStatistics.getRowCount()));
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            return new Row((List)rowValues.build());
        }

        private static Expression createEstimateRepresentation(Estimate estimate) {
            if (estimate.isUnknown()) {
                return NULL_DOUBLE;
            }
            return new DoubleLiteral(Double.toString(estimate.getValue()));
        }

        private static Expression toStringLiteral(Type type, Optional<Double> optionalValue) {
            return optionalValue.map(value -> Visitor.toStringLiteral(type, value)).orElse(NULL_VARCHAR);
        }

        private static Expression toStringLiteral(Type type, double value) {
            if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
                return new StringLiteral(Long.toString(Math.round(value)));
            }
            if (type.equals(DoubleType.DOUBLE) || type instanceof DecimalType) {
                return new StringLiteral(Double.toString(value));
            }
            if (type.equals(RealType.REAL)) {
                return new StringLiteral(Float.toString((float)value));
            }
            if (type.equals(DateType.DATE)) {
                return new StringLiteral(LocalDate.ofEpochDay(Math.round(value)).toString());
            }
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }
}

