/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;

public final class AllFunctionsResolved
implements PlanSanityChecker.Checker {
    private static final Visitor VISITOR = new Visitor();

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        ExpressionExtractor.forEachExpression(planNode, AllFunctionsResolved::validate);
    }

    private static void validate(Expression expression) {
        VISITOR.process((Node)expression, null);
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private Visitor() {
        }

        protected Void visitFunctionCall(FunctionCall node, ImmutableList.Builder<Symbol> context) {
            Preconditions.checkArgument((boolean)ResolvedFunction.fromQualifiedName(node.getName()).isPresent(), (String)"Function call has not been resolved: %s", (Object)node);
            return super.visitFunctionCall(node, context);
        }
    }
}

