/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RowNumberNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final boolean orderSensitive;
    private final Optional<Integer> maxRowCountPerPartition;
    private final Symbol rowNumberSymbol;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public RowNumberNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderSensitive") boolean orderSensitive, @JsonProperty(value="rowNumberSymbol") Symbol rowNumberSymbol, @JsonProperty(value="maxRowCountPerPartition") Optional<Integer> maxRowCountPerPartition, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(partitionBy, "partitionBy is null");
        Preconditions.checkArgument((!orderSensitive || partitionBy.isEmpty() ? 1 : 0) != 0, (Object)"unexpected partitioning in order sensitive node");
        Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        Preconditions.checkArgument((maxRowCountPerPartition.isEmpty() || maxRowCountPerPartition.get() > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be greater than zero");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderSensitive = orderSensitive;
        this.rowNumberSymbol = rowNumberSymbol;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rowNumberSymbol)));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    @JsonProperty
    public Symbol getRowNumberSymbol() {
        return this.rowNumberSymbol;
    }

    @JsonProperty
    public Optional<Integer> getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRowNumber(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new RowNumberNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.partitionBy, this.orderSensitive, this.rowNumberSymbol, this.maxRowCountPerPartition, this.hashSymbol);
    }
}

