/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.optimizations.StreamPropertyDerivations;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class StreamPreferredProperties {
    private final Optional<StreamPropertyDerivations.StreamProperties.StreamDistribution> distribution;
    private final boolean exactColumnOrder;
    private final Optional<List<Symbol>> partitioningColumns;
    private final boolean orderSensitive;

    private StreamPreferredProperties(Optional<StreamPropertyDerivations.StreamProperties.StreamDistribution> distribution, Optional<? extends Iterable<Symbol>> partitioningColumns, boolean orderSensitive) {
        this(distribution, false, partitioningColumns, orderSensitive);
    }

    private StreamPreferredProperties(Optional<StreamPropertyDerivations.StreamProperties.StreamDistribution> distribution, boolean exactColumnOrder, Optional<? extends Iterable<Symbol>> partitioningColumns, boolean orderSensitive) {
        this.distribution = Objects.requireNonNull(distribution, "distribution is null");
        this.partitioningColumns = Objects.requireNonNull(partitioningColumns, "partitioningColumns is null").map(ImmutableList::copyOf);
        this.exactColumnOrder = exactColumnOrder;
        this.orderSensitive = orderSensitive;
        Preconditions.checkArgument((!orderSensitive || partitioningColumns.isEmpty() ? 1 : 0) != 0, (Object)"An order sensitive context cannot prefer partitioning");
    }

    public static StreamPreferredProperties any() {
        return new StreamPreferredProperties(Optional.empty(), Optional.empty(), false);
    }

    public static StreamPreferredProperties singleStream() {
        return new StreamPreferredProperties(Optional.of(StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE), Optional.empty(), false);
    }

    public static StreamPreferredProperties fixedParallelism() {
        return new StreamPreferredProperties(Optional.of(StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED), Optional.empty(), false);
    }

    public static StreamPreferredProperties defaultParallelism(Session session) {
        if (SystemSessionProperties.getTaskConcurrency(session) > 1 && !SystemSessionProperties.preferStreamingOperators(session)) {
            return new StreamPreferredProperties(Optional.of(StreamPropertyDerivations.StreamProperties.StreamDistribution.MULTIPLE), Optional.empty(), false);
        }
        return StreamPreferredProperties.any();
    }

    public StreamPreferredProperties withParallelism() {
        if (this.isParallelPreferred()) {
            return this;
        }
        return new StreamPreferredProperties(Optional.of(StreamPropertyDerivations.StreamProperties.StreamDistribution.MULTIPLE), Optional.empty(), this.orderSensitive);
    }

    public StreamPreferredProperties withFixedParallelism() {
        if (this.distribution.isPresent() && this.distribution.get() == StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED) {
            return this;
        }
        return StreamPreferredProperties.fixedParallelism();
    }

    public static StreamPreferredProperties exactlyPartitionedOn(Collection<Symbol> partitionSymbols) {
        if (partitionSymbols.isEmpty()) {
            return StreamPreferredProperties.singleStream();
        }
        return new StreamPreferredProperties(Optional.of(StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED), true, Optional.of(ImmutableList.copyOf(partitionSymbols)), false);
    }

    public StreamPreferredProperties withoutPreference() {
        return new StreamPreferredProperties(Optional.empty(), Optional.empty(), this.orderSensitive);
    }

    public StreamPreferredProperties withPartitioning(Collection<Symbol> partitionSymbols) {
        if (partitionSymbols.isEmpty()) {
            return StreamPreferredProperties.singleStream();
        }
        Sets.SetView desiredPartitioning = partitionSymbols;
        if (this.partitioningColumns.isPresent()) {
            if (this.exactColumnOrder) {
                if (this.partitioningColumns.get().equals(desiredPartitioning)) {
                    return this;
                }
            } else {
                Sets.SetView common = Sets.intersection((Set)ImmutableSet.copyOf(desiredPartitioning), (Set)ImmutableSet.copyOf((Collection)this.partitioningColumns.get()));
                if (!common.isEmpty()) {
                    desiredPartitioning = common;
                }
            }
        }
        return new StreamPreferredProperties(this.distribution, Optional.of(desiredPartitioning), false);
    }

    public StreamPreferredProperties withDefaultParallelism(Session session) {
        if (SystemSessionProperties.getTaskConcurrency(session) > 1 && !SystemSessionProperties.preferStreamingOperators(session)) {
            return this.withParallelism();
        }
        return this;
    }

    public boolean isSatisfiedBy(StreamPropertyDerivations.StreamProperties actualProperties) {
        if (this.distribution.isEmpty() && this.partitioningColumns.isEmpty()) {
            return true;
        }
        if (this.isOrderSensitive() && actualProperties.isOrdered()) {
            return true;
        }
        if (this.distribution.isPresent()) {
            StreamPropertyDerivations.StreamProperties.StreamDistribution actualDistribution = actualProperties.getDistribution();
            if (this.distribution.get() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE && actualDistribution != StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE) {
                return false;
            }
            if (this.distribution.get() == StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED && actualDistribution != StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED) {
                return false;
            }
            if (this.distribution.get() == StreamPropertyDerivations.StreamProperties.StreamDistribution.MULTIPLE && actualDistribution != StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED && actualDistribution != StreamPropertyDerivations.StreamProperties.StreamDistribution.MULTIPLE) {
                return false;
            }
        } else if (actualProperties.getDistribution() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE) {
            return true;
        }
        if (this.partitioningColumns.isPresent()) {
            if (this.exactColumnOrder) {
                return actualProperties.isExactlyPartitionedOn((Iterable<Symbol>)this.partitioningColumns.get());
            }
            return actualProperties.isPartitionedOn((Iterable<Symbol>)this.partitioningColumns.get());
        }
        return true;
    }

    public boolean isSingleStreamPreferred() {
        return this.distribution.isPresent() && this.distribution.get() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE;
    }

    public boolean isParallelPreferred() {
        return this.distribution.isPresent() && this.distribution.get() != StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE;
    }

    public Optional<List<Symbol>> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public StreamPreferredProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        return new StreamPreferredProperties(this.distribution, this.partitioningColumns.flatMap(partitioning -> StreamPreferredProperties.translateSymbols(partitioning, translator)), this.orderSensitive);
    }

    private static Optional<List<Symbol>> translateSymbols(Iterable<Symbol> partitioning, Function<Symbol, Optional<Symbol>> translator) {
        ImmutableList.Builder newPartitioningColumns = ImmutableList.builder();
        for (Symbol partitioningColumn : partitioning) {
            Optional<Symbol> translated = translator.apply(partitioningColumn);
            if (translated.isEmpty()) {
                return Optional.empty();
            }
            newPartitioningColumns.add((Object)translated.get());
        }
        return Optional.of(newPartitioningColumns.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distribution", this.distribution.orElse(null)).add("partitioningColumns", this.partitioningColumns.orElse(null)).omitNullValues().toString();
    }

    public StreamPreferredProperties withOrderSensitivity() {
        return new StreamPreferredProperties(this.distribution, false, Optional.empty(), true);
    }

    public StreamPreferredProperties constrainTo(Iterable<Symbol> symbols) {
        if (this.partitioningColumns.isEmpty()) {
            return this;
        }
        ImmutableSet availableSymbols = ImmutableSet.copyOf(symbols);
        if (this.exactColumnOrder) {
            if (availableSymbols.containsAll((Collection)this.partitioningColumns.get())) {
                return this;
            }
            return StreamPreferredProperties.any();
        }
        List common = (List)this.partitioningColumns.get().stream().filter(arg_0 -> ((ImmutableSet)availableSymbols).contains(arg_0)).collect(ImmutableList.toImmutableList());
        if (common.isEmpty()) {
            return StreamPreferredProperties.any();
        }
        return new StreamPreferredProperties(this.distribution, Optional.of(common), false);
    }
}

