/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RemoveRedundantTableScanPredicate
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;
    private final DomainTranslator domainTranslator;

    public RemoveRedundantTableScanPredicate(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new DomainTranslator(metadata);
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        PlanNode rewritten = this.removeRedundantTableScanPredicate(tableScan, filterNode.getPredicate(), context.getSession(), context.getSymbolAllocator().getTypes(), context.getIdAllocator());
        if (rewritten instanceof FilterNode && Objects.equals(((FilterNode)rewritten).getPredicate(), filterNode.getPredicate())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewritten);
    }

    private PlanNode removeRedundantTableScanPredicate(TableScanNode node, Expression predicate, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator) {
        ImmutableMap.Builder unenforcedColumnDomains;
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(this.metadata, predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, session, deterministicPredicate, types);
        TupleDomain predicateDomain = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get);
        if (predicateDomain.getDomains().isPresent()) {
            Map predicateColumnDomains = (Map)predicateDomain.getDomains().get();
            Preconditions.checkState((boolean)node.getEnforcedConstraint().getDomains().isPresent());
            Map enforcedColumnDomains = (Map)node.getEnforcedConstraint().getDomains().get();
            unenforcedColumnDomains = ImmutableMap.builder();
            for (Map.Entry entry : predicateColumnDomains.entrySet()) {
                ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
                Domain predicateColumnDomain = (Domain)entry.getValue();
                Domain enforcedColumnDomain = enforcedColumnDomains.getOrDefault(columnHandle, Domain.all((Type)predicateColumnDomain.getType()));
                if ((predicateColumnDomain = predicateColumnDomain.intersect(enforcedColumnDomain)).contains(enforcedColumnDomain)) continue;
                unenforcedColumnDomains.put((Object)columnHandle, (Object)predicateColumnDomain);
            }
        } else {
            return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of());
        }
        TupleDomain unenforcedDomain = TupleDomain.withColumnDomains((Map)unenforcedColumnDomains.build());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(this.metadata, this.domainTranslator.toPredicate((TupleDomain<Symbol>)unenforcedDomain.transform(((Map)assignments)::get)), nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(idAllocator.getNextId(), node, resultingPredicate);
        }
        return node;
    }
}

