/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.planner.SimplePlanVisitor;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class SchedulingOrderVisitor {
    public static List<PlanNodeId> scheduleOrder(PlanNode root) {
        ImmutableList.Builder schedulingOrder = ImmutableList.builder();
        root.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0)), null);
        return schedulingOrder.build();
    }

    private SchedulingOrderVisitor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Consumer<PlanNodeId> schedulingOrder;

        public Visitor(Consumer<PlanNodeId> schedulingOrder) {
            this.schedulingOrder = Objects.requireNonNull(schedulingOrder, "schedulingOrder is null");
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getRight().accept(this, context);
            node.getLeft().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getFilteringSource().accept(this, context);
            node.getSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            node.getRight().accept(this, context);
            node.getLeft().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            node.getIndexSource().accept(this, context);
            node.getProbeSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.schedulingOrder.accept(node.getId());
            return null;
        }
    }
}

