/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.cost.CachingCostProvider;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.NewTableLayout;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.RelationId;
import io.prestosql.sql.analyzer.RelationType;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.QueryPlanner;
import io.prestosql.sql.planner.RelationPlan;
import io.prestosql.sql.planner.RelationPlanner;
import io.prestosql.sql.planner.StatisticsAggregationPlanner;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.StatisticAggregations;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.Analyze;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CreateTableAsSelect;
import io.prestosql.sql.tree.Delete;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.Insert;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.type.TypeCoercion;
import io.prestosql.type.UnknownType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanSanityChecker planSanityChecker;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;
    private final TypeCoercion typeCoercion;
    private final TypeAnalyzer typeAnalyzer;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final WarningCollector warningCollector;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata, TypeAnalyzer typeAnalyzer, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this(session, planOptimizers, PlanSanityChecker.DISTRIBUTED_PLAN_SANITY_CHECKER, idAllocator, metadata, typeAnalyzer, statsCalculator, costCalculator, warningCollector);
    }

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanSanityChecker planSanityChecker, PlanNodeIdAllocator idAllocator, Metadata metadata, TypeAnalyzer typeAnalyzer, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planSanityChecker = Objects.requireNonNull(planSanityChecker, "planSanityChecker is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeCoercion = new TypeCoercion(metadata::getType);
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(this.symbolAllocator, metadata);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Plan plan(Analysis analysis) {
        return this.plan(analysis, Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan plan(Analysis analysis, Stage stage) {
        return this.plan(analysis, stage, analysis.getStatement() instanceof Explain || SystemSessionProperties.isCollectPlanStatisticsForAllQueries(this.session));
    }

    public Plan plan(Analysis analysis, Stage stage, boolean collectPlanStatistics) {
        PlanNode root = this.planStatement(analysis, analysis.getStatement());
        this.planSanityChecker.validateIntermediatePlan(root, this.session, this.metadata, this.typeAnalyzer, this.symbolAllocator.getTypes(), this.warningCollector);
        if (stage.ordinal() >= Stage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
            }
        }
        if (stage.ordinal() >= Stage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planSanityChecker.validateFinalPlan(root, this.session, this.metadata, this.typeAnalyzer, this.symbolAllocator.getTypes(), this.warningCollector);
        }
        TypeProvider types = this.symbolAllocator.getTypes();
        StatsAndCosts statsAndCosts = StatsAndCosts.empty();
        if (collectPlanStatistics) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session, types);
            statsAndCosts = StatsAndCosts.create(root, statsProvider, costProvider);
        }
        return new Plan(root, types, statsAndCosts);
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.getCreate().get().isCreateTableAsSelectNoOp()) {
            Symbol symbol = this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of((Object)symbol), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("0"))));
            return new OutputNode(this.idAllocator.getNextId(), source, (List<String>)ImmutableList.of((Object)"rows"), (List<Symbol>)ImmutableList.of((Object)symbol));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.getCreate().get().isCreateTableAsSelectNoOp()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Analyze) {
            return this.createAnalyzePlan(analysis, (Analyze)statement);
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze()) {
            return this.createExplainAnalyzePlan(analysis, (Explain)statement);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, Explain statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        Symbol outputSymbol = this.symbolAllocator.newSymbol(scope.getRelationType().getFieldByIndex(0));
        root = new ExplainAnalyzeNode(this.idAllocator.getNextId(), root, outputSymbol, statement.isVerbose());
        return new RelationPlan(root, scope, (List<Symbol>)ImmutableList.of((Object)outputSymbol));
    }

    private RelationPlan createAnalyzePlan(Analysis analysis, Analyze analyzeStatement) {
        TableHandle targetTable = analysis.getAnalyzeTarget().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTable);
        ImmutableList.Builder tableScanOutputs = ImmutableList.builder();
        ImmutableMap.Builder symbolToColumnHandle = ImmutableMap.builder();
        ImmutableMap.Builder columnNameToSymbol = ImmutableMap.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTable);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Symbol symbol = this.symbolAllocator.newSymbol(column.getName(), column.getType());
            tableScanOutputs.add((Object)symbol);
            symbolToColumnHandle.put((Object)symbol, (Object)columnHandles.get(column.getName()));
            columnNameToSymbol.put((Object)column.getName(), (Object)symbol);
        }
        TableStatisticsMetadata tableStatisticsMetadata = this.metadata.getStatisticsCollectionMetadata(this.session, targetTable.getCatalogName().getCatalogName(), tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation tableStatisticAggregation = this.statisticsAggregationPlanner.createStatisticsAggregation(tableStatisticsMetadata, (Map<String, Symbol>)columnNameToSymbol.build());
        StatisticAggregations statisticAggregations = tableStatisticAggregation.getAggregations();
        List<Symbol> groupingSymbols = statisticAggregations.getGroupingSymbols();
        StatisticsWriterNode planNode = new StatisticsWriterNode(this.idAllocator.getNextId(), new AggregationNode(this.idAllocator.getNextId(), TableScanNode.newInstance(this.idAllocator.getNextId(), targetTable, (List<Symbol>)tableScanOutputs.build(), (Map<Symbol, ColumnHandle>)symbolToColumnHandle.build()), statisticAggregations.getAggregations(), AggregationNode.singleGroupingSet(groupingSymbols), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), new StatisticsWriterNode.WriteStatisticsReference(targetTable), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), tableStatisticsMetadata.getTableStatistics().contains(TableStatisticType.ROW_COUNT), tableStatisticAggregation.getDescriptor());
        return new RelationPlan(planNode, analysis.getScope((Node)analyzeStatement), ((PlanNode)planNode).getOutputSymbols());
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        Analysis.Create create = analysis.getCreate().get();
        QualifiedObjectName destination = create.getDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis, query);
        if (!create.isCreateTableAsSelectWithData()) {
            LimitNode root = new LimitNode(this.idAllocator.getNextId(), plan.getRoot(), 0L, false);
            plan = new RelationPlan(root, plan.getScope(), plan.getFieldMappings());
        }
        ConnectorTableMetadata tableMetadata = create.getMetadata().get();
        Optional<NewTableLayout> newTableLayout = create.getLayout();
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateReference(destination.getCatalogName(), tableMetadata, newTableLayout), columnNames, newTableLayout, statisticsMetadata);
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insert = analysis.getInsert().get();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, insert.getTarget());
        RelationPlan plan = this.createRelationPlan(analysis, insertStatement.getQuery());
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, insert.getTarget());
        Assignments.Builder assignments = Assignments.builder();
        boolean supportsMissingColumnsOnInsert = this.metadata.supportsMissingColumnsOnInsert(this.session, insert.getTarget());
        ImmutableList.Builder insertedColumnsBuilder = ImmutableList.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            Symbol output = this.symbolAllocator.newSymbol(column2.getName(), column2.getType());
            int index = insert.getColumns().indexOf(columns.get(column2.getName()));
            if (index < 0) {
                if (supportsMissingColumnsOnInsert) continue;
                Cast cast = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(column2.getType()));
                assignments.put(output, (Expression)cast);
                insertedColumnsBuilder.add((Object)column2);
                continue;
            }
            Symbol input = plan.getSymbol(index);
            Type tableType = column2.getType();
            Type queryType = this.symbolAllocator.getTypes().get(input);
            if (queryType.equals(tableType) || this.typeCoercion.isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, (Expression)input.toSymbolReference());
            } else {
                Expression cast = this.noTruncationCast((Expression)input.toSymbolReference(), queryType, tableType);
                assignments.put(output, cast);
            }
            insertedColumnsBuilder.add((Object)column2);
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        ImmutableList insertedColumns = insertedColumnsBuilder.build();
        List fields = (List)insertedColumns.stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
        plan = new RelationPlan(projectNode, scope, projectNode.getOutputSymbols());
        String catalogName = insert.getTarget().getCatalogName().getCatalogName();
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
        List insertedTableColumnNames = (List)insertedColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.InsertReference(insert.getTarget(), (List)insertedTableColumnNames.stream().map(columns::get).collect(ImmutableList.toImmutableList())), insertedTableColumnNames, insert.getNewTableLayout(), statisticsMetadata);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, Optional<NewTableLayout> writeTableLayout, TableStatisticsMetadata statisticsMetadata) {
        PlanNode source = plan.getRoot();
        List<Symbol> symbols = plan.getFieldMappings();
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        if (writeTableLayout.isPresent()) {
            ArrayList<Symbol> partitionFunctionArguments = new ArrayList<Symbol>();
            writeTableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).forEach(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            Optional<PartitioningHandle> partitioningHandle = writeTableLayout.get().getPartitioning();
            if (partitioningHandle.isPresent()) {
                partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(partitioningHandle.get(), partitionFunctionArguments), outputLayout));
            } else if (SystemSessionProperties.isUsePreferredWritePartitioning(this.session)) {
                partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitionFunctionArguments), outputLayout));
            }
        }
        if (!statisticsMetadata.isEmpty()) {
            Verify.verify((columnNames.size() == symbols.size() ? 1 : 0) != 0, (String)"columnNames.size() != symbols.size(): %s and %s", columnNames, symbols);
            Map columnToSymbolMap = (Map)Streams.zip(columnNames.stream(), symbols.stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            StatisticsAggregationPlanner.TableStatisticAggregation result = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnToSymbolMap);
            StatisticAggregations.Parts aggregations = result.getAggregations().createPartialAggregations(this.symbolAllocator, this.metadata);
            StatisticAggregations partialAggregation = aggregations.getPartialAggregation();
            TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), symbols, columnNames, partitioningScheme, Optional.of(partialAggregation), Optional.of(result.getDescriptor().map(aggregations.getMappings()::get))), target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.of(aggregations.getFinalAggregation()), Optional.of(result.getDescriptor()));
            return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols());
        }
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), symbols, columnNames, partitioningScheme, Optional.empty(), Optional.empty()), target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols());
    }

    private Expression noTruncationCast(Expression expression, Type fromType, Type toType) {
        int targetLength;
        if (fromType instanceof UnknownType || !(toType instanceof VarcharType) && !(toType instanceof CharType)) {
            return new Cast(expression, TypeSignatureTranslator.toSqlType(toType));
        }
        if (toType instanceof VarcharType) {
            if (((VarcharType)toType).isUnbounded()) {
                return new Cast(expression, TypeSignatureTranslator.toSqlType(toType));
            }
            targetLength = ((VarcharType)toType).getBoundedLength();
        } else {
            targetLength = ((CharType)toType).getLength();
        }
        Preconditions.checkState((fromType instanceof VarcharType || fromType instanceof CharType ? 1 : 0) != 0, (Object)"inserting non-character value to column of character type");
        ResolvedFunction spaceTrimmedLength = this.metadata.resolveFunction(QualifiedName.of((String)"$space_trimmed_length"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
        ResolvedFunction fail = this.metadata.resolveFunction(QualifiedName.of((String)"fail"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
        return new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new GenericLiteral("BIGINT", Integer.toString(targetLength)), (Expression)new CoalesceExpression((Expression)new FunctionCall(spaceTrimmedLength.toQualifiedName(), (List)ImmutableList.of((Object)new Cast(expression, TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)))), (Expression)new GenericLiteral("BIGINT", "0"), new Expression[0])), (Expression)new Cast(expression, TypeSignatureTranslator.toSqlType(toType)), (Expression)new Cast((Expression)new FunctionCall(fail.toQualifiedName(), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("Cannot truncate non-space characters on INSERT"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)))), TypeSignatureTranslator.toSqlType(toType)));
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        DeleteNode deleteNode = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).plan(node);
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputSymbols());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).process((Node)query, null);
    }

    private static Map<NodeRef<LambdaArgumentDeclaration>, Symbol> buildLambdaDeclarationToSymbolMap(Analysis analysis, SymbolAllocator symbolAllocator) {
        HashMap<Key, Symbol> allocations = new HashMap<Key, Symbol>();
        LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol> result = new LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol>();
        for (Map.Entry<NodeRef<Expression>, Type> entry : analysis.getTypes().entrySet()) {
            if (!(entry.getKey().getNode() instanceof LambdaArgumentDeclaration)) continue;
            LambdaArgumentDeclaration argument = (LambdaArgumentDeclaration)entry.getKey().getNode();
            Key key = new Key(argument, entry.getValue());
            Symbol symbol = (Symbol)allocations.get(key);
            if (symbol == null) {
                symbol = symbolAllocator.newSymbol((Expression)argument, entry.getValue());
                allocations.put(key, symbol);
            }
            result.put((NodeRef<LambdaArgumentDeclaration>)NodeRef.of((Node)argument), symbol);
        }
        return result;
    }

    private static class Key {
        private final LambdaArgumentDeclaration argument;
        private final Type type;

        public Key(LambdaArgumentDeclaration argument, Type type) {
            this.argument = Objects.requireNonNull(argument, "argument is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.argument, key.argument) && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.argument, this.type);
        }
    }

    public static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

