/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression, Metadata metadata) {
        return DeterminismEvaluator.isDeterministic(expression, (FunctionCall functionCall) -> {
            ResolvedFunction resolvedFunction = ResolvedFunction.fromQualifiedName(functionCall.getName()).orElseThrow(() -> new IllegalArgumentException("Function call is not resolved: " + functionCall));
            return metadata.getFunctionMetadata(resolvedFunction);
        });
    }

    public static boolean isDeterministic(Expression expression, Function<FunctionCall, FunctionMetadata> functionMetadataSupplier) {
        Objects.requireNonNull(functionMetadataSupplier, "functionMetadataSupplier is null");
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor(functionMetadataSupplier).process((Node)expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private final Function<FunctionCall, FunctionMetadata> functionMetadataSupplier;

        public Visitor(Function<FunctionCall, FunctionMetadata> functionMetadataSupplier) {
            this.functionMetadataSupplier = functionMetadataSupplier;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (!this.functionMetadataSupplier.apply(node).isDeterministic()) {
                deterministic.set(false);
            }
            return super.visitFunctionCall(node, (Object)deterministic);
        }
    }
}

