/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.prestosql.server.ServletSecurityUtils;
import io.prestosql.server.ui.FixedUserWebUiConfig;
import io.prestosql.server.ui.FormWebUiAuthenticationManager;
import io.prestosql.server.ui.WebUiAuthenticationManager;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.io.IOException;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FixedUserWebUiAuthenticationManager
implements WebUiAuthenticationManager {
    private final Identity webUiIdentity;

    @Inject
    public FixedUserWebUiAuthenticationManager(FixedUserWebUiConfig config) {
        this(FixedUserWebUiAuthenticationManager.basicIdentity(Objects.requireNonNull(config, "config is null").getUsername()));
    }

    public FixedUserWebUiAuthenticationManager(Identity webUiIdentity) {
        this.webUiIdentity = Objects.requireNonNull(webUiIdentity, "webUiIdentity is null");
    }

    @Override
    public void handleUiRequest(HttpServletRequest request, HttpServletResponse response, FilterChain nextFilter) throws IOException, ServletException {
        if (FormWebUiAuthenticationManager.redirectAllFormLoginToUi(request, response)) {
            return;
        }
        ServletSecurityUtils.withAuthenticatedIdentity(nextFilter, request, response, this.webUiIdentity);
    }

    private static Identity basicIdentity(String username) {
        Objects.requireNonNull(username, "username is null");
        return Identity.forUser((String)username).withPrincipal((Principal)new BasicPrincipal(username)).build();
    }
}

