/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.event.client.EventModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.ConnectorManager;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.eventlistener.EventListenerConfig;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.SqlQueryManager;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.TaskManager;
import io.prestosql.execution.resourcegroups.InternalResourceGroupManager;
import io.prestosql.memory.ClusterMemoryManager;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.metadata.AllNodes;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.GroupProviderManager;
import io.prestosql.server.GracefulShutdownHandler;
import io.prestosql.server.PluginManager;
import io.prestosql.server.ServerMainModule;
import io.prestosql.server.SessionPropertyDefaults;
import io.prestosql.server.ShutdownAction;
import io.prestosql.server.security.CertificateAuthenticatorManager;
import io.prestosql.server.security.ServerSecurityModule;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.GroupProvider;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.Plan;
import io.prestosql.testing.ProcedureTester;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingEventListenerManager;
import io.prestosql.testing.TestingWarningCollectorModule;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.guice.MBeanModule;

public class TestingPrestoServer
implements Closeable {
    private final Injector injector;
    private final Path baseDataDir;
    private final boolean preserveData;
    private final LifeCycleManager lifeCycleManager;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final TestingHttpServer server;
    private final CatalogManager catalogManager;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final TestingAccessControlManager accessControl;
    private final ProcedureTester procedureTester;
    private final Optional<InternalResourceGroupManager<?>> resourceGroupManager;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ClusterMemoryManager clusterMemoryManager;
    private final LocalMemoryManager localMemoryManager;
    private final InternalNodeManager nodeManager;
    private final ServiceSelectorManager serviceSelectorManager;
    private final Announcer announcer;
    private final DispatchManager dispatchManager;
    private final SqlQueryManager queryManager;
    private final TaskManager taskManager;
    private final GracefulShutdownHandler gracefulShutdownHandler;
    private final ShutdownAction shutdownAction;
    private final boolean coordinator;

    public static TestingPrestoServer create() {
        return TestingPrestoServer.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private TestingPrestoServer(boolean coordinator, Map<String, String> properties, Optional<String> environment, Optional<URI> discoveryUri, Module additionalModule, Optional<Path> baseDataDir, String systemAccessControlName, Map<String, String> systemAccessControlProperties) {
        this.coordinator = coordinator;
        this.baseDataDir = baseDataDir.orElseGet(TestingPrestoServer::tempDirectory);
        this.preserveData = baseDataDir.isPresent();
        properties = new HashMap<String, String>(properties);
        String coordinatorPort = properties.remove("http-server.http.port");
        if (coordinatorPort == null) {
            coordinatorPort = "0";
        }
        ImmutableMap.Builder serverProperties = ImmutableMap.builder().putAll(properties).put((Object)"coordinator", (Object)String.valueOf(coordinator)).put((Object)"task.concurrency", (Object)"4").put((Object)"task.max-worker-threads", (Object)"4").put((Object)"exchange.client-threads", (Object)"4");
        if (coordinator) {
            serverProperties.put((Object)"failure-detector.enabled", (Object)"false");
        }
        ImmutableList.Builder modules = ImmutableList.builder().add((Object)new TestingNodeModule(environment)).add((Object)new TestingHttpServerModule(Integer.parseInt(coordinator ? coordinatorPort : "0"))).add((Object)new JsonModule()).add((Object)new JaxrsModule()).add((Object)new MBeanModule()).add((Object)new TestingJmxModule()).add((Object)new EventModule()).add((Object)new TraceTokenModule()).add((Object)new ServerSecurityModule()).add((Object)new ServerMainModule("testversion")).add((Object)new TestingWarningCollectorModule()).add(binder -> {
            binder.bind(String.class).annotatedWith(TestingAccessControlManager.ForSystemAccessControl.class).toInstance((Object)systemAccessControlName);
            binder.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(TestingAccessControlManager.ForSystemAccessControl.class).toInstance((Object)ImmutableMap.copyOf((Map)systemAccessControlProperties));
            binder.bind(EventListenerConfig.class).in(Scopes.SINGLETON);
            binder.bind(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControlManager.class).to(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(EventListenerManager.class).to(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(GroupProviderManager.class).in(Scopes.SINGLETON);
            binder.bind(GroupProvider.class).toInstance(user -> ImmutableSet.of());
            binder.bind(AccessControl.class).to(AccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(ShutdownAction.class).to(TestShutdownAction.class).in(Scopes.SINGLETON);
            binder.bind(GracefulShutdownHandler.class).in(Scopes.SINGLETON);
            binder.bind(ProcedureTester.class).in(Scopes.SINGLETON);
        });
        if (discoveryUri.isPresent()) {
            Objects.requireNonNull(environment, "environment required when discoveryUri is present");
            serverProperties.put((Object)"discovery.uri", (Object)discoveryUri.get().toString());
            modules.add((Object)new DiscoveryModule());
        } else {
            modules.add((Object)new TestingDiscoveryModule());
        }
        modules.add((Object)additionalModule);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        HashMap optionalProperties = new HashMap();
        environment.ifPresent(env -> optionalProperties.put("node.environment", env));
        this.injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties((Map)serverProperties.build()).setOptionalConfigurationProperties(optionalProperties).quiet().initialize();
        ((Announcer)this.injector.getInstance(Announcer.class)).start();
        this.lifeCycleManager = (LifeCycleManager)this.injector.getInstance(LifeCycleManager.class);
        this.pluginManager = (PluginManager)this.injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)this.injector.getInstance(ConnectorManager.class);
        this.server = (TestingHttpServer)this.injector.getInstance(TestingHttpServer.class);
        this.catalogManager = (CatalogManager)this.injector.getInstance(CatalogManager.class);
        this.transactionManager = (TransactionManager)this.injector.getInstance(TransactionManager.class);
        this.metadata = (Metadata)this.injector.getInstance(Metadata.class);
        this.accessControl = (TestingAccessControlManager)this.injector.getInstance(TestingAccessControlManager.class);
        this.procedureTester = (ProcedureTester)this.injector.getInstance(ProcedureTester.class);
        this.splitManager = (SplitManager)this.injector.getInstance(SplitManager.class);
        this.pageSourceManager = (PageSourceManager)this.injector.getInstance(PageSourceManager.class);
        if (coordinator) {
            this.dispatchManager = (DispatchManager)this.injector.getInstance(DispatchManager.class);
            this.queryManager = (SqlQueryManager)this.injector.getInstance(QueryManager.class);
            this.resourceGroupManager = Optional.of((InternalResourceGroupManager)this.injector.getInstance(InternalResourceGroupManager.class));
            this.sessionPropertyDefaults = (SessionPropertyDefaults)this.injector.getInstance(SessionPropertyDefaults.class);
            this.nodePartitioningManager = (NodePartitioningManager)this.injector.getInstance(NodePartitioningManager.class);
            this.clusterMemoryManager = (ClusterMemoryManager)this.injector.getInstance(ClusterMemoryManager.class);
            this.statsCalculator = (StatsCalculator)this.injector.getInstance(StatsCalculator.class);
            ((CertificateAuthenticatorManager)this.injector.getInstance(CertificateAuthenticatorManager.class)).useDefaultAuthenticator();
        } else {
            this.dispatchManager = null;
            this.queryManager = null;
            this.resourceGroupManager = Optional.empty();
            this.sessionPropertyDefaults = null;
            this.nodePartitioningManager = null;
            this.clusterMemoryManager = null;
            this.statsCalculator = null;
        }
        this.localMemoryManager = (LocalMemoryManager)this.injector.getInstance(LocalMemoryManager.class);
        this.nodeManager = (InternalNodeManager)this.injector.getInstance(InternalNodeManager.class);
        this.serviceSelectorManager = (ServiceSelectorManager)this.injector.getInstance(ServiceSelectorManager.class);
        this.gracefulShutdownHandler = (GracefulShutdownHandler)this.injector.getInstance(GracefulShutdownHandler.class);
        this.taskManager = (TaskManager)this.injector.getInstance(TaskManager.class);
        this.shutdownAction = (ShutdownAction)this.injector.getInstance(ShutdownAction.class);
        this.announcer = (Announcer)this.injector.getInstance(Announcer.class);
        this.accessControl.loadSystemAccessControl((String)this.injector.getInstance(Key.get(String.class, TestingAccessControlManager.ForSystemAccessControl.class)), (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, TestingAccessControlManager.ForSystemAccessControl.class)));
        this.announcer.forceAnnounce();
        this.refreshNodes();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (Files.isDirectory(this.baseDataDir, new LinkOption[0]) && !this.preserveData) {
                    MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                }
            });
            closer.register(() -> {
                if (this.lifeCycleManager != null) {
                    this.lifeCycleManager.stop();
                }
            });
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin, plugin.getClass()::getClassLoader);
    }

    public DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.queryManager.getQueryPlan(queryId);
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.queryManager.addFinalQueryInfoListener(queryId, stateChangeListener);
    }

    public CatalogName createCatalog(String catalogName, String connectorName) {
        return this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public CatalogName createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        CatalogName catalog = this.connectorManager.createCatalog(catalogName, connectorName, properties);
        TestingPrestoServer.updateConnectorIdAnnouncement(this.announcer, catalog, this.nodeManager);
        return catalog;
    }

    public Path getBaseDataDir() {
        return this.baseDataDir;
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    public URI resolve(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    public HostAndPort getAddress() {
        return HostAndPort.fromParts((String)this.getBaseUrl().getHost(), (int)this.getBaseUrl().getPort());
    }

    public HostAndPort getHttpsAddress() {
        URI httpsUri = this.server.getHttpServerInfo().getHttpsUri();
        return HostAndPort.fromParts((String)httpsUri.getHost(), (int)httpsUri.getPort());
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public StatsCalculator getStatsCalculator() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.statsCalculator;
    }

    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ProcedureTester getProcedureTester() {
        return this.procedureTester;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public Optional<InternalResourceGroupManager<?>> getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    public SessionPropertyDefaults getSessionPropertyDefaults() {
        return this.sessionPropertyDefaults;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public LocalMemoryManager getLocalMemoryManager() {
        return this.localMemoryManager;
    }

    public ClusterMemoryManager getClusterMemoryManager() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.clusterMemoryManager;
    }

    public GracefulShutdownHandler getGracefulShutdownHandler() {
        return this.gracefulShutdownHandler;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ShutdownAction getShutdownAction() {
        return this.shutdownAction;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public final AllNodes refreshNodes() {
        this.serviceSelectorManager.forceRefresh();
        this.nodeManager.refreshNodes();
        return this.nodeManager.getAllNodes();
    }

    public Set<InternalNode> getActiveNodesWithConnector(CatalogName catalogName) {
        return this.nodeManager.getActiveConnectorNodes(catalogName);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    private static void updateConnectorIdAnnouncement(Announcer announcer, CatalogName catalogName, InternalNodeManager nodeManager) {
        ServiceAnnouncement announcement = TestingPrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        String property = Strings.nullToEmpty((String)((String)properties.get("connectorIds")));
        LinkedHashSet<String> connectorIds = new LinkedHashSet<String>(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property));
        connectorIds.add(catalogName.toString());
        properties.put("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
        nodeManager.refreshNodes();
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new RuntimeException("Presto announcement not found: " + announcements);
    }

    private static Path tempDirectory() {
        try {
            return Files.createTempDirectory("PrestoTest", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Builder {
        private boolean coordinator = true;
        private Map<String, String> properties = ImmutableMap.of();
        private Optional<String> environment = Optional.empty();
        private Optional<URI> discoveryUri = Optional.empty();
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private String systemAccessControlName = "allow-all";
        private Map<String, String> systemAccessControlProperties = ImmutableMap.of();

        public Builder setCoordinator(boolean coordinator) {
            this.coordinator = coordinator;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = Optional.of(environment);
            return this;
        }

        public Builder setDiscoveryUri(URI discoveryUri) {
            this.discoveryUri = Optional.of(discoveryUri);
            return this;
        }

        public Builder setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModule is null");
            return this;
        }

        public Builder setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this;
        }

        public Builder setSystemAccessControl(String name, Map<String, String> properties) {
            this.systemAccessControlName = Objects.requireNonNull(name, "name is null");
            this.systemAccessControlProperties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
            return this;
        }

        public TestingPrestoServer build() {
            return new TestingPrestoServer(this.coordinator, this.properties, this.environment, this.discoveryUri, this.additionalModule, this.baseDataDir, this.systemAccessControlName, this.systemAccessControlProperties);
        }
    }

    public static class TestShutdownAction
    implements ShutdownAction {
        private final CountDownLatch shutdownCalled = new CountDownLatch(1);
        @GuardedBy(value="this")
        private boolean isWorkerShutdown;

        @Override
        public synchronized void onShutdown() {
            this.isWorkerShutdown = true;
            this.shutdownCalled.countDown();
        }

        public void waitForShutdownComplete(long millis) throws InterruptedException {
            this.shutdownCalled.await(millis, TimeUnit.MILLISECONDS);
        }

        public synchronized boolean isWorkerShutdown() {
            return this.isWorkerShutdown;
        }
    }
}

