/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.resourcegroups.NoOpResourceGroupManager;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.failuredetector.NoOpFailureDetector;
import io.prestosql.server.NoOpSessionSupplier;
import io.prestosql.server.SessionSupplier;
import io.prestosql.server.ui.NoWebUiAuthenticationManager;
import io.prestosql.server.ui.WebUiAuthenticationManager;
import io.prestosql.transaction.NoOpTransactionManager;
import io.prestosql.transaction.TransactionManager;
import javax.inject.Singleton;

public class WorkerModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(SessionSupplier.class).to(NoOpSessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(ResourceGroupManager.class).to(NoOpResourceGroupManager.class).in(Scopes.SINGLETON);
        binder.bind(TransactionManager.class).to(NoOpTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(FailureDetector.class).to(NoOpFailureDetector.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).toInstance((Object)((QueryManager)Reflection.newProxy(QueryManager.class, (proxy, method, args) -> {
            throw new UnsupportedOperationException();
        })));
        binder.bind(WebUiAuthenticationManager.class).to(NoWebUiAuthenticationManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }
}

