/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;

public class ServerConfig {
    private boolean coordinator = true;
    private boolean includeExceptionInResponse = true;
    private Duration gracePeriod = new Duration(2.0, TimeUnit.MINUTES);
    private boolean enhancedErrorReporting = true;

    public boolean isCoordinator() {
        return this.coordinator;
    }

    @Config(value="coordinator")
    public ServerConfig setCoordinator(boolean coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public boolean isIncludeExceptionInResponse() {
        return this.includeExceptionInResponse;
    }

    @Config(value="http.include-exception-in-response")
    public ServerConfig setIncludeExceptionInResponse(boolean includeExceptionInResponse) {
        this.includeExceptionInResponse = includeExceptionInResponse;
        return this;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    @Config(value="shutdown.grace-period")
    public ServerConfig setGracePeriod(Duration gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public boolean isEnhancedErrorReporting() {
        return this.enhancedErrorReporting;
    }

    @Config(value="sql.parser.enhanced-error-reporting")
    public ServerConfig setEnhancedErrorReporting(boolean value) {
        this.enhancedErrorReporting = value;
        return this;
    }
}

