/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.server.EmbeddedDiscoveryModule;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.client.QueryResults;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostCalculatorUsingExchanges;
import io.prestosql.cost.CostCalculatorWithEstimatedExchanges;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculatorModule;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.dispatcher.DispatchExecutor;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.dispatcher.DispatchQueryFactory;
import io.prestosql.dispatcher.FailedDispatchQueryFactory;
import io.prestosql.dispatcher.LocalDispatchQueryFactory;
import io.prestosql.dispatcher.QueuedStatementResource;
import io.prestosql.event.QueryMonitor;
import io.prestosql.event.QueryMonitorConfig;
import io.prestosql.execution.AddColumnTask;
import io.prestosql.execution.CallTask;
import io.prestosql.execution.ClusterSizeMonitor;
import io.prestosql.execution.CommentTask;
import io.prestosql.execution.CommitTask;
import io.prestosql.execution.CreateRoleTask;
import io.prestosql.execution.CreateSchemaTask;
import io.prestosql.execution.CreateTableTask;
import io.prestosql.execution.CreateViewTask;
import io.prestosql.execution.DataDefinitionExecution;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.DeallocateTask;
import io.prestosql.execution.DropColumnTask;
import io.prestosql.execution.DropRoleTask;
import io.prestosql.execution.DropSchemaTask;
import io.prestosql.execution.DropTableTask;
import io.prestosql.execution.DropViewTask;
import io.prestosql.execution.ExplainAnalyzeContext;
import io.prestosql.execution.ForQueryExecution;
import io.prestosql.execution.GrantRolesTask;
import io.prestosql.execution.GrantTask;
import io.prestosql.execution.PrepareTask;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryExecutionMBean;
import io.prestosql.execution.QueryIdGenerator;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryPerformanceFetcher;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.RenameColumnTask;
import io.prestosql.execution.RenameSchemaTask;
import io.prestosql.execution.RenameTableTask;
import io.prestosql.execution.RenameViewTask;
import io.prestosql.execution.ResetSessionTask;
import io.prestosql.execution.RevokeRolesTask;
import io.prestosql.execution.RevokeTask;
import io.prestosql.execution.RollbackTask;
import io.prestosql.execution.SetPathTask;
import io.prestosql.execution.SetRoleTask;
import io.prestosql.execution.SetSchemaAuthorizationTask;
import io.prestosql.execution.SetSessionTask;
import io.prestosql.execution.SqlQueryExecution;
import io.prestosql.execution.SqlQueryManager;
import io.prestosql.execution.StartTransactionTask;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.UseTask;
import io.prestosql.execution.resourcegroups.InternalResourceGroupManager;
import io.prestosql.execution.resourcegroups.LegacyResourceGroupConfigurationManager;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.execution.scheduler.AllAtOnceExecutionPolicy;
import io.prestosql.execution.scheduler.ExecutionPolicy;
import io.prestosql.execution.scheduler.PhasedExecutionPolicy;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.failuredetector.FailureDetectorModule;
import io.prestosql.memory.ClusterMemoryManager;
import io.prestosql.memory.ForMemoryManager;
import io.prestosql.memory.LowMemoryKiller;
import io.prestosql.memory.MemoryManagerConfig;
import io.prestosql.memory.NoneLowMemoryKiller;
import io.prestosql.memory.TotalReservationLowMemoryKiller;
import io.prestosql.memory.TotalReservationOnBlockedNodesLowMemoryKiller;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.operator.ForScheduler;
import io.prestosql.server.EmbeddedDiscoveryConfig;
import io.prestosql.server.ForStatementResource;
import io.prestosql.server.ForWorkerInfo;
import io.prestosql.server.GenerateTraceTokenRequestFilter;
import io.prestosql.server.HttpRemoteTaskFactory;
import io.prestosql.server.NodeResource;
import io.prestosql.server.QueryResource;
import io.prestosql.server.QuerySessionSupplier;
import io.prestosql.server.QueryStateInfoResource;
import io.prestosql.server.ResourceGroupStateInfoResource;
import io.prestosql.server.SessionSupplier;
import io.prestosql.server.StatementHttpExecutionMBean;
import io.prestosql.server.TaskUpdateRequest;
import io.prestosql.server.protocol.ExecutingStatementResource;
import io.prestosql.server.remotetask.RemoteTaskStats;
import io.prestosql.server.ui.WebUiModule;
import io.prestosql.server.ui.WorkerResource;
import io.prestosql.spi.memory.ClusterMemoryPoolManager;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.planner.PlanFragmenter;
import io.prestosql.sql.planner.PlanOptimizers;
import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Commit;
import io.prestosql.sql.tree.CreateRole;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.DropColumn;
import io.prestosql.sql.tree.DropRole;
import io.prestosql.sql.tree.DropSchema;
import io.prestosql.sql.tree.DropTable;
import io.prestosql.sql.tree.DropView;
import io.prestosql.sql.tree.Grant;
import io.prestosql.sql.tree.GrantRoles;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.RenameColumn;
import io.prestosql.sql.tree.RenameSchema;
import io.prestosql.sql.tree.RenameTable;
import io.prestosql.sql.tree.RenameView;
import io.prestosql.sql.tree.ResetSession;
import io.prestosql.sql.tree.Revoke;
import io.prestosql.sql.tree.RevokeRoles;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.sql.tree.SetSchemaAuthorization;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.StartTransaction;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Use;
import io.prestosql.transaction.ForTransactionManager;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.transaction.TransactionManagerConfig;
import io.prestosql.util.StatementUtils;
import io.prestosql.version.EmbedVersion;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new WebUiModule());
        this.install(ConditionalModule.installModuleIf(EmbeddedDiscoveryConfig.class, EmbeddedDiscoveryConfig::isEnabled, (Module)new EmbeddedDiscoveryModule()));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-coordinator");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SelectedRole.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueuedStatementResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ExecutingStatementResource.class);
        binder.bind(StatementHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(StatementHttpExecutionMBean.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, config -> {
            config.setMaxRequestHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            config.setMaxResponseHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        });
        binder.install((Module)new FailureDetectorModule());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WorkerResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("workerInfo", ForWorkerInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StatsAndCosts.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryStateInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceGroupStateInfoResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryManager.class).withGeneratedName();
        binder.bind(QueryPreparer.class).in(Scopes.SINGLETON);
        binder.bind(SessionSupplier.class).to(QuerySessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(InternalResourceGroupManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(InternalResourceGroupManager.class).withGeneratedName();
        binder.bind(ResourceGroupManager.class).to(InternalResourceGroupManager.class);
        binder.bind(LegacyResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        binder.bind(DispatchManager.class).in(Scopes.SINGLETON);
        binder.bind(FailedDispatchQueryFactory.class).in(Scopes.SINGLETON);
        binder.bind(DispatchExecutor.class).in(Scopes.SINGLETON);
        binder.bind(DispatchQueryFactory.class).to(LocalDispatchQueryFactory.class);
        binder.bind(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(ClusterMemoryPoolManager.class).to(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("memoryManager", ForMemoryManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.NONE, NoneLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION, TotalReservationLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES, TotalReservationOnBlockedNodesLowMemoryKiller.class);
        ExportBinder.newExporter((Binder)binder).export(ClusterMemoryManager.class).withGeneratedName();
        binder.bind(ClusterSizeMonitor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ClusterSizeMonitor.class).withGeneratedName();
        binder.install((Module)new StatsCalculatorModule());
        binder.bind(TaskCountEstimator.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).to(CostCalculatorUsingExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).annotatedWith(CostCalculator.EstimatedExchanges.class).to(CostCalculatorWithEstimatedExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostComparator.class).in(Scopes.SINGLETON);
        binder.bind(PlanFragmenter.class).in(Scopes.SINGLETON);
        binder.bind(PlanOptimizers.class).in(Scopes.SINGLETON);
        binder.bind(QueryExplainer.class).in(Scopes.SINGLETON);
        binder.bind(ExplainAnalyzeContext.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        binder.bind(RemoteTaskStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskStats.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForScheduler.class).toInstance((Object)Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"stage-scheduler")));
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s")));
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(generator -> generator.generatedNameOf(QueryExecution.class));
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(SplitSchedulerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SplitSchedulerStats.class).withGeneratedName();
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        StatementUtils.getAllQueryTypes().entrySet().stream().filter(entry -> entry.getValue() != QueryType.DATA_DEFINITION).forEach(entry -> executionBinder.addBinding((Object)((Class)entry.getKey())).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON));
        binder.bind(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateSchema.class, CreateSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropSchema.class, DropSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameSchema.class, RenameSchemaTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetSchemaAuthorization.class, SetSchemaAuthorizationTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, AddColumn.class, AddColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateTable.class, CreateTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameTable.class, RenameTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Comment.class, CommentTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameColumn.class, RenameColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropColumn.class, DropColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropTable.class, DropTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateView.class, CreateViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameView.class, RenameViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropView.class, DropViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Use.class, UseTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetSession.class, SetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, ResetSession.class, ResetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, StartTransaction.class, StartTransactionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Commit.class, CommitTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Rollback.class, RollbackTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Call.class, CallTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateRole.class, CreateRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropRole.class, DropRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, GrantRoles.class, GrantRolesTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RevokeRoles.class, RevokeRolesTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetRole.class, SetRoleTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Grant.class, GrantTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Revoke.class, RevokeTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Prepare.class, PrepareTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Deallocate.class, DeallocateTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetPath.class, SetPathTask.class);
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        binder.bind(ExecutorCleanup.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }

    @Provides
    @Singleton
    public static QueryPerformanceFetcher createQueryPerformanceFetcher(QueryManager queryManager) {
        return queryManager::getFullQueryInfo;
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ExecutorService createStatementResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"statement-response-%s"));
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static BoundedExecutor createStatementResponseExecutor(@ForStatementResource ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ScheduledExecutorService createStatementTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"statement-timeout-%s"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, EmbedVersion embedVersion, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create(config, idleCheckExecutor, catalogManager, embedVersion.embedVersion(finishingExecutor));
    }

    private static <T extends Statement> void bindDataDefinitionTask(Binder binder, MapBinder<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionBinder, Class<T> statement, Class<? extends DataDefinitionTask<T>> task) {
        Verify.verify((StatementUtils.getAllQueryTypes().get(statement) == QueryType.DATA_DEFINITION ? 1 : 0) != 0);
        MapBinder taskBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<DataDefinitionTask<?>>(){});
        taskBinder.addBinding(statement).to(task).in(Scopes.SINGLETON);
        executionBinder.addBinding(statement).to(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
    }

    private void bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy policy, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.installModuleIf(MemoryManagerConfig.class, config -> policy == config.getLowMemoryKillerPolicy(), binder -> binder.bind(LowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForStatementResource ExecutorService statementResponseExecutor, @ForStatementResource ScheduledExecutorService statementTimeoutExecutor, @ForQueryExecution ExecutorService queryExecutionExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, @ForTransactionManager ExecutorService transactionFinishingExecutor, @ForTransactionManager ScheduledExecutorService transactionIdleExecutor) {
            this.executors = ImmutableList.builder().add((Object)statementResponseExecutor).add((Object)statementTimeoutExecutor).add((Object)queryExecutionExecutor).add((Object)schedulerExecutor).add((Object)transactionFinishingExecutor).add((Object)transactionIdleExecutor).build();
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

