/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FieldSetFilteringRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final List<Set<Field>> fieldSets;

    public FieldSetFilteringRecordSet(Metadata metadata, RecordSet delegate, List<Set<Integer>> fieldSets) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        ImmutableList.Builder fieldSetsBuilder = ImmutableList.builder();
        List columnTypes = delegate.getColumnTypes();
        for (Set<Integer> fieldSet : Objects.requireNonNull(fieldSets, "fieldSets is null")) {
            ImmutableSet.Builder fieldSetBuilder = ImmutableSet.builder();
            for (int field : fieldSet) {
                fieldSetBuilder.add((Object)new Field(field, metadata.getScalarFunctionImplementation(metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)((Type)columnTypes.get(field)), (Object)((Type)columnTypes.get(field))))).getMethodHandle()));
            }
            fieldSetsBuilder.add((Object)fieldSetBuilder.build());
        }
        this.fieldSets = fieldSetsBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.delegate.getColumnTypes();
    }

    public RecordCursor cursor() {
        return new FieldSetFilteringRecordCursor(this.delegate.cursor(), this.fieldSets);
    }

    private static class FieldSetFilteringRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final List<Set<Field>> fieldSets;

        private FieldSetFilteringRecordCursor(RecordCursor delegate, List<Set<Field>> fieldSets) {
            this.delegate = delegate;
            this.fieldSets = fieldSets;
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return this.delegate.getReadTimeNanos();
        }

        public Type getType(int field) {
            return this.delegate.getType(field);
        }

        public boolean advanceNextPosition() {
            while (this.delegate.advanceNextPosition()) {
                if (!FieldSetFilteringRecordCursor.fieldSetsEqual(this.delegate, this.fieldSets)) continue;
                return true;
            }
            return false;
        }

        private static boolean fieldSetsEqual(RecordCursor cursor, List<Set<Field>> fieldSets) {
            for (Set<Field> fieldSet : fieldSets) {
                if (FieldSetFilteringRecordCursor.fieldsEquals(cursor, fieldSet)) continue;
                return false;
            }
            return true;
        }

        private static boolean fieldsEquals(RecordCursor cursor, Set<Field> fields) {
            if (fields.size() < 2) {
                return true;
            }
            Iterator<Field> fieldIterator = fields.iterator();
            Field firstField = fieldIterator.next();
            while (fieldIterator.hasNext()) {
                if (FieldSetFilteringRecordCursor.fieldEquals(cursor, firstField, fieldIterator.next())) continue;
                return false;
            }
            return true;
        }

        private static boolean fieldEquals(RecordCursor cursor, Field field1, Field field2) {
            Preconditions.checkArgument((boolean)cursor.getType(field1.getField()).equals(cursor.getType(field2.getField())), (Object)"Should only be comparing fields of the same type");
            if (cursor.isNull(field1.getField()) || cursor.isNull(field2.getField())) {
                return false;
            }
            Class javaType = cursor.getType(field1.getField()).getJavaType();
            try {
                if (javaType == Long.TYPE) {
                    return Boolean.TRUE.equals(field1.getEqualsMethodHandle().invokeExact(cursor.getLong(field1.getField()), cursor.getLong(field2.getField())));
                }
                if (javaType == Double.TYPE) {
                    return Boolean.TRUE.equals(field1.getEqualsMethodHandle().invokeExact(cursor.getDouble(field1.getField()), cursor.getDouble(field2.getField())));
                }
                if (javaType == Boolean.TYPE) {
                    return Boolean.TRUE.equals(field1.getEqualsMethodHandle().invokeExact(cursor.getBoolean(field1.getField()), cursor.getBoolean(field2.getField())));
                }
                if (javaType == Slice.class) {
                    return Boolean.TRUE.equals(field1.getEqualsMethodHandle().invokeExact(cursor.getSlice(field1.getField()), cursor.getSlice(field2.getField())));
                }
                return Boolean.TRUE.equals(field1.getEqualsMethodHandle().invoke(cursor.getObject(field1.getField()), cursor.getObject(field2.getField())));
            }
            catch (Throwable t) {
                Throwables.throwIfUnchecked((Throwable)t);
                throw new RuntimeException(t);
            }
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(field);
        }

        public long getLong(int field) {
            return this.delegate.getLong(field);
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(field);
        }

        public Slice getSlice(int field) {
            return this.delegate.getSlice(field);
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            return this.delegate.isNull(field);
        }

        public void close() {
            this.delegate.close();
        }
    }

    private static class Field {
        private final int field;
        private final MethodHandle equalsMethodHandle;

        public Field(int field, MethodHandle equalsMethodHandle) {
            this.field = field;
            this.equalsMethodHandle = Objects.requireNonNull(equalsMethodHandle, "equalsMethodHandle is null");
        }

        public int getField() {
            return this.field;
        }

        public MethodHandle getEqualsMethodHandle() {
            return this.equalsMethodHandle;
        }
    }
}

