/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.http.client.GlobalFilter;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.client.spnego.KerberosConfig;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;

public class HttpClientModule
implements Module {
    protected final String name;
    protected final Class<? extends Annotation> annotation;
    protected Binder binder;

    HttpClientModule(String name, Class<? extends Annotation> annotation) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.annotation = Objects.requireNonNull(annotation, "annotation is null");
    }

    void withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
        ConfigBinder.configBinder((Binder)this.binder).bindConfigDefaults(HttpClientConfig.class, this.annotation, configDefaults);
    }

    public void configure(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null");
        ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpClientConfig.class, this.annotation, this.name);
        OptionalBinder.newOptionalBinder((Binder)binder, SslContextFactory.Client.class);
        binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, GlobalFilter.class);
        Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, this.annotation);
        ExportBinder.newExporter((Binder)binder).export(HttpClient.class).annotatedWith(this.annotation).withGeneratedName();
    }

    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(HttpClient.class, this.annotation));
    }

    private static class HttpClientProvider
    implements Provider<HttpClient> {
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private HttpClientProvider(String name, Class<? extends Annotation> annotation) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public HttpClient get() {
            KerberosConfig kerberosConfig = (KerberosConfig)this.injector.getInstance(KerberosConfig.class);
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            Optional sslContextFactory = (Optional)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<SslContextFactory.Client>>(){}));
            ImmutableSet filters = ImmutableSet.builder().addAll((Iterable)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, GlobalFilter.class))).addAll((Iterable)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, this.annotation))).build();
            return new JettyHttpClient(this.name, config, kerberosConfig, (Iterable<? extends HttpRequestFilter>)ImmutableList.copyOf((Collection)filters), sslContextFactory);
        }
    }
}

