/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Range;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.BKException;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.Handle;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.Retries;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.WaitingEntryCallBack;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.bookkeeper.mledger.impl.ManagedCursorContainer;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.NonDurableCursorImpl;
import org.apache.bookkeeper.mledger.impl.NullLedgerOffloader;
import org.apache.bookkeeper.mledger.impl.OpAddEntry;
import org.apache.bookkeeper.mledger.impl.OpFindNewest;
import org.apache.bookkeeper.mledger.impl.OpReadEntry;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.CallbackMutex;
import org.apache.bookkeeper.mledger.util.Errors;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.apache.bookkeeper.net.BookieId;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.LazyLoadableValue;
import org.apache.pulsar.common.util.collections.ConcurrentLongHashMap;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerImpl
implements ManagedLedger,
AsyncCallback.CreateCallback {
    private static final long MegaByte = 0x100000L;
    protected static final int AsyncOperationTimeoutSeconds = 30;
    protected final BookKeeper bookKeeper;
    protected final String name;
    private final Map<String, byte[]> ledgerMetadata;
    protected final BookKeeper.DigestType digestType;
    protected ManagedLedgerConfig config;
    protected Map<String, String> propertiesMap;
    protected final MetaStore store;
    final ConcurrentLongHashMap<CompletableFuture<ReadHandle>> ledgerCache = ConcurrentLongHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
    protected final NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers = new ConcurrentSkipListMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
    private volatile Stat ledgersStat;
    private final ManagedCursorContainer cursors = new ManagedCursorContainer();
    private final ManagedCursorContainer activeCursors = new ManagedCursorContainer();
    @VisibleForTesting
    static final AtomicLongFieldUpdater<ManagedLedgerImpl> ENTRIES_ADDED_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedLedgerImpl.class, "entriesAddedCounter");
    private volatile long entriesAddedCounter = 0L;
    static final AtomicLongFieldUpdater<ManagedLedgerImpl> NUMBER_OF_ENTRIES_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedLedgerImpl.class, "numberOfEntries");
    private volatile long numberOfEntries = 0L;
    static final AtomicLongFieldUpdater<ManagedLedgerImpl> TOTAL_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedLedgerImpl.class, "totalSize");
    private volatile long totalSize = 0L;
    final ConcurrentLinkedQueue<ManagedCursorImpl> waitingCursors;
    final ConcurrentLinkedQueue<WaitingEntryCallBack> waitingEntryCallBacks;
    final Map<String, CompletableFuture<ManagedCursor>> uninitializedCursors;
    final EntryCache entryCache;
    private ScheduledFuture<?> timeoutTask;
    private ScheduledFuture<?> checkLedgerRollTask;
    private final CallbackMutex metadataMutex = new CallbackMutex();
    private final CallbackMutex trimmerMutex = new CallbackMutex();
    private final CallbackMutex offloadMutex = new CallbackMutex();
    private static final CompletableFuture<PositionImpl> NULL_OFFLOAD_PROMISE = CompletableFuture.completedFuture(PositionImpl.LATEST);
    protected volatile LedgerHandle currentLedger;
    private long currentLedgerEntries = 0L;
    protected long currentLedgerSize = 0L;
    private long lastLedgerCreatedTimestamp = 0L;
    private long lastLedgerCreationFailureTimestamp = 0L;
    private long lastLedgerCreationInitiationTimestamp = 0L;
    private long lastOffloadLedgerId = 0L;
    private long lastOffloadSuccessTimestamp = 0L;
    private long lastOffloadFailureTimestamp = 0L;
    private int minBacklogCursorsForCaching = 0;
    private int minBacklogEntriesForCaching = 1000;
    private int maxBacklogBetweenCursorsForCaching = 1000;
    private static final Random random = new Random(System.currentTimeMillis());
    private long maximumRolloverTimeMs;
    protected final Supplier<Boolean> mlOwnershipChecker;
    volatile PositionImpl lastConfirmedEntry;
    private ManagedLedgerInterceptor managedLedgerInterceptor;
    private volatile long lastAddEntryTimeMs = 0L;
    private long inactiveLedgerRollOverTimeMs = 0L;
    protected static final int DEFAULT_LEDGER_DELETE_RETRIES = 3;
    protected static final int DEFAULT_LEDGER_DELETE_BACKOFF_TIME_SEC = 60;
    private static final AtomicReferenceFieldUpdater<ManagedLedgerImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedLedgerImpl.class, State.class, "state");
    protected volatile State state = null;
    private final OrderedScheduler scheduledExecutor;
    private final OrderedExecutor executor;
    private final ManagedLedgerFactoryImpl factory;
    protected final ManagedLedgerMBeanImpl mbean;
    protected final Clock clock;
    private static final AtomicLongFieldUpdater<ManagedLedgerImpl> READ_OP_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedLedgerImpl.class, "readOpCount");
    private volatile long readOpCount = 0L;
    protected static final AtomicLongFieldUpdater<ManagedLedgerImpl> ADD_OP_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedLedgerImpl.class, "addOpCount");
    private volatile long addOpCount = 0L;
    private volatile ReadEntryCallbackWrapper lastReadCallback = null;
    private static final AtomicReferenceFieldUpdater<ManagedLedgerImpl, ReadEntryCallbackWrapper> LAST_READ_CALLBACK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedLedgerImpl.class, ReadEntryCallbackWrapper.class, "lastReadCallback");
    final ConcurrentLinkedQueue<OpAddEntry> pendingAddEntries = new ConcurrentLinkedQueue();
    @VisibleForTesting
    Map<String, byte[]> createdLedgerCustomMetadata;
    static final Predicate<Throwable> FAIL_ON_CONFLICT = throwable -> !(throwable instanceof OffloadConflict) && Retries.NonFatalPredicate.test(throwable);
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerImpl.class);

    public ManagedLedgerImpl(ManagedLedgerFactoryImpl factory, BookKeeper bookKeeper, MetaStore store, ManagedLedgerConfig config, OrderedScheduler scheduledExecutor, String name) {
        this(factory, bookKeeper, store, config, scheduledExecutor, name, null);
    }

    public ManagedLedgerImpl(ManagedLedgerFactoryImpl factory, BookKeeper bookKeeper, MetaStore store, ManagedLedgerConfig config, OrderedScheduler scheduledExecutor, String name, Supplier<Boolean> mlOwnershipChecker) {
        this.factory = factory;
        this.bookKeeper = bookKeeper;
        this.config = config;
        this.store = store;
        this.name = name;
        this.ledgerMetadata = LedgerMetadataUtils.buildBaseManagedLedgerMetadata(name);
        this.digestType = BookKeeper.DigestType.fromApiDigestType((DigestType)config.getDigestType());
        this.scheduledExecutor = scheduledExecutor;
        this.executor = bookKeeper.getMainWorkerPool();
        TOTAL_SIZE_UPDATER.set(this, 0L);
        NUMBER_OF_ENTRIES_UPDATER.set(this, 0L);
        ENTRIES_ADDED_COUNTER_UPDATER.set(this, 0L);
        STATE_UPDATER.set(this, State.None);
        this.ledgersStat = null;
        this.mbean = new ManagedLedgerMBeanImpl(this);
        if (config.getManagedLedgerInterceptor() != null) {
            this.managedLedgerInterceptor = config.getManagedLedgerInterceptor();
        }
        this.entryCache = factory.getEntryCacheManager().getEntryCache(this);
        this.waitingCursors = Queues.newConcurrentLinkedQueue();
        this.waitingEntryCallBacks = Queues.newConcurrentLinkedQueue();
        this.uninitializedCursors = new HashMap<String, CompletableFuture<ManagedCursor>>();
        this.clock = config.getClock();
        this.maximumRolloverTimeMs = ManagedLedgerImpl.getMaximumRolloverTimeMs(config);
        this.mlOwnershipChecker = mlOwnershipChecker;
        this.propertiesMap = new HashMap<String, String>();
        this.inactiveLedgerRollOverTimeMs = config.getInactiveLedgerRollOverTimeMs();
        if (config.getManagedLedgerInterceptor() != null) {
            this.managedLedgerInterceptor = config.getManagedLedgerInterceptor();
        }
        this.minBacklogCursorsForCaching = config.getMinimumBacklogCursorsForCaching();
        this.minBacklogEntriesForCaching = config.getMinimumBacklogEntriesForCaching();
        this.maxBacklogBetweenCursorsForCaching = config.getMaxBacklogBetweenCursorsForCaching();
    }

    synchronized void initialize(final ManagedLedgerInitializeLedgerCallback callback, Object ctx) {
        log.info("Opening managed ledger {}", (Object)this.name);
        this.store.getManagedLedgerInfo(this.name, this.config.isCreateIfMissing(), this.config.getProperties(), new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
                ManagedLedgerImpl.this.ledgersStat = stat;
                if (mlInfo.hasTerminatedPosition()) {
                    ManagedLedgerImpl.this.state = State.Terminated;
                    ManagedLedgerImpl.this.lastConfirmedEntry = new PositionImpl(mlInfo.getTerminatedPosition());
                    log.info("[{}] Recovering managed ledger terminated at {}", (Object)ManagedLedgerImpl.this.name, (Object)ManagedLedgerImpl.this.lastConfirmedEntry);
                }
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    ManagedLedgerImpl.this.ledgers.put(ls.getLedgerId(), ls);
                }
                if (mlInfo.getPropertiesCount() > 0) {
                    ManagedLedgerImpl.this.propertiesMap = new HashMap<String, String>();
                    for (int i = 0; i < mlInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.KeyValue property = mlInfo.getProperties(i);
                        ManagedLedgerImpl.this.propertiesMap.put(property.getKey(), property.getValue());
                    }
                }
                if (ManagedLedgerImpl.this.managedLedgerInterceptor != null) {
                    ManagedLedgerImpl.this.managedLedgerInterceptor.onManagedLedgerPropertiesInitialize(ManagedLedgerImpl.this.propertiesMap);
                }
                if (!ManagedLedgerImpl.this.ledgers.isEmpty()) {
                    long id = (Long)ManagedLedgerImpl.this.ledgers.lastKey();
                    AsyncCallback.OpenCallback opencb = (rc, lh, ctx1) -> ManagedLedgerImpl.this.executor.executeOrdered((Object)ManagedLedgerImpl.this.name, (SafeRunnable)SafeRun.safeRun(() -> {
                        ManagedLedgerImpl.this.mbean.endDataLedgerOpenOp();
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Opened ledger {}: {}", new Object[]{ManagedLedgerImpl.this.name, id, org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                        }
                        if (rc == 0) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(id).setEntries(lh.getLastAddConfirmed() + 1L).setSize(lh.getLength()).setTimestamp(ManagedLedgerImpl.this.clock.millis()).build();
                            ManagedLedgerImpl.this.ledgers.put(id, info);
                            if (ManagedLedgerImpl.this.managedLedgerInterceptor != null) {
                                ((CompletableFuture)ManagedLedgerImpl.this.managedLedgerInterceptor.onManagedLedgerLastLedgerInitialize(ManagedLedgerImpl.this.name, lh).thenRun(() -> ManagedLedgerImpl.this.initializeBookKeeper(callback))).exceptionally(ex -> {
                                    callback.initializeFailed(new ManagedLedgerException.ManagedLedgerInterceptException(ex.getCause()));
                                    return null;
                                });
                            } else {
                                ManagedLedgerImpl.this.initializeBookKeeper(callback);
                            }
                        } else if (Errors.isNoSuchLedgerExistsException(rc)) {
                            log.warn("[{}] Ledger not found: {}", (Object)ManagedLedgerImpl.this.name, (Object)id);
                            ManagedLedgerImpl.this.ledgers.remove(id);
                            ManagedLedgerImpl.this.initializeBookKeeper(callback);
                        } else {
                            log.error("[{}] Failed to open ledger {}: {}", new Object[]{ManagedLedgerImpl.this.name, id, org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                            callback.initializeFailed(ManagedLedgerImpl.createManagedLedgerException(rc));
                            return;
                        }
                    }));
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Opening ledger {}", (Object)ManagedLedgerImpl.this.name, (Object)id);
                    }
                    ManagedLedgerImpl.this.mbean.startDataLedgerOpenOp();
                    ManagedLedgerImpl.this.bookKeeper.asyncOpenLedger(id, ManagedLedgerImpl.this.digestType, ManagedLedgerImpl.this.config.getPassword(), opencb, null);
                } else {
                    ManagedLedgerImpl.this.initializeBookKeeper(callback);
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                ManagedLedgerImpl.this.handleBadVersion(e);
                if (e instanceof ManagedLedgerException.MetadataNotFoundException) {
                    callback.initializeFailed(new ManagedLedgerException.ManagedLedgerNotFoundException(e));
                } else {
                    callback.initializeFailed(new ManagedLedgerException(e));
                }
            }
        });
        this.scheduleTimeoutTask();
    }

    private synchronized void initializeBookKeeper(final ManagedLedgerInitializeLedgerCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] initializing bookkeeper; ledgers {}", (Object)this.name, this.ledgers);
        }
        final List<Long> emptyLedgersToBeDeleted = Collections.synchronizedList(new ArrayList());
        Iterator iterator = this.ledgers.values().iterator();
        while (iterator.hasNext()) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)iterator.next();
            if (li.getEntries() > 0L) {
                NUMBER_OF_ENTRIES_UPDATER.addAndGet(this, li.getEntries());
                TOTAL_SIZE_UPDATER.addAndGet(this, li.getSize());
                continue;
            }
            iterator.remove();
            emptyLedgersToBeDeleted.add(li.getLedgerId());
        }
        if (this.state == State.Terminated) {
            this.initializeCursors(callback);
            return;
        }
        MetaStore.MetaStoreCallback<Void> storeLedgersCb = new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void v, Stat stat) {
                ManagedLedgerImpl.this.ledgersStat = stat;
                emptyLedgersToBeDeleted.forEach(ledgerId -> ManagedLedgerImpl.this.bookKeeper.asyncDeleteLedger(ledgerId.longValue(), (rc, ctx) -> log.info("[{}] Deleted empty ledger ledgerId={} rc={}", new Object[]{ManagedLedgerImpl.this.name, ledgerId, rc}), null));
                ManagedLedgerImpl.this.initializeCursors(callback);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                ManagedLedgerImpl.this.handleBadVersion(e);
                callback.initializeFailed(new ManagedLedgerException(e));
            }
        };
        this.lastLedgerCreationInitiationTimestamp = System.currentTimeMillis();
        this.mbean.startDataLedgerCreateOp();
        this.asyncCreateLedger(this.bookKeeper, this.config, this.digestType, (rc, lh, ctx) -> {
            if (this.checkAndCompleteLedgerOpTask(rc, lh, ctx)) {
                return;
            }
            this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> {
                Map.Entry<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> formerLedger;
                this.mbean.endDataLedgerCreateOp();
                if (rc != 0) {
                    callback.initializeFailed(ManagedLedgerImpl.createManagedLedgerException(rc));
                    return;
                }
                log.info("[{}] Created ledger {} after closed {}", new Object[]{this.name, lh.getId(), this.currentLedger == null ? "null" : Long.valueOf(this.currentLedger.getId())});
                STATE_UPDATER.set(this, State.LedgerOpened);
                this.updateLastLedgerCreatedTimeAndScheduleRolloverTask();
                this.currentLedger = lh;
                this.lastConfirmedEntry = new PositionImpl(lh.getId(), -1L);
                while (this.lastConfirmedEntry.getEntryId() == -1L && (formerLedger = this.ledgers.lowerEntry(this.lastConfirmedEntry.getLedgerId())) != null) {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = formerLedger.getValue();
                    this.lastConfirmedEntry = PositionImpl.get(ledgerInfo.getLedgerId(), ledgerInfo.getEntries() - 1L);
                }
                MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lh.getId()).setTimestamp(0L).build();
                this.ledgers.put(lh.getId(), info);
                this.store.asyncUpdateLedgerIds(this.name, this.getManagedLedgerInfo(), this.ledgersStat, storeLedgersCb);
            }));
        }, this.ledgerMetadata);
    }

    private void initializeCursors(final ManagedLedgerInitializeLedgerCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] initializing cursors", (Object)this.name);
        }
        this.store.getCursors(this.name, new MetaStore.MetaStoreCallback<List<String>>(){

            @Override
            public void operationComplete(List<String> consumers, Stat s) {
                final AtomicInteger cursorCount = new AtomicInteger(consumers.size());
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Found {} cursors", (Object)ManagedLedgerImpl.this.name, (Object)consumers.size());
                }
                if (consumers.isEmpty()) {
                    callback.initializeComplete();
                    return;
                }
                if (!ManagedLedgerImpl.this.config.isLazyCursorRecovery()) {
                    log.debug("[{}] Loading cursors", (Object)ManagedLedgerImpl.this.name);
                    for (final String cursorName : consumers) {
                        log.info("[{}] Loading cursor {}", (Object)ManagedLedgerImpl.this.name, (Object)cursorName);
                        final ManagedCursorImpl cursor = new ManagedCursorImpl(ManagedLedgerImpl.this.bookKeeper, ManagedLedgerImpl.this.config, ManagedLedgerImpl.this, cursorName);
                        cursor.recover(new ManagedCursorImpl.VoidCallback(){

                            @Override
                            public void operationComplete() {
                                log.info("[{}] Recovery for cursor {} completed. pos={} -- todo={}", new Object[]{ManagedLedgerImpl.this.name, cursorName, cursor.getMarkDeletedPosition(), cursorCount.get() - 1});
                                cursor.setActive();
                                ManagedLedgerImpl.this.addCursor(cursor);
                                if (cursorCount.decrementAndGet() == 0) {
                                    callback.initializeComplete();
                                }
                            }

                            @Override
                            public void operationFailed(ManagedLedgerException exception) {
                                log.warn("[{}] Recovery for cursor {} failed", new Object[]{ManagedLedgerImpl.this.name, cursorName, exception});
                                cursorCount.set(-1);
                                callback.initializeFailed(exception);
                            }
                        });
                    }
                } else {
                    for (final String cursorName : consumers) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Recovering cursor {} lazily", (Object)ManagedLedgerImpl.this.name, (Object)cursorName);
                        }
                        final ManagedCursorImpl cursor = new ManagedCursorImpl(ManagedLedgerImpl.this.bookKeeper, ManagedLedgerImpl.this.config, ManagedLedgerImpl.this, cursorName);
                        CompletableFuture cursorRecoveryFuture = new CompletableFuture();
                        ManagedLedgerImpl.this.uninitializedCursors.put(cursorName, cursorRecoveryFuture);
                        cursor.recover(new ManagedCursorImpl.VoidCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void operationComplete() {
                                log.info("[{}] Lazy recovery for cursor {} completed. pos={} -- todo={}", new Object[]{ManagedLedgerImpl.this.name, cursorName, cursor.getMarkDeletedPosition(), cursorCount.get() - 1});
                                cursor.setActive();
                                ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                                synchronized (managedLedgerImpl) {
                                    ManagedLedgerImpl.this.addCursor(cursor);
                                    ManagedLedgerImpl.this.uninitializedCursors.remove(cursor.getName()).complete(cursor);
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void operationFailed(ManagedLedgerException exception) {
                                log.warn("[{}] Lazy recovery for cursor {} failed", new Object[]{ManagedLedgerImpl.this.name, cursorName, exception});
                                ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                                synchronized (managedLedgerImpl) {
                                    ManagedLedgerImpl.this.uninitializedCursors.remove(cursor.getName()).completeExceptionally(exception);
                                }
                            }
                        });
                    }
                    callback.initializeComplete();
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Failed to get the cursors list", (Object)ManagedLedgerImpl.this.name, (Object)e);
                callback.initializeFailed(new ManagedLedgerException(e));
            }
        });
    }

    private void addCursor(ManagedCursorImpl cursor) {
        Position positionForOrdering = null;
        if (cursor.isDurable() && (positionForOrdering = cursor.getMarkDeletedPosition()) == null) {
            positionForOrdering = PositionImpl.EARLIEST;
        }
        this.cursors.add(cursor, positionForOrdering);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Position addEntry(byte[] data) throws InterruptedException, ManagedLedgerException {
        return this.addEntry(data, 0, data.length);
    }

    @Override
    public Position addEntry(byte[] data, int numberOfMessages) throws InterruptedException, ManagedLedgerException {
        return this.addEntry(data, numberOfMessages, 0, data.length);
    }

    @Override
    public Position addEntry(byte[] data, int offset, int length) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException status = null;
            Position position = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncAddEntry(data, offset, length, new AsyncCallbacks.AddEntryCallback(){
            {
            }

            @Override
            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                result.position = position;
                counter.countDown();
            }

            @Override
            public void addFailed(ManagedLedgerException exception, Object ctx) {
                result.status = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.status != null) {
            log.error("[{}] Error adding entry", (Object)this.name, (Object)result.status);
            throw result.status;
        }
        return result.position;
    }

    @Override
    public Position addEntry(byte[] data, int numberOfMessages, int offset, int length) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException status = null;
            Position position = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncAddEntry(data, numberOfMessages, offset, length, new AsyncCallbacks.AddEntryCallback(){
            {
            }

            @Override
            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                result.position = position;
                counter.countDown();
            }

            @Override
            public void addFailed(ManagedLedgerException exception, Object ctx) {
                result.status = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.status != null) {
            log.error("[{}] Error adding entry", (Object)this.name, (Object)result.status);
            throw result.status;
        }
        return result.position;
    }

    @Override
    public void asyncAddEntry(byte[] data, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, callback, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length);
        this.asyncAddEntry(buffer, callback, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int numberOfMessages, int offset, int length, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length);
        this.asyncAddEntry(buffer, numberOfMessages, callback, ctx);
    }

    @Override
    public void asyncAddEntry(ByteBuf buffer, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] asyncAddEntry size={} state={}", new Object[]{this.name, buffer.readableBytes(), this.state});
        }
        buffer.retain();
        this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> {
            OpAddEntry addOperation = OpAddEntry.createNoRetainBuffer(this, buffer, callback, ctx);
            this.internalAsyncAddEntry(addOperation);
        }));
    }

    @Override
    public void asyncAddEntry(ByteBuf buffer, int numberOfMessages, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] asyncAddEntry size={} state={}", new Object[]{this.name, buffer.readableBytes(), this.state});
        }
        buffer.retain();
        this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> {
            OpAddEntry addOperation = OpAddEntry.createNoRetainBuffer(this, buffer, numberOfMessages, callback, ctx);
            this.internalAsyncAddEntry(addOperation);
        }));
    }

    private synchronized void internalAsyncAddEntry(OpAddEntry addOperation) {
        if (!this.beforeAddEntry(addOperation)) {
            return;
        }
        State state = STATE_UPDATER.get(this);
        if (state == State.Fenced) {
            addOperation.failed(new ManagedLedgerException.ManagedLedgerFencedException());
            return;
        }
        if (state == State.Terminated) {
            addOperation.failed(new ManagedLedgerException.ManagedLedgerTerminatedException("Managed ledger was already terminated"));
            return;
        }
        if (state == State.Closed) {
            addOperation.failed(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Managed ledger was already closed"));
            return;
        }
        if (state == State.WriteFailed) {
            addOperation.failed(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Waiting to recover from failure"));
            return;
        }
        this.pendingAddEntries.add(addOperation);
        if (state == State.ClosingLedger || state == State.CreatingLedger) {
            long elapsedMs;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Queue addEntry request", (Object)this.name);
            }
            if (State.CreatingLedger == state && (elapsedMs = System.currentTimeMillis() - this.lastLedgerCreationInitiationTimestamp) > TimeUnit.SECONDS.toMillis(2L * this.config.getMetadataOperationsTimeoutSeconds())) {
                log.info("[{}] Ledger creation was initiated {} ms ago but it never completed and creation timeout task didn't kick in as well. Force to fail the create ledger operation.", (Object)this.name, (Object)elapsedMs);
                this.createComplete(-23, null, null);
            }
        } else if (state == State.ClosedLedger) {
            if (STATE_UPDATER.compareAndSet(this, State.ClosedLedger, State.CreatingLedger)) {
                log.info("[{}] Creating a new ledger", (Object)this.name);
                this.lastLedgerCreationInitiationTimestamp = System.currentTimeMillis();
                this.mbean.startDataLedgerCreateOp();
                this.asyncCreateLedger(this.bookKeeper, this.config, this.digestType, this, Collections.emptyMap());
            }
        } else {
            Preconditions.checkArgument((state == State.LedgerOpened ? 1 : 0) != 0, (String)"ledger=%s is not opened", (Object)((Object)state));
            addOperation.setLedger(this.currentLedger);
            ++this.currentLedgerEntries;
            this.currentLedgerSize += (long)addOperation.data.readableBytes();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Write into current ledger lh={} entries={}", new Object[]{this.name, this.currentLedger.getId(), this.currentLedgerEntries});
            }
            if (this.currentLedgerIsFull()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Closing current ledger lh={}", (Object)this.name, (Object)this.currentLedger.getId());
                }
                addOperation.setCloseWhenDone(true);
                STATE_UPDATER.set(this, State.ClosingLedger);
            }
            addOperation.initiate();
        }
        this.lastAddEntryTimeMs = System.currentTimeMillis();
    }

    protected void afterFailedAddEntry(int numOfMessages) {
        if (this.managedLedgerInterceptor == null) {
            return;
        }
        this.managedLedgerInterceptor.afterFailedAddEntry(numOfMessages);
    }

    protected boolean beforeAddEntry(OpAddEntry addOperation) {
        if (this.managedLedgerInterceptor == null) {
            return true;
        }
        try {
            this.managedLedgerInterceptor.beforeAddEntry(addOperation, addOperation.getNumberOfMessages());
            return true;
        }
        catch (Exception e) {
            addOperation.failed(new ManagedLedgerException.ManagedLedgerInterceptException("Interceptor managed ledger before add to bookie failed."));
            log.error("[{}] Failed to intercept adding an entry to bookie.", (Object)this.name, (Object)e);
            return false;
        }
    }

    @Override
    public void readyToCreateNewLedger() {
        if (STATE_UPDATER.compareAndSet(this, State.WriteFailed, State.ClosedLedger)) {
            log.info("[{}] Managed ledger is now ready to accept writes again", (Object)this.name);
        }
    }

    @Override
    public ManagedCursor openCursor(String cursorName) throws InterruptedException, ManagedLedgerException {
        return this.openCursor(cursorName, CommandSubscribe.InitialPosition.Latest);
    }

    @Override
    public ManagedCursor openCursor(String cursorName, CommandSubscribe.InitialPosition initialPosition) throws InterruptedException, ManagedLedgerException {
        return this.openCursor(cursorName, initialPosition, Collections.emptyMap(), Collections.emptyMap());
    }

    @Override
    public ManagedCursor openCursor(String cursorName, CommandSubscribe.InitialPosition initialPosition, Map<String, Long> properties, Map<String, String> cursorProperties) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedCursor cursor = null;
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncOpenCursor(cursorName, initialPosition, properties, cursorProperties, new AsyncCallbacks.OpenCursorCallback(){
            {
            }

            @Override
            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                result.cursor = cursor;
                counter.countDown();
            }

            @Override
            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during open-cursor operation");
        }
        if (result.exception != null) {
            log.error("Error adding entry", (Throwable)result.exception);
            throw result.exception;
        }
        return result.cursor;
    }

    @Override
    public void asyncOpenCursor(String cursorName, AsyncCallbacks.OpenCursorCallback callback, Object ctx) {
        this.asyncOpenCursor(cursorName, CommandSubscribe.InitialPosition.Latest, callback, ctx);
    }

    @Override
    public void asyncOpenCursor(String cursorName, CommandSubscribe.InitialPosition initialPosition, AsyncCallbacks.OpenCursorCallback callback, Object ctx) {
        this.asyncOpenCursor(cursorName, initialPosition, Collections.emptyMap(), Collections.emptyMap(), callback, ctx);
    }

    @Override
    public synchronized void asyncOpenCursor(final String cursorName, final CommandSubscribe.InitialPosition initialPosition, Map<String, Long> properties, Map<String, String> cursorProperties, final AsyncCallbacks.OpenCursorCallback callback, final Object ctx) {
        try {
            this.checkManagedLedgerIsOpen();
            this.checkFenced();
        }
        catch (ManagedLedgerException e) {
            callback.openCursorFailed(e, ctx);
            return;
        }
        if (this.uninitializedCursors.containsKey(cursorName)) {
            ((CompletableFuture)this.uninitializedCursors.get(cursorName).thenAccept(cursor -> callback.openCursorComplete((ManagedCursor)cursor, ctx))).exceptionally(ex -> {
                callback.openCursorFailed((ManagedLedgerException)ex, ctx);
                return null;
            });
            return;
        }
        ManagedCursor cachedCursor = this.cursors.get(cursorName);
        if (cachedCursor != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Cursor was already created {}", (Object)this.name, (Object)cachedCursor);
            }
            callback.openCursorComplete(cachedCursor, ctx);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Creating new cursor: {}", (Object)this.name, (Object)cursorName);
        }
        final ManagedCursorImpl cursor2 = new ManagedCursorImpl(this.bookKeeper, this.config, this, cursorName);
        CompletableFuture cursorFuture = new CompletableFuture();
        this.uninitializedCursors.put(cursorName, cursorFuture);
        PositionImpl position = CommandSubscribe.InitialPosition.Earliest == initialPosition ? this.getFirstPosition() : this.getLastPosition();
        cursor2.initialize(position, properties, cursorProperties, new ManagedCursorImpl.VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete() {
                log.info("[{}] Opened new cursor: {}", (Object)ManagedLedgerImpl.this.name, (Object)cursor2);
                cursor2.setActive();
                ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                synchronized (managedLedgerImpl) {
                    cursor2.initializeCursorPosition(CommandSubscribe.InitialPosition.Earliest == initialPosition ? ManagedLedgerImpl.this.getFirstPositionAndCounter() : ManagedLedgerImpl.this.getLastPositionAndCounter());
                    ManagedLedgerImpl.this.addCursor(cursor2);
                    ManagedLedgerImpl.this.uninitializedCursors.remove(cursorName).complete(cursor2);
                }
                callback.openCursorComplete(cursor2, ctx);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(ManagedLedgerException exception) {
                log.warn("[{}] Failed to open cursor: {}", (Object)ManagedLedgerImpl.this.name, (Object)cursor2);
                ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                synchronized (managedLedgerImpl) {
                    ManagedLedgerImpl.this.uninitializedCursors.remove(cursorName).completeExceptionally(exception);
                }
                callback.openCursorFailed(exception, ctx);
            }
        });
    }

    @Override
    public synchronized void asyncDeleteCursor(final String consumerName, final AsyncCallbacks.DeleteCursorCallback callback, final Object ctx) {
        final ManagedCursorImpl cursor = (ManagedCursorImpl)this.cursors.get(consumerName);
        if (cursor == null) {
            callback.deleteCursorFailed(new ManagedLedgerException.CursorNotFoundException("ManagedCursor not found: " + consumerName), ctx);
            return;
        }
        if (!cursor.isDurable()) {
            this.cursors.removeCursor(consumerName);
            this.deactivateCursorByName(consumerName);
            callback.deleteCursorComplete(ctx);
            return;
        }
        this.store.asyncRemoveCursor(this.name, consumerName, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                cursor.asyncDeleteCursorLedger();
                ManagedLedgerImpl.this.cursors.removeCursor(consumerName);
                ManagedLedgerImpl.this.deactivateCursorByName(consumerName);
                ManagedLedgerImpl.this.trimConsumedLedgersInBackground();
                log.info("[{}] [{}] Deleted cursor", (Object)ManagedLedgerImpl.this.name, (Object)consumerName);
                callback.deleteCursorComplete(ctx);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                ManagedLedgerImpl.this.handleBadVersion(e);
                callback.deleteCursorFailed(e, ctx);
            }
        });
    }

    @Override
    public void deleteCursor(String name) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncDeleteCursor(name, new AsyncCallbacks.DeleteCursorCallback(){
            {
            }

            @Override
            public void deleteCursorComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during delete-cursors operation");
        }
        if (result.exception != null) {
            log.error("Deleting cursor", (Throwable)result.exception);
            throw result.exception;
        }
    }

    @Override
    public ManagedCursor newNonDurableCursor(Position startCursorPosition) throws ManagedLedgerException {
        return this.newNonDurableCursor(startCursorPosition, "non-durable-cursor-" + UUID.randomUUID());
    }

    @Override
    public ManagedCursor newNonDurableCursor(Position startPosition, String subscriptionName) throws ManagedLedgerException {
        return this.newNonDurableCursor(startPosition, subscriptionName, CommandSubscribe.InitialPosition.Latest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedCursor newNonDurableCursor(Position startCursorPosition, String cursorName, CommandSubscribe.InitialPosition initialPosition, boolean isReadCompacted) throws ManagedLedgerException {
        Objects.requireNonNull(cursorName, "cursor name can't be null");
        this.checkManagedLedgerIsOpen();
        this.checkFenced();
        ManagedCursor cachedCursor = this.cursors.get(cursorName);
        if (cachedCursor != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Cursor was already created {}", (Object)this.name, (Object)cachedCursor);
            }
            return cachedCursor;
        }
        NonDurableCursorImpl cursor = new NonDurableCursorImpl(this.bookKeeper, this.config, this, cursorName, (PositionImpl)startCursorPosition, initialPosition, isReadCompacted);
        cursor.setActive();
        log.info("[{}] Opened new cursor: {}", (Object)this.name, (Object)cursor);
        ManagedLedgerImpl managedLedgerImpl = this;
        synchronized (managedLedgerImpl) {
            this.addCursor(cursor);
        }
        return cursor;
    }

    public ManagedCursorContainer getCursors() {
        return this.cursors;
    }

    public ManagedCursorContainer getActiveCursors() {
        return this.activeCursors;
    }

    public boolean hasActiveCursors() {
        return !this.activeCursors.isEmpty();
    }

    @Override
    public long getNumberOfEntries() {
        return NUMBER_OF_ENTRIES_UPDATER.get(this);
    }

    @Override
    public long getNumberOfActiveEntries() {
        long totalEntries = this.getNumberOfEntries();
        PositionImpl pos = this.cursors.getSlowestReaderPosition();
        if (pos == null) {
            return 0L;
        }
        return totalEntries - (pos.getEntryId() + 1L);
    }

    @Override
    public long getTotalSize() {
        return TOTAL_SIZE_UPDATER.get(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEstimatedBacklogSize() {
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo;
        PositionImpl pos = this.getMarkDeletePositionOfSlowestConsumer();
        while (true) {
            if (pos == null) {
                return 0L;
            }
            long size = 0L;
            long slowestConsumerLedgerId = pos.getLedgerId();
            ManagedLedgerImpl managedLedgerImpl = this;
            synchronized (managedLedgerImpl) {
                size = this.getTotalSize();
                size -= this.ledgers.values().stream().filter(li -> li.getLedgerId() < slowestConsumerLedgerId).mapToLong(MLDataFormats.ManagedLedgerInfo.LedgerInfo::getSize).sum();
            }
            ledgerInfo = null;
            ManagedLedgerImpl managedLedgerImpl2 = this;
            synchronized (managedLedgerImpl2) {
                ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(pos.getLedgerId());
            }
            if (ledgerInfo != null) break;
            if (pos.compareTo(this.getMarkDeletePositionOfSlowestConsumer()) == 0) {
                return size;
            }
            pos = this.getMarkDeletePositionOfSlowestConsumer();
        }
        long numEntries = pos.getEntryId();
        if (ledgerInfo.getEntries() == 0L) {
            return size -= this.consumedLedgerSize(this.currentLedgerSize, this.currentLedgerEntries, numEntries);
        }
        return size -= this.consumedLedgerSize(ledgerInfo.getSize(), ledgerInfo.getEntries(), numEntries);
    }

    @Override
    public CompletableFuture<Long> getEarliestMessagePublishTimeInBacklog() {
        PositionImpl pos = this.getMarkDeletePositionOfSlowestConsumer();
        return this.getEarliestMessagePublishTimeOfPos(pos);
    }

    public CompletableFuture<Long> getEarliestMessagePublishTimeOfPos(PositionImpl pos) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        if (pos == null) {
            future.complete(0L);
            return future;
        }
        final PositionImpl nextPos = this.getNextValidPosition(pos);
        if (nextPos.compareTo(this.lastConfirmedEntry) > 0) {
            return CompletableFuture.completedFuture(-1L);
        }
        this.asyncReadEntry(nextPos, new AsyncCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readEntryComplete(Entry entry, Object ctx) {
                try {
                    long entryTimestamp = Commands.getEntryTimestamp((ByteBuf)entry.getDataBuffer());
                    future.complete(entryTimestamp);
                }
                catch (IOException e) {
                    log.error("Error deserializing message for message position {}", (Object)nextPos, (Object)e);
                    future.completeExceptionally(e);
                }
                finally {
                    entry.release();
                }
            }

            @Override
            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Error read entry for position {}", (Object)nextPos, (Object)exception);
                future.completeExceptionally(exception);
            }

            public String toString() {
                return String.format("ML [%s] get earliest message publish time of pos", ManagedLedgerImpl.this.name);
            }
        }, null);
        return future;
    }

    public long getEstimatedBacklogSize(PositionImpl pos) {
        if (pos == null) {
            return 0L;
        }
        return this.estimateBacklogFromPosition(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long estimateBacklogFromPosition(PositionImpl pos) {
        ManagedLedgerImpl managedLedgerImpl = this;
        synchronized (managedLedgerImpl) {
            long sizeBeforePosLedger = this.ledgers.headMap(pos.getLedgerId()).values().stream().mapToLong(MLDataFormats.ManagedLedgerInfo.LedgerInfo::getSize).sum();
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(pos.getLedgerId());
            long sizeAfter = this.getTotalSize() - sizeBeforePosLedger;
            if (ledgerInfo == null) {
                return sizeAfter;
            }
            if (pos.getLedgerId() == this.currentLedger.getId()) {
                return sizeAfter - this.consumedLedgerSize(this.currentLedgerSize, this.currentLedgerEntries, pos.getEntryId());
            }
            return sizeAfter - this.consumedLedgerSize(ledgerInfo.getSize(), ledgerInfo.getEntries(), pos.getEntryId());
        }
    }

    private long consumedLedgerSize(long ledgerSize, long ledgerEntries, long consumedEntries) {
        if (ledgerEntries <= 0L) {
            return 0L;
        }
        if (ledgerEntries <= consumedEntries + 1L) {
            return ledgerSize;
        }
        long averageSize = ledgerSize / ledgerEntries;
        return consumedEntries >= 0L ? (consumedEntries + 1L) * averageSize : 0L;
    }

    @Override
    public synchronized void asyncTerminate(final AsyncCallbacks.TerminateCallback callback, final Object ctx) {
        if (this.state == State.Fenced) {
            callback.terminateFailed(new ManagedLedgerException.ManagedLedgerFencedException(), ctx);
            return;
        }
        if (this.state == State.Terminated) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ignoring request to terminate an already terminated managed ledger", (Object)this.name);
            }
            callback.terminateComplete(this.lastConfirmedEntry, ctx);
            return;
        }
        log.info("[{}] Terminating managed ledger", (Object)this.name);
        this.state = State.Terminated;
        LedgerHandle lh = this.currentLedger;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Closing current writing ledger {}", (Object)this.name, (Object)lh.getId());
        }
        this.mbean.startDataLedgerCloseOp();
        lh.asyncClose((rc, lh1, ctx1) -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Close complete for ledger {}: rc = {}", new Object[]{this.name, lh.getId(), rc});
            }
            this.mbean.endDataLedgerCloseOp();
            if (rc != 0) {
                callback.terminateFailed(ManagedLedgerImpl.createManagedLedgerException(rc), ctx);
            } else {
                this.lastConfirmedEntry = new PositionImpl(lh.getId(), lh.getLastAddConfirmed());
                this.store.asyncUpdateLedgerIds(this.name, this.getManagedLedgerInfo(), this.ledgersStat, new MetaStore.MetaStoreCallback<Void>(){

                    @Override
                    public void operationComplete(Void result, Stat stat) {
                        ManagedLedgerImpl.this.ledgersStat = stat;
                        log.info("[{}] Terminated managed ledger at {}", (Object)ManagedLedgerImpl.this.name, (Object)ManagedLedgerImpl.this.lastConfirmedEntry);
                        callback.terminateComplete(ManagedLedgerImpl.this.lastConfirmedEntry, ctx);
                    }

                    @Override
                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        log.error("[{}] Failed to terminate managed ledger: {}", (Object)ManagedLedgerImpl.this.name, (Object)e.getMessage());
                        ManagedLedgerImpl.this.handleBadVersion(e);
                        callback.terminateFailed(new ManagedLedgerException(e), ctx);
                    }
                });
            }
        }, null);
    }

    @Override
    public Position terminate() throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            Position lastPosition = null;
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncTerminate(new AsyncCallbacks.TerminateCallback(){
            {
            }

            @Override
            public void terminateComplete(Position lastPosition, Object ctx) {
                result.lastPosition = lastPosition;
                counter.countDown();
            }

            @Override
            public void terminateFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during managed ledger terminate");
        }
        if (result.exception != null) {
            log.error("[{}] Error terminating managed ledger", (Object)this.name, (Object)result.exception);
            throw result.exception;
        }
        return result.lastPosition;
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.Terminated;
    }

    @Override
    public void close() throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncClose(new AsyncCallbacks.CloseCallback(){
            {
            }

            @Override
            public void closeComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during managed ledger close");
        }
        if (result.exception != null) {
            log.error("[{}] Error closing managed ledger", (Object)this.name, (Object)result.exception);
            throw result.exception;
        }
    }

    @Override
    public synchronized void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        State state = STATE_UPDATER.get(this);
        if (state == State.Fenced) {
            this.cancelScheduledTasks();
            this.factory.close(this);
            callback.closeFailed(new ManagedLedgerException.ManagedLedgerFencedException(), ctx);
            return;
        }
        if (state == State.Closed) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ignoring request to close a closed managed ledger", (Object)this.name);
            }
            callback.closeComplete(ctx);
            return;
        }
        log.info("[{}] Closing managed ledger", (Object)this.name);
        this.factory.close(this);
        STATE_UPDATER.set(this, State.Closed);
        this.cancelScheduledTasks();
        LedgerHandle lh = this.currentLedger;
        if (lh == null) {
            this.closeAllCursors(callback, ctx);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Closing current writing ledger {}", (Object)this.name, (Object)lh.getId());
        }
        this.mbean.startDataLedgerCloseOp();
        lh.asyncClose((rc, lh1, ctx1) -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Close complete for ledger {}: rc = {}", new Object[]{this.name, lh.getId(), rc});
            }
            this.mbean.endDataLedgerCloseOp();
            if (rc != 0) {
                callback.closeFailed(ManagedLedgerImpl.createManagedLedgerException(rc), ctx);
                return;
            }
            this.ledgerCache.forEach((ledgerId, readHandle) -> this.invalidateReadHandle(ledgerId));
            this.closeAllCursors(callback, ctx);
        }, null);
    }

    private void closeAllCursors(AsyncCallbacks.CloseCallback callback, Object ctx) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ManagedCursor cursor : this.cursors) {
            Futures.CloseFuture closeFuture = new Futures.CloseFuture();
            cursor.asyncClose(closeFuture, null);
            futures.add(closeFuture);
        }
        ((CompletableFuture)Futures.waitForAll(futures).thenRun(() -> callback.closeComplete(ctx))).exceptionally(exception -> {
            callback.closeFailed(ManagedLedgerException.getManagedLedgerException(exception.getCause()), ctx);
            return null;
        });
    }

    public synchronized void createComplete(int rc, final LedgerHandle lh, Object ctx) {
        if (STATE_UPDATER.get(this) == State.Closed) {
            if (lh != null) {
                log.warn("[{}] ledger create completed after the managed ledger is closed rc={} ledger={}, so just close this ledger handle.", new Object[]{this.name, rc, lh != null ? lh.getId() : -1L});
                lh.closeAsync();
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] createComplete rc={} ledger={}", new Object[]{this.name, rc, lh != null ? lh.getId() : -1L});
        }
        if (this.checkAndCompleteLedgerOpTask(rc, lh, ctx)) {
            return;
        }
        this.mbean.endDataLedgerCreateOp();
        if (rc != 0) {
            log.error("[{}] Error creating ledger rc={} {}", new Object[]{this.name, rc, org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
            ManagedLedgerException status = ManagedLedgerImpl.createManagedLedgerException(rc);
            if (this.pendingAddEntries.isEmpty()) {
                STATE_UPDATER.set(this, State.ClosedLedger);
            } else {
                STATE_UPDATER.set(this, State.WriteFailed);
            }
            this.clearPendingAddEntries(status);
            this.lastLedgerCreationFailureTimestamp = this.clock.millis();
        } else {
            log.info("[{}] Created new ledger {}", (Object)this.name, (Object)lh.getId());
            final MLDataFormats.ManagedLedgerInfo.LedgerInfo newLedger = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lh.getId()).setTimestamp(0L).build();
            MetaStore.MetaStoreCallback<Void> cb = new MetaStore.MetaStoreCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(Void v, Stat stat) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Updating of ledgers list after create complete. version={}", (Object)ManagedLedgerImpl.this.name, (Object)stat);
                    }
                    ManagedLedgerImpl.this.ledgersStat = stat;
                    ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                    synchronized (managedLedgerImpl) {
                        LedgerHandle originalCurrentLedger = ManagedLedgerImpl.this.currentLedger;
                        ManagedLedgerImpl.this.ledgers.put(lh.getId(), newLedger);
                        ManagedLedgerImpl.this.currentLedger = lh;
                        ManagedLedgerImpl.this.currentLedgerEntries = 0L;
                        ManagedLedgerImpl.this.currentLedgerSize = 0L;
                        ManagedLedgerImpl.this.updateLedgersIdsComplete(originalCurrentLedger);
                        ManagedLedgerImpl.this.mbean.addLedgerSwitchLatencySample(System.currentTimeMillis() - ManagedLedgerImpl.this.lastLedgerCreationInitiationTimestamp, TimeUnit.MILLISECONDS);
                    }
                    ManagedLedgerImpl.this.metadataMutex.unlock();
                    ManagedLedgerImpl.this.maybeUpdateCursorBeforeTrimmingConsumedLedger();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                    log.warn("[{}] Error updating meta data with the new list of ledgers: {}", (Object)ManagedLedgerImpl.this.name, (Object)e.getMessage());
                    ManagedLedgerImpl.this.handleBadVersion(e);
                    ManagedLedgerImpl.this.mbean.startDataLedgerDeleteOp();
                    ManagedLedgerImpl.this.bookKeeper.asyncDeleteLedger(lh.getId(), (rc1, ctx1) -> {
                        ManagedLedgerImpl.this.mbean.endDataLedgerDeleteOp();
                        if (rc1 != 0) {
                            log.warn("[{}] Failed to delete ledger {}: {}", new Object[]{ManagedLedgerImpl.this.name, lh.getId(), org.apache.bookkeeper.client.BKException.getMessage((int)rc1)});
                        }
                    }, null);
                    if (e instanceof ManagedLedgerException.BadVersionException) {
                        ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                        synchronized (managedLedgerImpl) {
                            log.error("[{}] Failed to update ledger list. z-node version mismatch. Closing managed ledger", (Object)ManagedLedgerImpl.this.name);
                            ManagedLedgerImpl.this.lastLedgerCreationFailureTimestamp = ManagedLedgerImpl.this.clock.millis();
                            ManagedLedgerImpl.this.clearPendingAddEntries(new ManagedLedgerException.ManagedLedgerFencedException(e));
                            return;
                        }
                    }
                    ManagedLedgerImpl.this.metadataMutex.unlock();
                    ManagedLedgerImpl managedLedgerImpl = ManagedLedgerImpl.this;
                    synchronized (managedLedgerImpl) {
                        ManagedLedgerImpl.this.lastLedgerCreationFailureTimestamp = ManagedLedgerImpl.this.clock.millis();
                        STATE_UPDATER.set(ManagedLedgerImpl.this, State.ClosedLedger);
                        ManagedLedgerImpl.this.clearPendingAddEntries(e);
                    }
                }
            };
            this.updateLedgersListAfterRollover(cb, newLedger);
        }
    }

    private void handleBadVersion(Throwable e) {
        if (e instanceof ManagedLedgerException.BadVersionException) {
            this.setFenced();
        }
    }

    private void updateLedgersListAfterRollover(MetaStore.MetaStoreCallback<Void> callback, MLDataFormats.ManagedLedgerInfo.LedgerInfo newLedger) {
        if (!this.metadataMutex.tryLock()) {
            this.scheduledExecutor.schedule(() -> this.updateLedgersListAfterRollover(callback, newLedger), 100L, TimeUnit.MILLISECONDS);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Updating ledgers ids with new ledger. version={}", (Object)this.name, (Object)this.ledgersStat);
        }
        MLDataFormats.ManagedLedgerInfo mlInfo = this.getManagedLedgerInfo(newLedger);
        this.store.asyncUpdateLedgerIds(this.name, mlInfo, this.ledgersStat, callback);
    }

    public synchronized void updateLedgersIdsComplete(@Nullable LedgerHandle originalCurrentLedger) {
        OpAddEntry existsOp;
        STATE_UPDATER.set(this, State.LedgerOpened);
        if (originalCurrentLedger != null && !this.ledgers.containsKey(originalCurrentLedger.getId())) {
            this.bookKeeper.asyncDeleteLedger(originalCurrentLedger.getId(), (rc, ctx) -> {
                this.mbean.endDataLedgerDeleteOp();
                log.info("[{}] Delete complete for empty ledger {}. rc={}", new Object[]{this.name, originalCurrentLedger.getId(), rc});
            }, null);
        }
        this.updateLastLedgerCreatedTimeAndScheduleRolloverTask();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Resending {} pending messages", (Object)this.name, (Object)this.pendingAddEntries.size());
        }
        int pendingSize = this.pendingAddEntries.size();
        do {
            if ((existsOp = this.pendingAddEntries.poll()) == null) continue;
            if (existsOp.ledger != null) {
                existsOp.close();
                existsOp = OpAddEntry.createNoRetainBuffer(existsOp.ml, existsOp.data, existsOp.getNumberOfMessages(), existsOp.callback, existsOp.ctx);
            }
            existsOp.setLedger(this.currentLedger);
            this.pendingAddEntries.add(existsOp);
        } while (existsOp != null && --pendingSize > 0);
        for (OpAddEntry op : this.pendingAddEntries) {
            ++this.currentLedgerEntries;
            this.currentLedgerSize += (long)op.data.readableBytes();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Sending {}", (Object)this.name, (Object)op);
            }
            if (this.currentLedgerIsFull()) {
                STATE_UPDATER.set(this, State.ClosingLedger);
                op.setCloseWhenDone(true);
                op.initiate();
                if (!log.isDebugEnabled()) break;
                log.debug("[{}] Stop writing into ledger {} queue={}", new Object[]{this.name, this.currentLedger.getId(), this.pendingAddEntries.size()});
                break;
            }
            op.initiate();
        }
    }

    synchronized void ledgerClosed(LedgerHandle lh) {
        State state = STATE_UPDATER.get(this);
        LedgerHandle currentLedger = this.currentLedger;
        if (currentLedger != lh || state != State.ClosingLedger && state != State.LedgerOpened) {
            if (state == State.Closed) {
                this.clearPendingAddEntries(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Managed ledger was already closed"));
                return;
            }
            return;
        }
        STATE_UPDATER.set(this, State.ClosedLedger);
        long entriesInLedger = lh.getLastAddConfirmed() + 1L;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Ledger has been closed id={} entries={}", new Object[]{this.name, lh.getId(), entriesInLedger});
        }
        if (entriesInLedger > 0L) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lh.getId()).setEntries(entriesInLedger).setSize(lh.getLength()).setTimestamp(this.clock.millis()).build();
            this.ledgers.put(lh.getId(), info);
        } else {
            this.ledgers.remove(lh.getId());
            this.mbean.startDataLedgerDeleteOp();
        }
        this.trimConsumedLedgersInBackground();
        this.maybeOffloadInBackground(NULL_OFFLOAD_PROMISE);
        if (!this.pendingAddEntries.isEmpty()) {
            this.createLedgerAfterClosed();
        }
    }

    @Override
    public void skipNonRecoverableLedger(long ledgerId) {
        for (ManagedCursor managedCursor : this.cursors) {
            managedCursor.skipNonRecoverableLedger(ledgerId);
        }
    }

    synchronized void createLedgerAfterClosed() {
        if (this.isNeededCreateNewLedgerAfterCloseLedger()) {
            log.info("[{}] Creating a new ledger after closed {}", (Object)this.name, this.currentLedger == null ? "null" : Long.valueOf(this.currentLedger.getId()));
            STATE_UPDATER.set(this, State.CreatingLedger);
            this.lastLedgerCreationInitiationTimestamp = System.currentTimeMillis();
            this.mbean.startDataLedgerCreateOp();
            this.executor.execute(() -> this.asyncCreateLedger(this.bookKeeper, this.config, this.digestType, this, Collections.emptyMap()));
        }
    }

    boolean isNeededCreateNewLedgerAfterCloseLedger() {
        State state = STATE_UPDATER.get(this);
        return state != State.CreatingLedger && state != State.LedgerOpened;
    }

    @Override
    @VisibleForTesting
    public void rollCurrentLedgerIfFull() {
        log.info("[{}] Start checking if current ledger is full", (Object)this.name);
        if (this.currentLedgerEntries > 0L && this.currentLedgerIsFull() && STATE_UPDATER.compareAndSet(this, State.LedgerOpened, State.ClosingLedger)) {
            this.currentLedger.asyncClose(new AsyncCallback.CloseCallback(){

                public void closeComplete(int rc, LedgerHandle lh, Object o) {
                    Preconditions.checkArgument((ManagedLedgerImpl.this.currentLedger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)ManagedLedgerImpl.this.currentLedger.getId(), (long)lh.getId());
                    if (rc == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Successfully closed ledger {}, trigger by rollover full ledger", (Object)ManagedLedgerImpl.this.name, (Object)lh.getId());
                        }
                    } else {
                        log.warn("[{}] Error when closing ledger {}, trigger by rollover full ledger, Status={}", new Object[]{ManagedLedgerImpl.this.name, lh.getId(), org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                    }
                    ManagedLedgerImpl.this.ledgerClosed(lh);
                    ManagedLedgerImpl.this.createLedgerAfterClosed();
                }
            }, null);
        }
    }

    @Override
    public CompletableFuture<Position> asyncFindPosition(final com.google.common.base.Predicate<Entry> predicate) {
        PositionImpl startPosition;
        final CompletableFuture<Position> future = new CompletableFuture<Position>();
        Long firstLedgerId = (Long)this.ledgers.firstKey();
        PositionImpl positionImpl = startPosition = firstLedgerId == null ? null : new PositionImpl(firstLedgerId, 0L);
        if (startPosition == null) {
            future.complete(null);
            return future;
        }
        AsyncCallbacks.FindEntryCallback findEntryCallback = new AsyncCallbacks.FindEntryCallback(){

            @Override
            public void findEntryComplete(Position position, Object ctx) {
                PositionImpl finalPosition;
                if (position == null) {
                    finalPosition = startPosition;
                    if (finalPosition == null) {
                        log.warn("[{}] Unable to find position for predicate {}.", (Object)ManagedLedgerImpl.this.name, (Object)predicate);
                        future.complete(null);
                        return;
                    }
                    log.info("[{}] Unable to find position for predicate {}. Use the first position {} instead.", new Object[]{ManagedLedgerImpl.this.name, predicate, startPosition});
                } else {
                    finalPosition = ManagedLedgerImpl.this.getNextValidPosition((PositionImpl)position);
                }
                future.complete(finalPosition);
            }

            @Override
            public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                log.warn("[{}] Unable to find position for predicate {}.", (Object)ManagedLedgerImpl.this.name, (Object)predicate);
                future.complete(null);
            }
        };
        long max = this.getNumberOfEntries() - 1L;
        OpFindNewest op = new OpFindNewest(this, startPosition, predicate, max, findEntryCallback, null);
        op.find();
        return future;
    }

    @Override
    public ManagedLedgerInterceptor getManagedLedgerInterceptor() {
        return this.managedLedgerInterceptor;
    }

    void clearPendingAddEntries(ManagedLedgerException e) {
        while (!this.pendingAddEntries.isEmpty()) {
            OpAddEntry op = this.pendingAddEntries.poll();
            op.failed(e);
        }
    }

    void asyncReadEntries(OpReadEntry opReadEntry) {
        State state = STATE_UPDATER.get(this);
        if (state == State.Fenced || state == State.Closed) {
            opReadEntry.readEntriesFailed(new ManagedLedgerException.ManagedLedgerFencedException(), opReadEntry.ctx);
            return;
        }
        long ledgerId = opReadEntry.readPosition.getLedgerId();
        LedgerHandle currentLedger = this.currentLedger;
        if (currentLedger != null && ledgerId == currentLedger.getId()) {
            this.internalReadFromLedger((ReadHandle)currentLedger, opReadEntry);
        } else {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId);
            if (ledgerInfo == null || ledgerInfo.getEntries() == 0L) {
                opReadEntry.updateReadPosition(new PositionImpl(opReadEntry.readPosition.getLedgerId() + 1L, 0L));
                opReadEntry.checkReadCompletion();
                return;
            }
            ((CompletableFuture)this.getLedgerHandle(ledgerId).thenAccept(ledger -> this.internalReadFromLedger((ReadHandle)ledger, opReadEntry))).exceptionally(ex -> {
                log.error("[{}] Error opening ledger for reading at position {} - {}", new Object[]{this.name, opReadEntry.readPosition, ex.getMessage()});
                opReadEntry.readEntriesFailed(ManagedLedgerException.getManagedLedgerException(ex.getCause()), opReadEntry.ctx);
                return null;
            });
        }
    }

    public CompletableFuture<String> getLedgerMetadata(long ledgerId) {
        LedgerHandle currentLedger = this.currentLedger;
        if (currentLedger != null && ledgerId == currentLedger.getId()) {
            return CompletableFuture.completedFuture(currentLedger.getLedgerMetadata().toSafeString());
        }
        return this.getLedgerHandle(ledgerId).thenApply(rh -> rh.getLedgerMetadata().toSafeString());
    }

    @Override
    public CompletableFuture<MLDataFormats.ManagedLedgerInfo.LedgerInfo> getLedgerInfo(long ledgerId) {
        CompletableFuture<MLDataFormats.ManagedLedgerInfo.LedgerInfo> result = new CompletableFuture<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId);
        result.complete(ledgerInfo);
        return result;
    }

    @Override
    public Optional<MLDataFormats.ManagedLedgerInfo.LedgerInfo> getOptionalLedgerInfo(long ledgerId) {
        return Optional.ofNullable((MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId));
    }

    CompletableFuture<ReadHandle> getLedgerHandle(long ledgerId) {
        CompletableFuture ledgerHandle = (CompletableFuture)this.ledgerCache.get(ledgerId);
        if (ledgerHandle != null) {
            return ledgerHandle;
        }
        return (CompletableFuture)this.ledgerCache.computeIfAbsent(ledgerId, lid -> {
            CompletableFuture openFuture;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Asynchronously opening ledger {} for read", (Object)this.name, (Object)ledgerId);
            }
            this.mbean.startDataLedgerOpenOp();
            CompletableFuture promise = new CompletableFuture();
            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId);
            if (this.config.getLedgerOffloader() != null && this.config.getLedgerOffloader().getOffloadPolicies() != null && this.config.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadedReadPriority() == OffloadedReadPriority.BOOKKEEPER_FIRST && info != null && info.hasOffloadContext() && !info.getOffloadContext().getBookkeeperDeleted()) {
                openFuture = this.bookKeeper.newOpenLedgerOp().withRecovery(!this.isReadOnly()).withLedgerId(ledgerId).withDigestType(this.config.getDigestType()).withPassword(this.config.getPassword()).execute();
            } else if (info != null && info.hasOffloadContext() && info.getOffloadContext().getComplete()) {
                UUID uid = new UUID(info.getOffloadContext().getUidMsb(), info.getOffloadContext().getUidLsb());
                Map<String, String> offloadDriverMetadata = OffloadUtils.getOffloadDriverMetadata(info);
                offloadDriverMetadata.put("ManagedLedgerName", this.name);
                openFuture = this.config.getLedgerOffloader().readOffloaded(ledgerId, uid, offloadDriverMetadata);
            } else {
                openFuture = this.bookKeeper.newOpenLedgerOp().withRecovery(!this.isReadOnly()).withLedgerId(ledgerId).withDigestType(this.config.getDigestType()).withPassword(this.config.getPassword()).execute();
            }
            openFuture.whenCompleteAsync((res, ex) -> {
                this.mbean.endDataLedgerOpenOp();
                if (ex != null) {
                    this.ledgerCache.remove(ledgerId, (Object)promise);
                    promise.completeExceptionally(ManagedLedgerImpl.createManagedLedgerException(ex));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Successfully opened ledger {} for reading", (Object)this.name, (Object)ledgerId);
                    }
                    promise.complete(res);
                }
            }, (Executor)this.executor.chooseThread((Object)this.name));
            return promise;
        });
    }

    void invalidateReadHandle(long ledgerId) {
        CompletableFuture rhf = (CompletableFuture)this.ledgerCache.remove(ledgerId);
        if (rhf != null) {
            ((CompletableFuture)rhf.thenAccept(Handle::closeAsync)).exceptionally(ex -> {
                log.warn("[{}] Failed to close a Ledger ReadHandle:", (Object)this.name, ex);
                return null;
            });
        }
    }

    public void invalidateLedgerHandle(ReadHandle ledgerHandle) {
        long ledgerId = ledgerHandle.getId();
        LedgerHandle currentLedger = this.currentLedger;
        if (currentLedger != null && ledgerId != currentLedger.getId()) {
            this.ledgerCache.remove(ledgerId);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Removed ledger read handle {} from cache", (Object)this.name, (Object)ledgerId);
            }
            ledgerHandle.closeAsync().exceptionally(ex -> {
                log.warn("[{}] Failed to close a Ledger ReadHandle:", (Object)this.name, ex);
                return null;
            });
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Ledger that encountered read error is current ledger", (Object)this.name);
        }
    }

    public void asyncReadEntry(PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        LedgerHandle currentLedger = this.currentLedger;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Reading entry ledger {}: {}", new Object[]{this.name, position.getLedgerId(), position.getEntryId()});
        }
        if (position.getLedgerId() == currentLedger.getId()) {
            this.asyncReadEntry((ReadHandle)currentLedger, position, callback, ctx);
        } else if (this.ledgers.containsKey(position.getLedgerId())) {
            ((CompletableFuture)this.getLedgerHandle(position.getLedgerId()).thenAccept(ledger -> this.asyncReadEntry((ReadHandle)ledger, position, callback, ctx))).exceptionally(ex -> {
                log.error("[{}] Error opening ledger for reading at position {} - {}", new Object[]{this.name, position, ex.getMessage()});
                callback.readEntryFailed(ManagedLedgerException.getManagedLedgerException(ex.getCause()), ctx);
                return null;
            });
        } else {
            log.error("[{}] Failed to get message with ledger {}:{} the ledgerId does not belong to this topic or has been deleted.", new Object[]{this.name, position.getLedgerId(), position.getEntryId()});
            callback.readEntryFailed(new ManagedLedgerException.LedgerNotExistException("Message not found, the ledgerId does not belong to this topic or has been deleted"), ctx);
        }
    }

    private void internalReadFromLedger(ReadHandle ledger, OpReadEntry opReadEntry) {
        if (opReadEntry.readPosition.compareTo(opReadEntry.maxPosition) > 0) {
            opReadEntry.checkReadCompletion();
            return;
        }
        long firstEntry = opReadEntry.readPosition.getEntryId();
        PositionImpl lastPosition = this.lastConfirmedEntry;
        long lastEntryInLedger = ledger.getId() == lastPosition.getLedgerId() ? lastPosition.getEntryId() : ledger.getLastAddConfirmed();
        if (ledger.getId() == opReadEntry.maxPosition.getLedgerId()) {
            lastEntryInLedger = Math.min(opReadEntry.maxPosition.getEntryId(), lastEntryInLedger);
        }
        if (firstEntry > lastEntryInLedger) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] No more messages to read from ledger={} lastEntry={} readEntry={}", new Object[]{this.name, ledger.getId(), lastEntryInLedger, firstEntry});
            }
            if (this.currentLedger == null || ledger.getId() != this.currentLedger.getId()) {
                Long nextLedgerId = this.ledgers.ceilingKey(ledger.getId() + 1L);
                if (nextLedgerId != null) {
                    opReadEntry.updateReadPosition(new PositionImpl(nextLedgerId, 0L));
                } else {
                    opReadEntry.updateReadPosition(new PositionImpl(ledger.getId() + 1L, 0L));
                }
            } else {
                opReadEntry.updateReadPosition(opReadEntry.readPosition);
            }
            opReadEntry.checkReadCompletion();
            return;
        }
        long lastEntry = Math.min(firstEntry + (long)opReadEntry.getNumberOfEntriesToRead() - 1L, lastEntryInLedger);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Reading entries from ledger {} - first={} last={}", new Object[]{this.name, ledger.getId(), firstEntry, lastEntry});
        }
        this.asyncReadEntry(ledger, firstEntry, lastEntry, opReadEntry, opReadEntry.ctx);
    }

    protected void asyncReadEntry(ReadHandle ledger, PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        this.mbean.addEntriesRead(1);
        if (this.config.getReadEntryTimeoutSeconds() > 0L) {
            ReadEntryCallbackWrapper readCallback;
            long readOpCount = READ_OP_COUNT_UPDATER.incrementAndGet(this);
            long createdTime = System.nanoTime();
            this.lastReadCallback = readCallback = ReadEntryCallbackWrapper.create(this.name, position.getLedgerId(), position.getEntryId(), callback, readOpCount, createdTime, ctx);
            this.entryCache.asyncReadEntry(ledger, position, readCallback, readOpCount);
        } else {
            this.entryCache.asyncReadEntry(ledger, position, callback, ctx);
        }
    }

    protected void asyncReadEntry(ReadHandle ledger, long firstEntry, long lastEntry, OpReadEntry opReadEntry, Object ctx) {
        if (this.config.getReadEntryTimeoutSeconds() > 0L) {
            ReadEntryCallbackWrapper readCallback;
            long readOpCount = READ_OP_COUNT_UPDATER.incrementAndGet(this);
            long createdTime = System.nanoTime();
            this.lastReadCallback = readCallback = ReadEntryCallbackWrapper.create(this.name, ledger.getId(), firstEntry, opReadEntry, readOpCount, createdTime, ctx);
            this.entryCache.asyncReadEntry(ledger, firstEntry, lastEntry, opReadEntry.cursor.isCacheReadEntry(), readCallback, readOpCount);
        } else {
            this.entryCache.asyncReadEntry(ledger, firstEntry, lastEntry, opReadEntry.cursor.isCacheReadEntry(), opReadEntry, ctx);
        }
    }

    @Override
    public ManagedLedgerMXBean getStats() {
        return this.mbean;
    }

    public boolean hasMoreEntries(PositionImpl position) {
        boolean result;
        PositionImpl lastPos = this.lastConfirmedEntry;
        boolean bl = result = position.compareTo(lastPos) <= 0;
        if (log.isDebugEnabled()) {
            log.debug("[{}] hasMoreEntries: pos={} lastPos={} res={}", new Object[]{this.name, position, lastPos, result});
        }
        return result;
    }

    void doCacheEviction(long maxTimestamp) {
        if (this.entryCache.getSize() > 0L) {
            this.entryCache.invalidateEntriesBeforeTimestamp(maxTimestamp);
        }
    }

    private void invalidateEntriesUpToSlowestReaderPosition() {
        if (this.entryCache.getSize() <= 0L) {
            return;
        }
        if (!this.activeCursors.isEmpty()) {
            PositionImpl evictionPos = this.activeCursors.getSlowestReaderPosition();
            if (evictionPos != null) {
                this.entryCache.invalidateEntries(evictionPos);
            }
        } else {
            this.entryCache.clear();
        }
    }

    void onCursorMarkDeletePositionUpdated(ManagedCursorImpl cursor, PositionImpl newPosition) {
        PositionImpl currentSlowestReader;
        if (this.config.isCacheEvictionByMarkDeletedPosition()) {
            this.updateActiveCursor(cursor, newPosition);
        }
        if (!cursor.isDurable()) {
            return;
        }
        Pair<PositionImpl, PositionImpl> pair = this.cursors.cursorUpdated(cursor, newPosition);
        if (pair == null) {
            this.trimConsumedLedgersInBackground();
            return;
        }
        PositionImpl previousSlowestReader = (PositionImpl)pair.getLeft();
        if (previousSlowestReader.compareTo(currentSlowestReader = (PositionImpl)pair.getRight()) == 0) {
            return;
        }
        if (previousSlowestReader.getLedgerId() != newPosition.getLedgerId()) {
            this.trimConsumedLedgersInBackground();
        }
    }

    private void updateActiveCursor(ManagedCursorImpl cursor, Position newPosition) {
        Pair<PositionImpl, PositionImpl> slowestPositions = this.activeCursors.cursorUpdated(cursor, newPosition);
        if (slowestPositions != null && !((PositionImpl)slowestPositions.getLeft()).equals(slowestPositions.getRight())) {
            this.invalidateEntriesUpToSlowestReaderPosition();
        }
    }

    public void onCursorReadPositionUpdated(ManagedCursorImpl cursor, Position newReadPosition) {
        if (!this.config.isCacheEvictionByMarkDeletedPosition()) {
            this.updateActiveCursor(cursor, newReadPosition);
        }
    }

    PositionImpl startReadOperationOnLedger(PositionImpl position) {
        Long ledgerId = this.ledgers.ceilingKey(position.getLedgerId());
        if (ledgerId != null && ledgerId.longValue() != position.getLedgerId()) {
            position = new PositionImpl(ledgerId, 0L);
        }
        return position;
    }

    void notifyCursors() {
        ManagedCursorImpl waitingCursor;
        while ((waitingCursor = this.waitingCursors.poll()) != null) {
            this.executor.execute((Runnable)SafeRun.safeRun(waitingCursor::notifyEntriesAvailable));
        }
    }

    void notifyWaitingEntryCallBacks() {
        WaitingEntryCallBack cb;
        while ((cb = this.waitingEntryCallBacks.poll()) != null) {
            this.executor.execute((Runnable)SafeRun.safeRun(cb::entriesAvailable));
        }
    }

    public void addWaitingEntryCallBack(WaitingEntryCallBack cb) {
        this.waitingEntryCallBacks.add(cb);
    }

    public void maybeUpdateCursorBeforeTrimmingConsumedLedger() {
        for (ManagedCursor cursor : this.cursors) {
            PositionImpl lastAckedPosition = (PositionImpl)cursor.getMarkDeletedPosition();
            MLDataFormats.ManagedLedgerInfo.LedgerInfo currPointedLedger = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(lastAckedPosition.getLedgerId());
            MLDataFormats.ManagedLedgerInfo.LedgerInfo nextPointedLedger = Optional.ofNullable(this.ledgers.higherEntry(lastAckedPosition.getLedgerId())).map(Map.Entry::getValue).orElse(null);
            if (currPointedLedger != null) {
                if (nextPointedLedger != null) {
                    if (lastAckedPosition.getEntryId() != -1L && lastAckedPosition.getEntryId() + 1L >= currPointedLedger.getEntries()) {
                        lastAckedPosition = new PositionImpl(nextPointedLedger.getLedgerId(), -1L);
                    }
                } else {
                    log.debug("No need to reset cursor: {}, current ledger is the last ledger.", (Object)cursor);
                }
            } else {
                log.warn("Cursor: {} does not exist in the managed-ledger.", (Object)cursor);
            }
            if (lastAckedPosition.equals((PositionImpl)cursor.getMarkDeletedPosition())) continue;
            try {
                log.info("Reset cursor:{} to {} since ledger consumed completely", (Object)cursor, (Object)lastAckedPosition);
                this.onCursorMarkDeletePositionUpdated((ManagedCursorImpl)cursor, lastAckedPosition);
            }
            catch (Exception e) {
                log.warn("Failed to reset cursor: {} from {} to {}. Trimming thread will retry next time.", new Object[]{cursor, cursor.getMarkDeletedPosition(), lastAckedPosition});
                log.warn("Caused by", (Throwable)e);
            }
        }
    }

    private void trimConsumedLedgersInBackground() {
        this.trimConsumedLedgersInBackground(Futures.NULL_PROMISE);
    }

    @Override
    public void trimConsumedLedgersInBackground(CompletableFuture<?> promise) {
        this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> this.internalTrimConsumedLedgers(promise)));
    }

    public void trimConsumedLedgersInBackground(boolean isTruncate, CompletableFuture<?> promise) {
        this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> this.internalTrimLedgers(isTruncate, promise)));
    }

    private void scheduleDeferredTrimming(boolean isTruncate, CompletableFuture<?> promise) {
        this.scheduledExecutor.schedule((SafeRunnable)SafeRun.safeRun(() -> this.trimConsumedLedgersInBackground(isTruncate, promise)), 100L, TimeUnit.MILLISECONDS);
    }

    private void maybeOffloadInBackground(CompletableFuture<PositionImpl> promise) {
        if (this.config.getLedgerOffloader() != null && this.config.getLedgerOffloader() != NullLedgerOffloader.INSTANCE && this.config.getLedgerOffloader().getOffloadPolicies() != null && this.config.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes() != null && this.config.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes() >= 0L) {
            this.executor.executeOrdered((Object)this.name, (SafeRunnable)SafeRun.safeRun(() -> this.maybeOffload(promise)));
        }
    }

    private void maybeOffload(CompletableFuture<PositionImpl> finalPromise) {
        if (!this.offloadMutex.tryLock()) {
            this.scheduledExecutor.schedule((SafeRunnable)SafeRun.safeRun(() -> this.maybeOffloadInBackground(finalPromise)), 100L, TimeUnit.MILLISECONDS);
        } else {
            CompletableFuture<PositionImpl> unlockingPromise = new CompletableFuture<PositionImpl>();
            unlockingPromise.whenComplete((res, ex) -> {
                this.offloadMutex.unlock();
                if (ex != null) {
                    finalPromise.completeExceptionally((Throwable)ex);
                } else {
                    finalPromise.complete((PositionImpl)res);
                }
            });
            if (this.config.getLedgerOffloader() != null && this.config.getLedgerOffloader() != NullLedgerOffloader.INSTANCE && this.config.getLedgerOffloader().getOffloadPolicies() != null && this.config.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes() != null) {
                long threshold = this.config.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes();
                long sizeSummed = 0L;
                long alreadyOffloadedSize = 0L;
                long toOffloadSize = 0L;
                ConcurrentLinkedDeque<MLDataFormats.ManagedLedgerInfo.LedgerInfo> toOffload = new ConcurrentLinkedDeque<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
                for (Map.Entry e : this.ledgers.descendingMap().entrySet()) {
                    boolean alreadyOffloaded;
                    long size = ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)e.getValue()).getSize();
                    sizeSummed += size;
                    boolean bl = alreadyOffloaded = ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)e.getValue()).hasOffloadContext() && ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)e.getValue()).getOffloadContext().getComplete();
                    if (alreadyOffloaded) {
                        alreadyOffloadedSize += size;
                        continue;
                    }
                    if (sizeSummed <= threshold) continue;
                    toOffloadSize += size;
                    toOffload.addFirst((MLDataFormats.ManagedLedgerInfo.LedgerInfo)e.getValue());
                }
                if (toOffload.size() > 0) {
                    log.info("[{}] Going to automatically offload ledgers {}, total size = {}, already offloaded = {}, to offload = {}", new Object[]{this.name, toOffload.stream().map(MLDataFormats.ManagedLedgerInfo.LedgerInfo::getLedgerId).collect(Collectors.toList()), sizeSummed, alreadyOffloadedSize, toOffloadSize});
                    this.offloadLoop(unlockingPromise, toOffload, PositionImpl.LATEST, Optional.empty());
                } else {
                    log.debug("[{}] Nothing to offload, total size = {}, already offloaded = {}, threshold = {}", new Object[]{this.name, sizeSummed, alreadyOffloadedSize, threshold});
                    unlockingPromise.complete(PositionImpl.LATEST);
                }
            }
        }
    }

    private boolean hasLedgerRetentionExpired(long retentionTimeMs, long ledgerTimestamp) {
        return retentionTimeMs >= 0L && this.clock.millis() - ledgerTimestamp > retentionTimeMs;
    }

    private boolean isLedgerRetentionOverSizeQuota(long retentionSizeInMB, long totalSizeOfML, long sizeToDelete) {
        return retentionSizeInMB >= 0L && totalSizeOfML - sizeToDelete >= retentionSizeInMB * 0x100000L;
    }

    boolean isOffloadedNeedsDelete(MLDataFormats.OffloadContext offload, Optional<OffloadPolicies> offloadPolicies) {
        long elapsedMs = this.clock.millis() - offload.getTimestamp();
        return offloadPolicies.filter(policies -> offload.getComplete() && !offload.getBookkeeperDeleted() && policies.getManagedLedgerOffloadDeletionLagInMillis() != null && elapsedMs > policies.getManagedLedgerOffloadDeletionLagInMillis()).isPresent();
    }

    void internalTrimConsumedLedgers(CompletableFuture<?> promise) {
        this.internalTrimLedgers(false, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalTrimLedgers(boolean isTruncate, final CompletableFuture<?> promise) {
        if (!this.factory.isMetadataServiceAvailable()) {
            promise.complete(null);
            return;
        }
        if (!this.trimmerMutex.tryLock()) {
            this.scheduleDeferredTrimming(isTruncate, promise);
            return;
        }
        final ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersToDelete = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        final ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> offloadedLedgersToDelete = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        Optional<Object> optionalOffloadPolicies = Optional.ofNullable(this.config.getLedgerOffloader() != null && this.config.getLedgerOffloader() != NullLedgerOffloader.INSTANCE ? this.config.getLedgerOffloader().getOffloadPolicies() : null);
        ManagedLedgerImpl managedLedgerImpl = this;
        synchronized (managedLedgerImpl) {
            Object ls;
            State currentState;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Start TrimConsumedLedgers. ledgers={} totalSize={}", new Object[]{this.name, this.ledgers.keySet(), TOTAL_SIZE_UPDATER.get(this)});
            }
            if ((currentState = STATE_UPDATER.get(this)) == State.Closed) {
                log.debug("[{}] Ignoring trimming request since the managed ledger was already closed", (Object)this.name);
                this.trimmerMutex.unlock();
                promise.completeExceptionally(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Can't trim closed ledger"));
                return;
            }
            if (currentState == State.Fenced) {
                log.debug("[{}] Ignoring trimming request since the managed ledger was already fenced", (Object)this.name);
                this.trimmerMutex.unlock();
                promise.completeExceptionally(new ManagedLedgerException.ManagedLedgerFencedException("Can't trim fenced ledger"));
                return;
            }
            long slowestReaderLedgerId = -1L;
            LazyLoadableValue slowestNonDurationLedgerId = new LazyLoadableValue(() -> this.getTheSlowestNonDurationReadPosition().getLedgerId());
            long retentionSizeInMB = this.config.getRetentionSizeInMB();
            long retentionTimeMs = this.config.getRetentionTimeMillis();
            long totalSizeOfML = TOTAL_SIZE_UPDATER.get(this);
            if (!this.cursors.hasDurableCursors()) {
                slowestReaderLedgerId = this.currentLedger.getId() + 1L;
            } else {
                PositionImpl slowestReaderPosition = this.cursors.getSlowestReaderPosition();
                if (slowestReaderPosition != null) {
                    slowestReaderLedgerId = slowestReaderPosition.getLedgerId();
                } else {
                    promise.completeExceptionally(new ManagedLedgerException("Couldn't find reader position"));
                    this.trimmerMutex.unlock();
                    return;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Slowest consumer ledger id: {}", (Object)this.name, (Object)slowestReaderLedgerId);
            }
            long totalSizeToDelete = 0L;
            Iterator ledgerInfoIterator = this.ledgers.headMap(slowestReaderLedgerId, false).values().iterator();
            while (ledgerInfoIterator.hasNext()) {
                ls = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledgerInfoIterator.next();
                if (((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId() == this.currentLedger.getId()) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("[{}] Ledger {} skipped for deletion as it is currently being written to", (Object)this.name, (Object)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId());
                    break;
                }
                if (isTruncate) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Ledger {} will be truncated with ts {}", new Object[]{this.name, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId(), ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getTimestamp()});
                    }
                    ledgersToDelete.add((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls);
                    continue;
                }
                boolean overRetentionQuota = this.isLedgerRetentionOverSizeQuota(retentionSizeInMB, totalSizeOfML, totalSizeToDelete += ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getSize());
                boolean expired = this.hasLedgerRetentionExpired(retentionTimeMs, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getTimestamp());
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Checking ledger {} -- time-old: {} sec -- expired: {} -- over-quota: {} -- current-ledger: {}", new Object[]{this.name, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId(), (double)(this.clock.millis() - ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getTimestamp()) / 1000.0, expired, overRetentionQuota, this.currentLedger.getId()});
                }
                if (expired || overRetentionQuota) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Ledger {} has expired or over quota, expired is: {}, ts: {}, overRetentionQuota is: {}, ledge size: {}", new Object[]{this.name, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId(), expired, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getTimestamp(), overRetentionQuota, ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getSize()});
                    }
                    ledgersToDelete.add((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Ledger {} not deleted. Neither expired nor over-quota", (Object)this.name, (Object)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId());
                }
                this.releaseReadHandleIfNoLongerRead(((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ls).getLedgerId(), (Long)slowestNonDurationLedgerId.getValue());
                break;
            }
            while (ledgerInfoIterator.hasNext() && this.releaseReadHandleIfNoLongerRead(((MLDataFormats.ManagedLedgerInfo.LedgerInfo)(ls = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledgerInfoIterator.next())).getLedgerId(), (Long)slowestNonDurationLedgerId.getValue())) {
            }
            for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls2 : this.ledgers.values()) {
                if (!this.isOffloadedNeedsDelete(ls2.getOffloadContext(), optionalOffloadPolicies) || ledgersToDelete.contains(ls2)) continue;
                log.debug("[{}] Ledger {} has been offloaded, bookkeeper ledger needs to be deleted", (Object)this.name, (Object)ls2.getLedgerId());
                offloadedLedgersToDelete.add(ls2);
            }
            if (ledgersToDelete.isEmpty() && offloadedLedgersToDelete.isEmpty()) {
                this.trimmerMutex.unlock();
                promise.complete(null);
                return;
            }
            if (currentState == State.CreatingLedger || !this.metadataMutex.tryLock()) {
                this.scheduleDeferredTrimming(isTruncate, promise);
                this.trimmerMutex.unlock();
                return;
            }
            try {
                this.advanceCursorsIfNecessary(ledgersToDelete);
            }
            catch (ManagedLedgerException.LedgerNotExistException e) {
                log.info("First non deleted Ledger is not found, stop trimming");
                this.metadataMutex.unlock();
                this.trimmerMutex.unlock();
                return;
            }
            PositionImpl currentLastConfirmedEntry = this.lastConfirmedEntry;
            for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls3 : ledgersToDelete) {
                if (currentLastConfirmedEntry != null && ls3.getLedgerId() == currentLastConfirmedEntry.getLedgerId()) {
                    log.info("[{}] Ledger {} contains the current last confirmed entry {}, and it is going to be deleted", new Object[]{this.name, ls3.getLedgerId(), currentLastConfirmedEntry});
                }
                this.invalidateReadHandle(ls3.getLedgerId());
                this.ledgers.remove(ls3.getLedgerId());
                NUMBER_OF_ENTRIES_UPDATER.addAndGet(this, -ls3.getEntries());
                TOTAL_SIZE_UPDATER.addAndGet(this, -ls3.getSize());
                this.entryCache.invalidateAllEntries(ls3.getLedgerId());
            }
            for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls4 : offloadedLedgersToDelete) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder newInfoBuilder = ls4.toBuilder();
                newInfoBuilder.getOffloadContextBuilder().setBookkeeperDeleted(true);
                String driverName = OffloadUtils.getOffloadDriverName(ls4, this.config.getLedgerOffloader().getOffloadDriverName());
                Map<String, String> driverMetadata = OffloadUtils.getOffloadDriverMetadata(ls4, this.config.getLedgerOffloader().getOffloadDriverMetadata());
                OffloadUtils.setOffloadDriverMetadata(newInfoBuilder, driverName, driverMetadata);
                this.ledgers.put(ls4.getLedgerId(), newInfoBuilder.build());
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Updating of ledgers list after trimming", (Object)this.name);
            }
            this.store.asyncUpdateLedgerIds(this.name, this.getManagedLedgerInfo(), this.ledgersStat, new MetaStore.MetaStoreCallback<Void>(){

                @Override
                public void operationComplete(Void result, Stat stat) {
                    log.info("[{}] End TrimConsumedLedgers. ledgers={} totalSize={}", new Object[]{ManagedLedgerImpl.this.name, ManagedLedgerImpl.this.ledgers.size(), TOTAL_SIZE_UPDATER.get(ManagedLedgerImpl.this)});
                    ManagedLedgerImpl.this.ledgersStat = stat;
                    ManagedLedgerImpl.this.metadataMutex.unlock();
                    ManagedLedgerImpl.this.trimmerMutex.unlock();
                    for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : ledgersToDelete) {
                        log.info("[{}] Removing ledger {} - size: {}", new Object[]{ManagedLedgerImpl.this.name, ls.getLedgerId(), ls.getSize()});
                        ManagedLedgerImpl.this.asyncDeleteLedger(ls.getLedgerId(), ls);
                    }
                    for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : offloadedLedgersToDelete) {
                        log.info("[{}] Deleting offloaded ledger {} from bookkeeper - size: {}", new Object[]{ManagedLedgerImpl.this.name, ls.getLedgerId(), ls.getSize()});
                        ManagedLedgerImpl.this.asyncDeleteLedgerFromBookKeeper(ls.getLedgerId());
                    }
                    promise.complete(null);
                }

                @Override
                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                    log.warn("[{}] Failed to update the list of ledgers after trimming", (Object)ManagedLedgerImpl.this.name, (Object)e);
                    ManagedLedgerImpl.this.metadataMutex.unlock();
                    ManagedLedgerImpl.this.trimmerMutex.unlock();
                    ManagedLedgerImpl.this.handleBadVersion(e);
                    promise.completeExceptionally(e);
                }
            });
        }
    }

    private boolean releaseReadHandleIfNoLongerRead(long ledgerId, long slowestNonDurationLedgerId) {
        if (ledgerId < slowestNonDurationLedgerId) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ledger {} no longer needs to be read, close the cached readHandle", (Object)this.name, (Object)ledgerId);
            }
            this.invalidateReadHandle(ledgerId);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void advanceCursorsIfNecessary(List<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersToDelete) throws ManagedLedgerException.LedgerNotExistException {
        if (ledgersToDelete.isEmpty()) {
            return;
        }
        PositionImpl highestPositionToDelete = this.calculateLastEntryInLedgerList(ledgersToDelete);
        if (highestPositionToDelete == null) {
            log.warn("[{}] The ledgers to be trim are all empty, skip to advance non-durable cursors: {}", (Object)this.name, ledgersToDelete);
            return;
        }
        this.cursors.forEach(cursor -> {
            if (!(highestPositionToDelete.compareTo((PositionImpl)cursor.getMarkDeletedPosition()) <= 0 || highestPositionToDelete.compareTo((PositionImpl)cursor.getManagedLedger().getLastConfirmedEntry()) > 0 || !cursor.isDurable() && cursor instanceof NonDurableCursorImpl && ((NonDurableCursorImpl)cursor).isReadCompacted())) {
                cursor.asyncMarkDelete(highestPositionToDelete, cursor.getProperties(), new AsyncCallbacks.MarkDeleteCallback(){

                    @Override
                    public void markDeleteComplete(Object ctx) {
                    }

                    @Override
                    public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                        log.warn("[{}] Failed to mark delete while trimming data ledgers: {}", (Object)ManagedLedgerImpl.this.name, (Object)exception.getMessage());
                    }
                }, null);
            }
        });
    }

    private PositionImpl calculateLastEntryInLedgerList(List<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersToDelete) {
        for (int i = ledgersToDelete.size() - 1; i >= 0; --i) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = ledgersToDelete.get(i);
            if (ledgerInfo == null || !ledgerInfo.hasEntries() || ledgerInfo.getEntries() <= 0L) continue;
            return PositionImpl.get(ledgerInfo.getLedgerId(), ledgerInfo.getEntries() - 1L);
        }
        return null;
    }

    @Override
    public void delete() throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        this.asyncDelete(new AsyncCallbacks.DeleteLedgerCallback(){

            @Override
            public void deleteLedgerComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void deleteLedgerFailed(ManagedLedgerException e, Object ctx) {
                exception.set(e);
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during managed ledger delete operation");
        }
        if (exception.get() != null) {
            log.error("[{}] Error deleting managed ledger", (Object)this.name, exception.get());
            throw (ManagedLedgerException)exception.get();
        }
    }

    @Override
    public void asyncDelete(final AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        this.setFenced();
        this.cancelScheduledTasks();
        ArrayList cursors = Lists.newArrayList((Iterable)this.cursors);
        if (cursors.isEmpty()) {
            this.deleteAllLedgers(callback, ctx);
            return;
        }
        final AtomicReference cursorDeleteException = new AtomicReference();
        final AtomicInteger cursorsToDelete = new AtomicInteger(cursors.size());
        for (final ManagedCursor cursor : cursors) {
            this.asyncDeleteCursor(cursor.getName(), new AsyncCallbacks.DeleteCursorCallback(){

                @Override
                public void deleteCursorComplete(Object ctx) {
                    if (cursorsToDelete.decrementAndGet() == 0) {
                        if (cursorDeleteException.get() != null) {
                            callback.deleteLedgerFailed((ManagedLedgerException)cursorDeleteException.get(), ctx);
                            return;
                        }
                        ManagedLedgerImpl.this.deleteAllLedgers(callback, ctx);
                    }
                }

                @Override
                public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                    if (exception instanceof ManagedLedgerException.CursorNotFoundException) {
                        this.deleteCursorComplete(ctx);
                        return;
                    }
                    log.warn("[{}] Failed to delete cursor {}: {}", new Object[]{ManagedLedgerImpl.this.name, cursor, exception.getMessage(), exception});
                    cursorDeleteException.compareAndSet(null, exception);
                    if (cursorsToDelete.decrementAndGet() == 0) {
                        callback.deleteLedgerFailed(exception, ctx);
                    }
                }
            }, null);
        }
    }

    private void asyncDeleteLedgerFromBookKeeper(long ledgerId) {
        this.asyncDeleteLedger(ledgerId, 3L);
    }

    private void asyncDeleteLedger(long ledgerId, MLDataFormats.ManagedLedgerInfo.LedgerInfo info) {
        if (!info.getOffloadContext().getBookkeeperDeleted()) {
            this.asyncDeleteLedger(ledgerId, 3L);
        }
        if (info.getOffloadContext().hasUidMsb()) {
            UUID uuid = new UUID(info.getOffloadContext().getUidMsb(), info.getOffloadContext().getUidLsb());
            this.cleanupOffloaded(ledgerId, uuid, OffloadUtils.getOffloadDriverName(info, this.config.getLedgerOffloader().getOffloadDriverName()), OffloadUtils.getOffloadDriverMetadata(info, this.config.getLedgerOffloader().getOffloadDriverMetadata()), "Trimming");
        }
    }

    private void asyncDeleteLedger(long ledgerId, long retry) {
        if (retry <= 0L) {
            log.warn("[{}] Failed to delete ledger after retries {}", (Object)this.name, (Object)ledgerId);
            return;
        }
        this.bookKeeper.asyncDeleteLedger(ledgerId, (rc, ctx) -> {
            if (Errors.isNoSuchLedgerExistsException(rc)) {
                log.warn("[{}] Ledger was already deleted {}", (Object)this.name, (Object)ledgerId);
            } else if (rc != 0) {
                log.error("[{}] Error deleting ledger {} : {}", new Object[]{this.name, ledgerId, org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                this.scheduledExecutor.schedule((SafeRunnable)SafeRun.safeRun(() -> this.asyncDeleteLedger(ledgerId, retry - 1L)), 60L, TimeUnit.SECONDS);
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] Deleted ledger {}", (Object)this.name, (Object)ledgerId);
            }
        }, null);
    }

    private void deleteAllLedgers(AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        ArrayList ledgers = Lists.newArrayList(this.ledgers.values());
        AtomicInteger ledgersToDelete = new AtomicInteger(ledgers.size());
        if (ledgers.isEmpty()) {
            this.deleteMetadata(callback, ctx);
            return;
        }
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : ledgers) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Deleting ledger {}", (Object)this.name, (Object)ls);
            }
            this.bookKeeper.asyncDeleteLedger(ls.getLedgerId(), (rc, ctx1) -> {
                switch (rc) {
                    case -25: 
                    case -7: {
                        log.warn("[{}] Ledger {} not found when deleting it", (Object)this.name, (Object)ls.getLedgerId());
                    }
                    case 0: {
                        if (ledgersToDelete.decrementAndGet() != 0) break;
                        this.deleteMetadata(callback, ctx);
                        break;
                    }
                    default: {
                        log.warn("[{}] Failed to delete ledger {} -- {}", new Object[]{this.name, ls.getLedgerId(), org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                        int toDelete = ledgersToDelete.get();
                        if (toDelete == -1 || !ledgersToDelete.compareAndSet(toDelete, -1)) break;
                        callback.deleteLedgerFailed(ManagedLedgerImpl.createManagedLedgerException(rc), ctx);
                    }
                }
            }, null);
        }
    }

    private void deleteMetadata(final AsyncCallbacks.DeleteLedgerCallback callback, final Object ctx) {
        this.store.removeManagedLedger(this.name, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                log.info("[{}] Successfully deleted managed ledger", (Object)ManagedLedgerImpl.this.name);
                ManagedLedgerImpl.this.factory.close(ManagedLedgerImpl.this);
                callback.deleteLedgerComplete(ctx);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Failed to delete managed ledger", (Object)ManagedLedgerImpl.this.name, (Object)e);
                ManagedLedgerImpl.this.factory.close(ManagedLedgerImpl.this);
                callback.deleteLedgerFailed(e, ctx);
            }
        });
    }

    @Override
    public Position offloadPrefix(Position pos) throws InterruptedException, ManagedLedgerException {
        final CompletableFuture promise = new CompletableFuture();
        this.asyncOffloadPrefix(pos, new AsyncCallbacks.OffloadCallback(){

            @Override
            public void offloadComplete(Position offloadedTo, Object ctx) {
                promise.complete(offloadedTo);
            }

            @Override
            public void offloadFailed(ManagedLedgerException e, Object ctx) {
                promise.completeExceptionally(e);
            }
        }, null);
        try {
            return (Position)promise.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            throw new ManagedLedgerException("Timeout during managed ledger offload operation");
        }
        catch (ExecutionException e) {
            log.error("[{}] Error offloading. pos = {}", new Object[]{this.name, pos, e.getCause()});
            throw ManagedLedgerException.getManagedLedgerException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncOffloadPrefix(Position pos, AsyncCallbacks.OffloadCallback callback, Object ctx) {
        PositionImpl firstUnoffloaded;
        if (this.config.getLedgerOffloader() != null && this.config.getLedgerOffloader() == NullLedgerOffloader.INSTANCE) {
            callback.offloadFailed(new ManagedLedgerException("NullLedgerOffloader"), ctx);
            return;
        }
        PositionImpl requestOffloadTo = (PositionImpl)pos;
        if (!(this.isValidPosition(requestOffloadTo) || requestOffloadTo.getLedgerId() == this.currentLedger.getId() && requestOffloadTo.getEntryId() == 0L)) {
            log.warn("[{}] Cannot start offload at position {} - LastConfirmedEntry: {}", new Object[]{this.name, pos, this.lastConfirmedEntry});
            callback.offloadFailed(new ManagedLedgerException.InvalidCursorPositionException("Invalid position for offload: " + pos), ctx);
            return;
        }
        ConcurrentLinkedQueue<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersToOffload = new ConcurrentLinkedQueue<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        ManagedLedgerImpl managedLedgerImpl = this;
        synchronized (managedLedgerImpl) {
            long current;
            log.info("[{}] Start ledgersOffload. ledgers={} totalSize={}", new Object[]{this.name, this.ledgers.keySet(), TOTAL_SIZE_UPDATER.get(this)});
            if (STATE_UPDATER.get(this) == State.Closed) {
                log.info("[{}] Ignoring offload request since the managed ledger was already closed", (Object)this.name);
                callback.offloadFailed(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Can't offload closed managed ledger (" + this.name + ")"), ctx);
                return;
            }
            if (this.ledgers.isEmpty()) {
                log.info("[{}] Tried to offload a managed ledger with no ledgers, giving up", (Object)this.name);
                callback.offloadFailed(new ManagedLedgerException.ManagedLedgerAlreadyClosedException("Can't offload managed ledger (" + this.name + ") with no ledgers"), ctx);
                return;
            }
            long firstLedgerRetained = current = ((Long)this.ledgers.lastKey()).longValue();
            for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : this.ledgers.headMap(current).values()) {
                if (requestOffloadTo.getLedgerId() > ls.getLedgerId()) {
                    if (ls.getOffloadContext().getComplete() || ls.getSize() <= 0L) continue;
                    ledgersToOffload.add(ls);
                    continue;
                }
                firstLedgerRetained = ls.getLedgerId();
                break;
            }
            firstUnoffloaded = PositionImpl.get(firstLedgerRetained, 0L);
        }
        if (ledgersToOffload.isEmpty()) {
            log.info("[{}] No ledgers to offload", (Object)this.name);
            callback.offloadComplete(firstUnoffloaded, ctx);
            return;
        }
        if (this.offloadMutex.tryLock()) {
            log.info("[{}] Going to offload ledgers {}", (Object)this.name, ledgersToOffload.stream().map(MLDataFormats.ManagedLedgerInfo.LedgerInfo::getLedgerId).collect(Collectors.toList()));
            CompletableFuture<PositionImpl> promise = new CompletableFuture<PositionImpl>();
            promise.whenComplete((result, exception) -> {
                this.offloadMutex.unlock();
                if (exception != null) {
                    callback.offloadFailed(ManagedLedgerException.getManagedLedgerException(exception), ctx);
                } else {
                    callback.offloadComplete((Position)result, ctx);
                }
            });
            this.offloadLoop(promise, ledgersToOffload, firstUnoffloaded, Optional.empty());
        } else {
            callback.offloadFailed(new ManagedLedgerException.OffloadInProgressException("Offload operation already running"), ctx);
        }
    }

    private void offloadLoop(CompletableFuture<PositionImpl> promise, Queue<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersToOffload, PositionImpl firstUnoffloaded, Optional<Throwable> firstError) {
        State currentState = this.getState();
        if (currentState == State.Closed) {
            promise.completeExceptionally(new ManagedLedgerException.ManagedLedgerAlreadyClosedException(String.format("managed ledger [%s] has already closed", this.name)));
            return;
        }
        if (currentState == State.Fenced) {
            promise.completeExceptionally(new ManagedLedgerException.ManagedLedgerFencedException(String.format("managed ledger [%s] is fenced", this.name)));
            return;
        }
        MLDataFormats.ManagedLedgerInfo.LedgerInfo info = ledgersToOffload.poll();
        if (info == null) {
            if (firstError.isPresent()) {
                promise.completeExceptionally(firstError.get());
            } else {
                promise.complete(firstUnoffloaded);
            }
        } else {
            long ledgerId = info.getLedgerId();
            UUID uuid = UUID.randomUUID();
            Map<String, String> extraMetadata = Map.of("ManagedLedgerName", this.name);
            String driverName = this.config.getLedgerOffloader().getOffloadDriverName();
            Map<String, String> driverMetadata = this.config.getLedgerOffloader().getOffloadDriverMetadata();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.prepareLedgerInfoForOffloaded(ledgerId, uuid, driverName, driverMetadata).thenCompose(ignore -> this.getLedgerHandle(ledgerId))).thenCompose(readHandle -> this.config.getLedgerOffloader().offload((ReadHandle)readHandle, uuid, extraMetadata))).thenCompose(ignore -> Retries.run(Backoff.exponentialJittered((long)TimeUnit.SECONDS.toMillis(1L), (long)TimeUnit.HOURS.toMillis(1L)).limit(10L), FAIL_ON_CONFLICT, () -> this.completeLedgerInfoForOffloaded(ledgerId, uuid), (OrderedScheduler)this.scheduledExecutor, (Object)this.name).whenComplete((ignore2, exception) -> {
                if (exception != null) {
                    Throwable e = FutureUtil.unwrapCompletionException((Throwable)exception);
                    if (e instanceof ManagedLedgerException.MetaStoreException) {
                        log.error("[{}] Failed to update offloaded metadata for the ledgerId {}, the offloaded data will not be cleaned up", new Object[]{this.name, ledgerId, exception});
                        return;
                    }
                    log.error("[{}] Failed to offload data for the ledgerId {}, clean up the offloaded data", new Object[]{this.name, ledgerId, exception});
                    this.cleanupOffloaded(ledgerId, uuid, driverName, driverMetadata, "Metastore failure");
                }
            }))).whenComplete((ignore, exception) -> {
                if (exception != null) {
                    this.lastOffloadFailureTimestamp = System.currentTimeMillis();
                    log.warn("[{}] Exception occurred for ledgerId {} timestamp {} during offload", new Object[]{this.name, ledgerId, this.lastOffloadFailureTimestamp, exception});
                    PositionImpl newFirstUnoffloaded = PositionImpl.get(ledgerId, 0L);
                    if (newFirstUnoffloaded.compareTo(firstUnoffloaded) > 0) {
                        newFirstUnoffloaded = firstUnoffloaded;
                    }
                    Optional<Throwable> errorToReport = firstError;
                    ManagedLedgerImpl managedLedgerImpl = this;
                    synchronized (managedLedgerImpl) {
                        if (this.ledgers.containsKey(ledgerId)) {
                            errorToReport = Optional.of(firstError.orElse((Throwable)exception));
                        }
                    }
                    this.offloadLoop(promise, ledgersToOffload, newFirstUnoffloaded, errorToReport);
                } else {
                    this.lastOffloadSuccessTimestamp = System.currentTimeMillis();
                    log.info("[{}] offload for ledgerId {} timestamp {} succeed", new Object[]{this.name, ledgerId, this.lastOffloadSuccessTimestamp});
                    this.lastOffloadLedgerId = ledgerId;
                    this.invalidateReadHandle(ledgerId);
                    this.offloadLoop(promise, ledgersToOffload, firstUnoffloaded, firstError);
                }
            });
        }
    }

    private CompletableFuture<Void> transformLedgerInfo(long ledgerId, LedgerInfoTransformation transformation) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.tryTransformLedgerInfo(ledgerId, transformation, promise);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryTransformLedgerInfo(final long ledgerId, LedgerInfoTransformation transformation, CompletableFuture<Void> finalPromise) {
        ManagedLedgerImpl managedLedgerImpl = this;
        synchronized (managedLedgerImpl) {
            if (!this.metadataMutex.tryLock()) {
                this.scheduledExecutor.schedule((SafeRunnable)SafeRun.safeRun(() -> this.tryTransformLedgerInfo(ledgerId, transformation, finalPromise)), 100L, TimeUnit.MILLISECONDS);
            } else {
                final CompletableFuture unlockingPromise = new CompletableFuture();
                unlockingPromise.whenComplete((res, ex) -> {
                    this.metadataMutex.unlock();
                    if (ex != null) {
                        finalPromise.completeExceptionally((Throwable)ex);
                    } else {
                        finalPromise.complete((Void)res);
                    }
                });
                MLDataFormats.ManagedLedgerInfo.LedgerInfo oldInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId);
                if (oldInfo == null) {
                    unlockingPromise.completeExceptionally(new OffloadConflict("Ledger " + ledgerId + " no longer exists in ManagedLedger, likely trimmed"));
                } else {
                    try {
                        final MLDataFormats.ManagedLedgerInfo.LedgerInfo newInfo = transformation.transform(oldInfo);
                        HashMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> newLedgers = new HashMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>(this.ledgers);
                        newLedgers.put(ledgerId, newInfo);
                        this.store.asyncUpdateLedgerIds(this.name, this.buildManagedLedgerInfo(newLedgers), this.ledgersStat, new MetaStore.MetaStoreCallback<Void>(){

                            @Override
                            public void operationComplete(Void result, Stat stat) {
                                ManagedLedgerImpl.this.ledgersStat = stat;
                                ManagedLedgerImpl.this.ledgers.put(ledgerId, newInfo);
                                unlockingPromise.complete(null);
                            }

                            @Override
                            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                                ManagedLedgerImpl.this.handleBadVersion(e);
                                unlockingPromise.completeExceptionally(e);
                            }
                        });
                    }
                    catch (ManagedLedgerException mle) {
                        unlockingPromise.completeExceptionally(mle);
                    }
                }
            }
        }
    }

    private CompletableFuture<Void> prepareLedgerInfoForOffloaded(long ledgerId, UUID uuid, String offloadDriverName, Map<String, String> offloadDriverMetadata) {
        log.info("[{}] Preparing metadata to offload ledger {} with uuid {}", new Object[]{this.name, ledgerId, uuid});
        return this.transformLedgerInfo(ledgerId, oldInfo -> {
            if (oldInfo.getOffloadContext().hasUidMsb()) {
                UUID oldUuid = new UUID(oldInfo.getOffloadContext().getUidMsb(), oldInfo.getOffloadContext().getUidLsb());
                log.info("[{}] Found previous offload attempt for ledger {}, uuid {}, cleaning up", new Object[]{this.name, ledgerId, uuid});
                this.cleanupOffloaded(ledgerId, oldUuid, OffloadUtils.getOffloadDriverName(oldInfo, this.config.getLedgerOffloader().getOffloadDriverName()), OffloadUtils.getOffloadDriverMetadata(oldInfo, this.config.getLedgerOffloader().getOffloadDriverMetadata()), "Previous failed offload");
            }
            MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder builder = oldInfo.toBuilder();
            builder.getOffloadContextBuilder().setUidMsb(uuid.getMostSignificantBits()).setUidLsb(uuid.getLeastSignificantBits());
            OffloadUtils.setOffloadDriverMetadata(builder, offloadDriverName, offloadDriverMetadata);
            return builder.build();
        }).whenComplete((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to prepare ledger {} for offload, uuid {}", new Object[]{this.name, ledgerId, uuid, exception});
            } else {
                log.info("[{}] Metadata prepared for offload of ledger {} with uuid {}", new Object[]{this.name, ledgerId, uuid});
            }
        });
    }

    private CompletableFuture<Void> completeLedgerInfoForOffloaded(long ledgerId, UUID uuid) {
        log.info("[{}] Completing metadata for offload of ledger {} with uuid {}", new Object[]{this.name, ledgerId, uuid});
        return this.transformLedgerInfo(ledgerId, oldInfo -> {
            UUID existingUuid = new UUID(oldInfo.getOffloadContext().getUidMsb(), oldInfo.getOffloadContext().getUidLsb());
            if (existingUuid.equals(uuid)) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder builder = oldInfo.toBuilder();
                builder.getOffloadContextBuilder().setTimestamp(this.clock.millis()).setComplete(true);
                String driverName = OffloadUtils.getOffloadDriverName(oldInfo, this.config.getLedgerOffloader().getOffloadDriverName());
                Map<String, String> driverMetadata = OffloadUtils.getOffloadDriverMetadata(oldInfo, this.config.getLedgerOffloader().getOffloadDriverMetadata());
                OffloadUtils.setOffloadDriverMetadata(builder, driverName, driverMetadata);
                return builder.build();
            }
            throw new OffloadConflict("Existing UUID(" + existingUuid + ") in metadata for offload of ledgerId " + ledgerId + " does not match the UUID(" + uuid + ") for the offload we are trying to complete");
        }).whenComplete((result, exception) -> {
            if (exception == null) {
                log.info("[{}] End Offload. ledger={}, uuid={}", new Object[]{this.name, ledgerId, uuid});
            } else {
                log.warn("[{}] Failed to complete offload of ledger {}, uuid {}", new Object[]{this.name, ledgerId, uuid, exception});
            }
        });
    }

    private void cleanupOffloaded(long ledgerId, UUID uuid, String offloadDriverName, Map<String, String> offloadDriverMetadata, String cleanupReason) {
        log.info("[{}] Cleanup offload for ledgerId {} uuid {} because of the reason {}.", new Object[]{this.name, ledgerId, uuid.toString(), cleanupReason});
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.putAll(offloadDriverMetadata);
        metadataMap.put("ManagedLedgerName", this.name);
        Retries.run(Backoff.exponentialJittered((long)TimeUnit.SECONDS.toMillis(1L), (long)TimeUnit.HOURS.toMillis(1L)).limit(10L), (Predicate)Retries.NonFatalPredicate, () -> this.config.getLedgerOffloader().deleteOffloaded(ledgerId, uuid, metadataMap), (OrderedScheduler)this.scheduledExecutor, (Object)this.name).whenComplete((ignored, exception) -> {
            if (exception != null) {
                log.warn("[{}] Error cleaning up offload for {}, (cleanup reason: {})", new Object[]{this.name, ledgerId, cleanupReason, exception});
            }
        });
    }

    long getNumberOfEntries(Range<PositionImpl> range) {
        boolean toIncluded;
        PositionImpl fromPosition = (PositionImpl)range.lowerEndpoint();
        boolean fromIncluded = range.lowerBoundType() == BoundType.CLOSED;
        PositionImpl toPosition = (PositionImpl)range.upperEndpoint();
        boolean bl = toIncluded = range.upperBoundType() == BoundType.CLOSED;
        if (fromPosition.getLedgerId() == toPosition.getLedgerId()) {
            long count = toPosition.getEntryId() - fromPosition.getEntryId() - 1L;
            count += fromIncluded ? 1L : 0L;
            return count += toIncluded ? 1L : 0L;
        }
        long count = 0L;
        count += toPosition.getEntryId();
        count += toIncluded ? 1L : 0L;
        MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(fromPosition.getLedgerId());
        if (li != null) {
            count += li.getEntries() - (fromPosition.getEntryId() + 1L);
            count += fromIncluded ? 1L : 0L;
        }
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : this.ledgers.subMap(fromPosition.getLedgerId(), false, toPosition.getLedgerId(), false).values()) {
            count += ls.getEntries();
        }
        return count;
    }

    public PositionImpl getPositionAfterN(PositionImpl startPosition, long n, PositionBound startRange) {
        PositionImpl positionToReturn;
        long currentEntryId;
        long currentLedgerId;
        long entriesToSkip = n;
        if (startRange == PositionBound.startIncluded) {
            currentLedgerId = startPosition.getLedgerId();
            currentEntryId = startPosition.getEntryId();
        } else {
            PositionImpl nextValidPosition = this.getNextValidPosition(startPosition);
            currentLedgerId = nextValidPosition.getLedgerId();
            currentEntryId = nextValidPosition.getEntryId();
        }
        boolean lastLedger = false;
        while (entriesToSkip >= 0L) {
            long unreadEntriesInCurrentLedger;
            long totalEntriesInCurrentLedger;
            if (this.currentLedger != null && currentLedgerId == this.currentLedger.getId()) {
                lastLedger = true;
                totalEntriesInCurrentLedger = this.currentLedgerEntries > 0L ? this.lastConfirmedEntry.getEntryId() + 1L : 0L;
            } else {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(currentLedgerId);
                totalEntriesInCurrentLedger = ledgerInfo != null ? ledgerInfo.getEntries() : 0L;
            }
            long l = unreadEntriesInCurrentLedger = totalEntriesInCurrentLedger > 0L ? totalEntriesInCurrentLedger - currentEntryId : 0L;
            if (unreadEntriesInCurrentLedger >= entriesToSkip) {
                currentEntryId += entriesToSkip;
                break;
            }
            entriesToSkip -= unreadEntriesInCurrentLedger;
            if (lastLedger) {
                currentEntryId = totalEntriesInCurrentLedger;
                break;
            }
            Long lid = this.ledgers.ceilingKey(currentLedgerId + 1L);
            currentLedgerId = lid != null ? lid : (Long)this.ledgers.lastKey();
            currentEntryId = 0L;
        }
        if ((positionToReturn = this.getPreviousPosition(PositionImpl.get(currentLedgerId, currentEntryId))).compareTo(this.lastConfirmedEntry) > 0) {
            positionToReturn = this.lastConfirmedEntry;
        }
        if (log.isDebugEnabled()) {
            log.debug("getPositionAfterN: Start position {}:{}, startIncluded: {}, Return position {}:{}", new Object[]{startPosition.getLedgerId(), startPosition.getEntryId(), startRange, positionToReturn.getLedgerId(), positionToReturn.getEntryId()});
        }
        return positionToReturn;
    }

    public PositionImpl getPreviousPosition(PositionImpl position) {
        if (position.getEntryId() > 0L) {
            return PositionImpl.get(position.getLedgerId(), position.getEntryId() - 1L);
        }
        NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> headMap = this.ledgers.headMap(position.getLedgerId(), false);
        Map.Entry<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> firstEntry = headMap.firstEntry();
        if (firstEntry == null) {
            return PositionImpl.get(position.getLedgerId(), -1L);
        }
        for (long ledgerId : headMap.descendingKeySet()) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)headMap.get(ledgerId);
            if (li == null || li.getEntries() <= 0L) continue;
            return PositionImpl.get(li.getLedgerId(), li.getEntries() - 1L);
        }
        return PositionImpl.get(firstEntry.getKey(), -1L);
    }

    public boolean isValidPosition(PositionImpl position) {
        PositionImpl lac = this.lastConfirmedEntry;
        if (log.isDebugEnabled()) {
            log.debug("IsValid position: {} -- last: {}", (Object)position, (Object)lac);
        }
        if (!this.ledgers.containsKey(position.getLedgerId())) {
            return false;
        }
        if (position.getEntryId() < 0L) {
            return false;
        }
        if (this.currentLedger != null && position.getLedgerId() == this.currentLedger.getId()) {
            return position.getLedgerId() == lac.getLedgerId() && position.getEntryId() <= lac.getEntryId() + 1L || position.getEntryId() == 0L;
        }
        if (position.getLedgerId() == lac.getLedgerId()) {
            return position.getEntryId() <= lac.getEntryId();
        }
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ls = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(position.getLedgerId());
        if (ls == null) {
            if (position.getLedgerId() < lac.getLedgerId()) {
                return false;
            }
            return position.getEntryId() == 0L;
        }
        return position.getEntryId() < ls.getEntries();
    }

    public boolean ledgerExists(long ledgerId) {
        return this.ledgers.get(ledgerId) != null;
    }

    public Long getNextValidLedger(long ledgerId) {
        return this.ledgers.ceilingKey(ledgerId + 1L);
    }

    public PositionImpl getNextValidPosition(PositionImpl position) {
        PositionImpl next;
        block2: {
            try {
                next = this.getNextValidPositionInternal(position);
            }
            catch (NullPointerException e) {
                next = this.lastConfirmedEntry.getNext();
                if (!log.isDebugEnabled()) break block2;
                log.debug("[{}] Can't find next valid position : {}, fall back to the next position of the last position : {}.", new Object[]{position, this.name, next, e});
            }
        }
        return next;
    }

    public PositionImpl getNextValidPositionInternal(PositionImpl position) {
        PositionImpl nextPosition = position.getNext();
        while (!this.isValidPosition(nextPosition)) {
            Long nextLedgerId = this.ledgers.ceilingKey(nextPosition.getLedgerId() + 1L);
            if (nextLedgerId == null) {
                throw new NullPointerException();
            }
            nextPosition = PositionImpl.get(nextLedgerId, 0L);
        }
        return nextPosition;
    }

    public PositionImpl getFirstPosition() {
        Long ledgerId = (Long)this.ledgers.firstKey();
        if (ledgerId == null) {
            return null;
        }
        if (ledgerId > this.lastConfirmedEntry.getLedgerId()) {
            Preconditions.checkState((((MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId)).getEntries() == 0L ? 1 : 0) != 0);
            ledgerId = this.lastConfirmedEntry.getLedgerId();
        }
        return new PositionImpl(ledgerId, -1L);
    }

    PositionImpl getLastPosition() {
        return this.lastConfirmedEntry;
    }

    @Override
    public ManagedCursor getSlowestConsumer() {
        return this.cursors.getSlowestReader();
    }

    PositionImpl getMarkDeletePositionOfSlowestConsumer() {
        ManagedCursor slowestCursor = this.getSlowestConsumer();
        return slowestCursor == null ? null : (PositionImpl)slowestCursor.getMarkDeletedPosition();
    }

    Pair<PositionImpl, Long> getLastPositionAndCounter() {
        long count;
        PositionImpl pos;
        do {
            pos = this.lastConfirmedEntry;
            count = ENTRIES_ADDED_COUNTER_UPDATER.get(this);
        } while (pos.compareTo(this.lastConfirmedEntry) != 0);
        return Pair.of((Object)pos, (Object)count);
    }

    Pair<PositionImpl, Long> getFirstPositionAndCounter() {
        long count;
        Pair<PositionImpl, Long> lastPositionAndCounter;
        PositionImpl pos;
        do {
            pos = this.getFirstPosition();
            lastPositionAndCounter = this.getLastPositionAndCounter();
            count = (Long)lastPositionAndCounter.getRight() - this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)pos, (Comparable)((PositionImpl)lastPositionAndCounter.getLeft())));
        } while (pos.compareTo(this.getFirstPosition()) != 0 || ((PositionImpl)lastPositionAndCounter.getLeft()).compareTo(this.getLastPosition()) != 0);
        return Pair.of((Object)pos, (Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateCursor(ManagedCursor cursor) {
        ManagedCursorContainer managedCursorContainer = this.activeCursors;
        synchronized (managedCursorContainer) {
            if (this.activeCursors.get(cursor.getName()) == null) {
                Position positionForOrdering;
                Position position = positionForOrdering = this.config.isCacheEvictionByMarkDeletedPosition() ? cursor.getMarkDeletedPosition() : cursor.getReadPosition();
                if (positionForOrdering == null) {
                    positionForOrdering = PositionImpl.EARLIEST;
                }
                this.activeCursors.add(cursor, positionForOrdering);
            }
        }
    }

    public void deactivateCursor(ManagedCursor cursor) {
        this.deactivateCursorByName(cursor.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateCursorByName(String cursorName) {
        ManagedCursorContainer managedCursorContainer = this.activeCursors;
        synchronized (managedCursorContainer) {
            if (this.activeCursors.removeCursor(cursorName)) {
                this.invalidateEntriesUpToSlowestReaderPosition();
            }
        }
    }

    @Override
    public void removeWaitingCursor(ManagedCursor cursor) {
        this.waitingCursors.remove(cursor);
    }

    public boolean isCursorActive(ManagedCursor cursor) {
        return this.activeCursors.get(cursor.getName()) != null;
    }

    private boolean currentLedgerIsFull() {
        boolean maxLedgerTimeReached;
        if (!this.factory.isMetadataServiceAvailable()) {
            return false;
        }
        boolean spaceQuotaReached = this.currentLedgerEntries >= (long)this.config.getMaxEntriesPerLedger() || this.currentLedgerSize >= (long)this.config.getMaxSizePerLedgerMb() * 0x100000L;
        long timeSinceLedgerCreationMs = this.clock.millis() - this.lastLedgerCreatedTimestamp;
        boolean bl = maxLedgerTimeReached = timeSinceLedgerCreationMs >= this.config.getMaximumRolloverTimeMs();
        if (spaceQuotaReached || maxLedgerTimeReached) {
            if (this.config.getMinimumRolloverTimeMs() > 0) {
                boolean switchLedger;
                boolean bl2 = switchLedger = timeSinceLedgerCreationMs > (long)this.config.getMinimumRolloverTimeMs();
                if (log.isDebugEnabled()) {
                    log.debug("Diff: {}, threshold: {} -- switch: {}", new Object[]{this.clock.millis() - this.lastLedgerCreatedTimestamp, this.config.getMinimumRolloverTimeMs(), switchLedger});
                }
                return switchLedger;
            }
            return true;
        }
        return false;
    }

    public List<MLDataFormats.ManagedLedgerInfo.LedgerInfo> getLedgersInfoAsList() {
        return Lists.newArrayList(this.ledgers.values());
    }

    public NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> getLedgersInfo() {
        return this.ledgers;
    }

    private MLDataFormats.ManagedLedgerInfo getManagedLedgerInfo() {
        return this.buildManagedLedgerInfo(this.ledgers);
    }

    private MLDataFormats.ManagedLedgerInfo getManagedLedgerInfo(MLDataFormats.ManagedLedgerInfo.LedgerInfo newLedger) {
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder().addAllLedgerInfo(this.ledgers.values()).addLedgerInfo(newLedger);
        return this.buildManagedLedgerInfo(mlInfo);
    }

    private MLDataFormats.ManagedLedgerInfo buildManagedLedgerInfo(Map<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers) {
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder().addAllLedgerInfo(ledgers.values());
        return this.buildManagedLedgerInfo(mlInfo);
    }

    private MLDataFormats.ManagedLedgerInfo buildManagedLedgerInfo(MLDataFormats.ManagedLedgerInfo.Builder mlInfo) {
        if (this.state == State.Terminated) {
            mlInfo.setTerminatedPosition(MLDataFormats.NestedPositionInfo.newBuilder().setLedgerId(this.lastConfirmedEntry.getLedgerId()).setEntryId(this.lastConfirmedEntry.getEntryId()));
        }
        if (this.managedLedgerInterceptor != null) {
            this.managedLedgerInterceptor.onUpdateManagedLedgerInfo(this.propertiesMap);
        }
        for (Map.Entry<String, String> property : this.propertiesMap.entrySet()) {
            mlInfo.addProperties(MLDataFormats.KeyValue.newBuilder().setKey(property.getKey()).setValue(property.getValue()));
        }
        return mlInfo.build();
    }

    private void checkFenced() throws ManagedLedgerException {
        if (STATE_UPDATER.get(this) == State.Fenced) {
            log.error("[{}] Attempted to use a fenced managed ledger", (Object)this.name);
            throw new ManagedLedgerException.ManagedLedgerFencedException();
        }
    }

    private void checkManagedLedgerIsOpen() throws ManagedLedgerException {
        if (STATE_UPDATER.get(this) == State.Closed) {
            throw new ManagedLedgerException("ManagedLedger " + this.name + " has already been closed");
        }
    }

    synchronized void setFenced() {
        log.info("{} Moving to Fenced state", (Object)this.name);
        STATE_UPDATER.set(this, State.Fenced);
    }

    MetaStore getStore() {
        return this.store;
    }

    @Override
    public ManagedLedgerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ManagedLedgerConfig config) {
        this.config = config;
        this.maximumRolloverTimeMs = ManagedLedgerImpl.getMaximumRolloverTimeMs(config);
        this.cursors.forEach(c -> c.setThrottleMarkDelete(config.getThrottleMarkDelete()));
    }

    private static long getMaximumRolloverTimeMs(ManagedLedgerConfig config) {
        return (long)((double)config.getMaximumRolloverTimeMs() * (1.0 + random.nextDouble() * 5.0 / 100.0));
    }

    public long getEntriesAddedCounter() {
        return ENTRIES_ADDED_COUNTER_UPDATER.get(this);
    }

    public long getCurrentLedgerEntries() {
        return this.currentLedgerEntries;
    }

    public long getCurrentLedgerSize() {
        return this.currentLedgerSize;
    }

    public long getLastLedgerCreatedTimestamp() {
        return this.lastLedgerCreatedTimestamp;
    }

    public long getLastLedgerCreationFailureTimestamp() {
        return this.lastLedgerCreationFailureTimestamp;
    }

    public int getWaitingCursorsCount() {
        return this.waitingCursors.size();
    }

    public int getPendingAddEntriesCount() {
        return this.pendingAddEntries.size();
    }

    @Override
    public Position getLastConfirmedEntry() {
        return this.lastConfirmedEntry;
    }

    public State getState() {
        return STATE_UPDATER.get(this);
    }

    public long getCacheSize() {
        return this.entryCache.getSize();
    }

    protected boolean isReadOnly() {
        return false;
    }

    private static boolean isBkErrorNotRecoverable(int rc) {
        switch (rc) {
            case -25: 
            case -13: 
            case -7: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLedgerNotExistException(int rc) {
        switch (rc) {
            case -25: 
            case -7: {
                return true;
            }
        }
        return false;
    }

    public static ManagedLedgerException createManagedLedgerException(int bkErrorCode) {
        if (bkErrorCode == -105) {
            return new ManagedLedgerException.TooManyRequestsException("Too many request error from bookies");
        }
        if (ManagedLedgerImpl.isBkErrorNotRecoverable(bkErrorCode)) {
            if (ManagedLedgerImpl.isLedgerNotExistException(bkErrorCode)) {
                return new ManagedLedgerException.LedgerNotExistException(org.apache.bookkeeper.client.BKException.getMessage((int)bkErrorCode));
            }
            return new ManagedLedgerException.NonRecoverableLedgerException(org.apache.bookkeeper.client.BKException.getMessage((int)bkErrorCode));
        }
        return new ManagedLedgerException(org.apache.bookkeeper.client.BKException.getMessage((int)bkErrorCode));
    }

    public static ManagedLedgerException createManagedLedgerException(Throwable t) {
        if (t instanceof BKException) {
            return ManagedLedgerImpl.createManagedLedgerException(((BKException)t).getCode());
        }
        if (t instanceof CompletionException && !(t.getCause() instanceof CompletionException)) {
            return ManagedLedgerImpl.createManagedLedgerException(t.getCause());
        }
        log.error("Unknown exception for ManagedLedgerException.", t);
        return new ManagedLedgerException("Other exception", t);
    }

    protected void asyncCreateLedger(BookKeeper bookKeeper, ManagedLedgerConfig config, BookKeeper.DigestType digestType, AsyncCallback.CreateCallback cb, Map<String, byte[]> metadata) {
        CompletableFuture ledgerFutureHook = new CompletableFuture();
        HashMap<String, byte[]> finalMetadata = new HashMap<String, byte[]>();
        finalMetadata.putAll(this.ledgerMetadata);
        finalMetadata.putAll(metadata);
        if (config.getBookKeeperEnsemblePlacementPolicyClassName() != null && config.getBookKeeperEnsemblePlacementPolicyProperties() != null) {
            try {
                finalMetadata.putAll(LedgerMetadataUtils.buildMetadataForPlacementPolicyConfig(config.getBookKeeperEnsemblePlacementPolicyClassName(), config.getBookKeeperEnsemblePlacementPolicyProperties()));
            }
            catch (EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException e) {
                log.error("[{}] Serialize the placement configuration failed", (Object)this.name, (Object)e);
                cb.createComplete(-999, null, ledgerFutureHook);
                return;
            }
        }
        this.createdLedgerCustomMetadata = finalMetadata;
        try {
            bookKeeper.asyncCreateLedger(config.getEnsembleSize(), config.getWriteQuorumSize(), config.getAckQuorumSize(), digestType, config.getPassword(), cb, ledgerFutureHook, finalMetadata);
        }
        catch (Throwable cause) {
            log.error("[{}] Encountered unexpected error when creating ledger", (Object)this.name, (Object)cause);
            ledgerFutureHook.completeExceptionally(cause);
            cb.createComplete(-999, null, ledgerFutureHook);
            return;
        }
        ScheduledFuture timeoutChecker = this.scheduledExecutor.schedule(() -> {
            if (!ledgerFutureHook.isDone() && ledgerFutureHook.completeExceptionally(new TimeoutException(this.name + " Create ledger timeout"))) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Timeout creating ledger", (Object)this.name);
                }
                cb.createComplete(-23, null, (Object)ledgerFutureHook);
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] Ledger already created when timeout task is triggered", (Object)this.name);
            }
        }, config.getMetadataOperationsTimeoutSeconds(), TimeUnit.SECONDS);
        ledgerFutureHook.whenComplete((ignore, ex) -> timeoutChecker.cancel(false));
    }

    public Clock getClock() {
        return this.clock;
    }

    protected boolean checkAndCompleteLedgerOpTask(int rc, LedgerHandle lh, Object ctx) {
        if (ctx instanceof CompletableFuture) {
            if (((CompletableFuture)ctx).complete(lh)) {
                return false;
            }
            if (rc == 0) {
                log.warn("[{}]-{} ledger creation timed-out, deleting ledger", (Object)this.name, (Object)lh.getId());
                this.asyncDeleteLedger(lh.getId(), 3L);
            }
            return true;
        }
        return false;
    }

    private void scheduleTimeoutTask() {
        if (this.config.getAddEntryTimeoutSeconds() > 0L || this.config.getReadEntryTimeoutSeconds() > 0L) {
            long timeoutSec = Math.min(this.config.getAddEntryTimeoutSeconds(), this.config.getReadEntryTimeoutSeconds());
            timeoutSec = timeoutSec <= 0L ? Math.max(this.config.getAddEntryTimeoutSeconds(), this.config.getReadEntryTimeoutSeconds()) : timeoutSec;
            this.timeoutTask = this.scheduledExecutor.scheduleAtFixedRate((SafeRunnable)SafeRun.safeRun(() -> this.checkTimeouts()), timeoutSec, timeoutSec, TimeUnit.SECONDS);
        }
    }

    private void checkTimeouts() {
        State state = STATE_UPDATER.get(this);
        if (state == State.Closed || state == State.Fenced) {
            return;
        }
        this.checkAddTimeout();
        this.checkReadTimeout();
    }

    private void checkAddTimeout() {
        long timeoutSec = this.config.getAddEntryTimeoutSeconds();
        if (timeoutSec < 1L) {
            return;
        }
        OpAddEntry opAddEntry = this.pendingAddEntries.peek();
        if (opAddEntry != null) {
            boolean isTimedOut;
            long finalAddOpCount = opAddEntry.addOpCount;
            boolean bl = isTimedOut = opAddEntry.lastInitTime != -1L && TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - opAddEntry.lastInitTime) >= timeoutSec;
            if (isTimedOut) {
                log.error("Failed to add entry for ledger {} in time-out {} sec", (Object)(opAddEntry.ledger != null ? opAddEntry.ledger.getId() : -1L), (Object)timeoutSec);
                opAddEntry.handleAddTimeoutFailure(opAddEntry.ledger, finalAddOpCount);
            }
        }
    }

    private void checkReadTimeout() {
        boolean timeout;
        long timeoutSec = this.config.getReadEntryTimeoutSeconds();
        if (timeoutSec < 1L) {
            return;
        }
        ReadEntryCallbackWrapper callback = this.lastReadCallback;
        long readOpCount = callback != null ? callback.readOpCount : 0L;
        boolean bl = timeout = callback != null && TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - callback.createdTime) >= timeoutSec;
        if (readOpCount > 0L && timeout) {
            log.warn("[{}]-{}-{} read entry timeout after {} sec", new Object[]{this.name, this.lastReadCallback.ledgerId, this.lastReadCallback.entryId, timeoutSec});
            callback.readFailed(ManagedLedgerImpl.createManagedLedgerException(-23), readOpCount);
            LAST_READ_CALLBACK_UPDATER.compareAndSet(this, callback, null);
        }
    }

    @Override
    public long getOffloadedSize() {
        long offloadedSize = 0L;
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo li : this.ledgers.values()) {
            if (!li.hasOffloadContext() || !li.getOffloadContext().getComplete()) continue;
            offloadedSize += li.getSize();
        }
        return offloadedSize;
    }

    @Override
    public long getLastOffloadedLedgerId() {
        return this.lastOffloadLedgerId;
    }

    @Override
    public long getLastOffloadedSuccessTimestamp() {
        return this.lastOffloadSuccessTimestamp;
    }

    @Override
    public long getLastOffloadedFailureTimestamp() {
        return this.lastOffloadFailureTimestamp;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.propertiesMap;
    }

    @Override
    public void setProperty(String key, String value) throws InterruptedException, ManagedLedgerException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.updateProperties(map, false, null);
    }

    @Override
    public void asyncSetProperty(String key, String value, AsyncCallbacks.UpdatePropertiesCallback callback, Object ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.asyncUpdateProperties(map, false, null, callback, ctx);
    }

    @Override
    public void deleteProperty(String key) throws InterruptedException, ManagedLedgerException {
        this.updateProperties(null, true, key);
    }

    @Override
    public void asyncDeleteProperty(String key, AsyncCallbacks.UpdatePropertiesCallback callback, Object ctx) {
        this.asyncUpdateProperties(null, true, key, callback, ctx);
    }

    @Override
    public void setProperties(Map<String, String> properties) throws InterruptedException, ManagedLedgerException {
        this.updateProperties(properties, false, null);
    }

    @Override
    public void asyncSetProperties(Map<String, String> properties, AsyncCallbacks.UpdatePropertiesCallback callback, Object ctx) {
        this.asyncUpdateProperties(properties, false, null, callback, ctx);
    }

    private void updateProperties(Map<String, String> properties, boolean isDelete, String deleteKey) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch latch = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncUpdateProperties(properties, isDelete, deleteKey, new AsyncCallbacks.UpdatePropertiesCallback(){
            {
            }

            @Override
            public void updatePropertiesComplete(Map<String, String> properties, Object ctx) {
                latch.countDown();
            }

            @Override
            public void updatePropertiesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                latch.countDown();
            }
        }, null);
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during update managedLedger's properties");
        }
        if (result.exception != null) {
            log.error("[{}] Update managedLedger's properties failed", (Object)this.name, (Object)result.exception);
            throw result.exception;
        }
    }

    private void asyncUpdateProperties(Map<String, String> properties, boolean isDelete, String deleteKey, final AsyncCallbacks.UpdatePropertiesCallback callback, final Object ctx) {
        if (!this.metadataMutex.tryLock()) {
            this.scheduledExecutor.schedule(() -> this.asyncUpdateProperties(properties, isDelete, deleteKey, callback, ctx), 100L, TimeUnit.MILLISECONDS);
            return;
        }
        if (isDelete) {
            this.propertiesMap.remove(deleteKey);
        } else {
            this.propertiesMap.putAll(properties);
        }
        this.store.asyncUpdateLedgerIds(this.name, this.getManagedLedgerInfo(), this.ledgersStat, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat version) {
                ManagedLedgerImpl.this.ledgersStat = version;
                callback.updatePropertiesComplete(ManagedLedgerImpl.this.propertiesMap, ctx);
                ManagedLedgerImpl.this.metadataMutex.unlock();
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.error("[{}] Update managedLedger's properties failed", (Object)ManagedLedgerImpl.this.name, (Object)e);
                ManagedLedgerImpl.this.handleBadVersion(e);
                callback.updatePropertiesFailed(e, ctx);
                ManagedLedgerImpl.this.metadataMutex.unlock();
            }
        });
    }

    @VisibleForTesting
    public void setEntriesAddedCounter(long count) {
        ENTRIES_ADDED_COUNTER_UPDATER.set(this, count);
    }

    @Override
    public CompletableFuture<Void> asyncTruncate() {
        ArrayList futures = new ArrayList();
        for (ManagedCursor cursor : this.cursors) {
            final CompletableFuture future = new CompletableFuture();
            cursor.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){

                @Override
                public void clearBacklogComplete(Object ctx) {
                    future.complete(null);
                }

                @Override
                public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                    future.completeExceptionally(exception);
                }
            }, null);
            futures.add(future);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(p -> this.internalTrimLedgers(true, future))).exceptionally(e -> {
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<ManagedLedgerInternalStats> getManagedLedgerInternalStats(boolean includeLedgerMetadata) {
        CompletableFuture<ManagedLedgerInternalStats> statFuture = new CompletableFuture<ManagedLedgerInternalStats>();
        ManagedLedgerInternalStats stats = new ManagedLedgerInternalStats();
        stats.entriesAddedCounter = this.getEntriesAddedCounter();
        stats.numberOfEntries = this.getNumberOfEntries();
        stats.totalSize = this.getTotalSize();
        stats.currentLedgerEntries = this.getCurrentLedgerEntries();
        stats.currentLedgerSize = this.getCurrentLedgerSize();
        stats.lastLedgerCreatedTimestamp = DateFormatter.format((long)this.getLastLedgerCreatedTimestamp());
        if (this.getLastLedgerCreationFailureTimestamp() != 0L) {
            stats.lastLedgerCreationFailureTimestamp = DateFormatter.format((long)this.getLastLedgerCreationFailureTimestamp());
        }
        stats.waitingCursorsCount = this.getWaitingCursorsCount();
        stats.pendingAddEntriesCount = this.getPendingAddEntriesCount();
        stats.lastConfirmedEntry = this.getLastConfirmedEntry().toString();
        stats.state = this.getState().toString();
        stats.cursors = new HashMap();
        this.getCursors().forEach(c -> {
            ManagedCursorImpl cursor = (ManagedCursorImpl)c;
            ManagedLedgerInternalStats.CursorStats cs = new ManagedLedgerInternalStats.CursorStats();
            cs.markDeletePosition = cursor.getMarkDeletedPosition().toString();
            cs.readPosition = cursor.getReadPosition().toString();
            cs.waitingReadOp = cursor.hasPendingReadRequest();
            cs.pendingReadOps = cursor.getPendingReadOpsCount();
            cs.messagesConsumedCounter = cursor.getMessagesConsumedCounter();
            cs.cursorLedger = cursor.getCursorLedger();
            cs.cursorLedgerLastEntry = cursor.getCursorLedgerLastEntry();
            cs.individuallyDeletedMessages = cursor.getIndividuallyDeletedMessages();
            cs.lastLedgerSwitchTimestamp = DateFormatter.format((long)cursor.getLastLedgerSwitchTimestamp());
            cs.state = cursor.getState();
            cs.numberOfEntriesSinceFirstNotAckedMessage = cursor.getNumberOfEntriesSinceFirstNotAckedMessage();
            cs.totalNonContiguousDeletedMessagesRange = cursor.getTotalNonContiguousDeletedMessagesRange();
            cs.properties = cursor.getProperties();
            stats.cursors.put(cursor.getName(), cs);
        });
        ArrayList ledgersInfos = new ArrayList(this.getLedgersInfo().values());
        HashMap ledgerMetadataFutures = new HashMap();
        if (includeLedgerMetadata) {
            ledgersInfos.forEach(li -> {
                long ledgerId = li.getLedgerId();
                ledgerMetadataFutures.put(ledgerId, this.getLedgerMetadata(ledgerId).exceptionally(throwable -> {
                    log.warn("Getting metadata for ledger {} failed.", (Object)ledgerId, throwable);
                    return null;
                }));
            });
        }
        FutureUtil.waitForAll(ledgerMetadataFutures.values()).thenAccept(__ -> {
            stats.ledgers = new ArrayList();
            ledgersInfos.forEach(li -> {
                ManagedLedgerInternalStats.LedgerInfo info = new ManagedLedgerInternalStats.LedgerInfo();
                info.ledgerId = li.getLedgerId();
                info.entries = li.getEntries();
                info.size = li.getSize();
                boolean bl = info.offloaded = li.hasOffloadContext() && li.getOffloadContext().getComplete();
                if (includeLedgerMetadata) {
                    info.metadata = ((CompletableFuture)ledgerMetadataFutures.get(li.getLedgerId())).getNow(null);
                }
                stats.ledgers.add(info);
            });
            statFuture.complete(stats);
        });
        return statFuture;
    }

    public CompletableFuture<Set<BookieId>> getEnsemblesAsync(long ledgerId) {
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.get(ledgerId);
        if (ledgerInfo != null && ledgerInfo.hasOffloadContext()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        LedgerHandle currentLedger = this.currentLedger;
        CompletableFuture<Object> ledgerHandleFuture = currentLedger != null && ledgerId == currentLedger.getId() ? CompletableFuture.completedFuture(currentLedger) : this.getLedgerHandle(ledgerId);
        return ledgerHandleFuture.thenCompose(lh -> {
            HashSet ensembles = new HashSet();
            lh.getLedgerMetadata().getAllEnsembles().values().forEach(ensembles::addAll);
            return CompletableFuture.completedFuture(ensembles);
        });
    }

    private void updateLastLedgerCreatedTimeAndScheduleRolloverTask() {
        this.lastLedgerCreatedTimestamp = this.clock.millis();
        if (this.config.getMaximumRolloverTimeMs() > 0L) {
            if (this.checkLedgerRollTask != null && !this.checkLedgerRollTask.isDone()) {
                this.checkLedgerRollTask.cancel(true);
            }
            this.checkLedgerRollTask = this.scheduledExecutor.schedule((SafeRunnable)SafeRun.safeRun(this::rollCurrentLedgerIfFull), this.maximumRolloverTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScheduledTasks() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
        }
        if (this.checkLedgerRollTask != null) {
            this.checkLedgerRollTask.cancel(false);
        }
    }

    @Override
    public void checkInactiveLedgerAndRollOver() {
        long currentTimeMs = System.currentTimeMillis();
        if (this.inactiveLedgerRollOverTimeMs > 0L && currentTimeMs > this.lastAddEntryTimeMs + this.inactiveLedgerRollOverTimeMs) {
            log.info("[{}] Closing inactive ledger, last-add entry {}", (Object)this.name, (Object)this.lastAddEntryTimeMs);
            if (STATE_UPDATER.compareAndSet(this, State.LedgerOpened, State.ClosingLedger)) {
                LedgerHandle currentLedger = this.currentLedger;
                currentLedger.asyncClose((rc, lh, o) -> {
                    Preconditions.checkArgument((currentLedger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)currentLedger.getId(), (long)lh.getId());
                    if (rc == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Successfully closed ledger {}, trigger by inactive ledger check", (Object)this.name, (Object)lh.getId());
                        }
                    } else {
                        log.warn("[{}] Error when closing ledger {}, trigger by inactive ledger check, Status={}", new Object[]{this.name, lh.getId(), org.apache.bookkeeper.client.BKException.getMessage((int)rc)});
                    }
                    this.ledgerClosed(lh);
                }, null);
            }
        }
    }

    @Override
    public void checkCursorsToCacheEntries() {
        if (this.minBacklogCursorsForCaching < 1) {
            return;
        }
        Iterator<ManagedCursor> it = this.cursors.iterator();
        HashMap<ManagedCursorImpl, Long> cursorBacklogMap = new HashMap<ManagedCursorImpl, Long>();
        while (it.hasNext()) {
            ManagedCursorImpl cursor = (ManagedCursorImpl)it.next();
            if (!cursor.isDurable()) continue;
            cursorBacklogMap.put(cursor, cursor.getNumberOfEntries());
        }
        int cursorsInSameBacklogRange = 0;
        for (Map.Entry cursor : cursorBacklogMap.entrySet()) {
            cursorsInSameBacklogRange = 0;
            for (Map.Entry other : cursorBacklogMap.entrySet()) {
                long backlog;
                if (cursor.equals(other) || (backlog = ((Long)cursor.getValue()).longValue()) < (long)this.minBacklogEntriesForCaching || Math.abs(backlog - (Long)other.getValue()) > (long)this.maxBacklogBetweenCursorsForCaching) continue;
                ++cursorsInSameBacklogRange;
            }
            ((ManagedCursorImpl)cursor.getKey()).setCacheReadEntry(cursorsInSameBacklogRange >= this.minBacklogCursorsForCaching);
            if (!log.isDebugEnabled()) continue;
            log.info("{} Enabling cache read = {} for {}", new Object[]{this.name, cursorsInSameBacklogRange >= this.minBacklogCursorsForCaching, ((ManagedCursorImpl)cursor.getKey()).getName()});
        }
    }

    public Position getTheSlowestNonDurationReadPosition() {
        PositionImpl theSlowestNonDurableReadPosition = PositionImpl.LATEST;
        for (ManagedCursor cursor : this.cursors) {
            PositionImpl readPosition;
            if (!(cursor instanceof NonDurableCursorImpl) || (readPosition = (PositionImpl)cursor.getReadPosition()).compareTo(theSlowestNonDurableReadPosition) >= 0) continue;
            theSlowestNonDurableReadPosition = readPosition;
        }
        return theSlowestNonDurableReadPosition;
    }

    public OrderedScheduler getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public OrderedExecutor getExecutor() {
        return this.executor;
    }

    public ManagedLedgerFactoryImpl getFactory() {
        return this.factory;
    }

    public ManagedLedgerMBeanImpl getMbean() {
        return this.mbean;
    }

    public static enum State {
        None,
        LedgerOpened,
        ClosingLedger,
        ClosedLedger,
        CreatingLedger,
        Closed,
        Fenced,
        Terminated,
        WriteFailed;

    }

    static final class ReadEntryCallbackWrapper
    implements AsyncCallbacks.ReadEntryCallback,
    AsyncCallbacks.ReadEntriesCallback {
        volatile AsyncCallbacks.ReadEntryCallback readEntryCallback;
        volatile AsyncCallbacks.ReadEntriesCallback readEntriesCallback;
        String name;
        long ledgerId;
        long entryId;
        volatile long readOpCount = -1L;
        private static final AtomicLongFieldUpdater<ReadEntryCallbackWrapper> READ_OP_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(ReadEntryCallbackWrapper.class, "readOpCount");
        volatile long createdTime = -1L;
        volatile Object cntx;
        final Recycler.Handle<ReadEntryCallbackWrapper> recyclerHandle;
        private static final Recycler<ReadEntryCallbackWrapper> RECYCLER = new Recycler<ReadEntryCallbackWrapper>(){

            protected ReadEntryCallbackWrapper newObject(Recycler.Handle<ReadEntryCallbackWrapper> handle) {
                return new ReadEntryCallbackWrapper(handle);
            }
        };

        private ReadEntryCallbackWrapper(Recycler.Handle<ReadEntryCallbackWrapper> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static ReadEntryCallbackWrapper create(String name, long ledgerId, long entryId, AsyncCallbacks.ReadEntryCallback callback, long readOpCount, long createdTime, Object ctx) {
            ReadEntryCallbackWrapper readCallback = (ReadEntryCallbackWrapper)RECYCLER.get();
            readCallback.name = name;
            readCallback.ledgerId = ledgerId;
            readCallback.entryId = entryId;
            readCallback.readEntryCallback = callback;
            readCallback.cntx = ctx;
            readCallback.readOpCount = readOpCount;
            readCallback.createdTime = createdTime;
            return readCallback;
        }

        static ReadEntryCallbackWrapper create(String name, long ledgerId, long entryId, AsyncCallbacks.ReadEntriesCallback callback, long readOpCount, long createdTime, Object ctx) {
            ReadEntryCallbackWrapper readCallback = (ReadEntryCallbackWrapper)RECYCLER.get();
            readCallback.name = name;
            readCallback.ledgerId = ledgerId;
            readCallback.entryId = entryId;
            readCallback.readEntriesCallback = callback;
            readCallback.cntx = ctx;
            readCallback.readOpCount = readOpCount;
            readCallback.createdTime = createdTime;
            return readCallback;
        }

        @Override
        public void readEntryComplete(Entry entry, Object ctx) {
            long reOpCount = this.reOpCount(ctx);
            AsyncCallbacks.ReadEntryCallback callback = this.readEntryCallback;
            Object cbCtx = this.cntx;
            if (this.recycle(reOpCount)) {
                callback.readEntryComplete(entry, cbCtx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] read entry already completed for {}-{}", new Object[]{this.name, this.ledgerId, this.entryId});
            }
            entry.release();
        }

        @Override
        public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
            long reOpCount = this.reOpCount(ctx);
            AsyncCallbacks.ReadEntryCallback callback = this.readEntryCallback;
            Object cbCtx = this.cntx;
            if (this.recycle(reOpCount)) {
                callback.readEntryFailed(exception, cbCtx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] read entry already completed for {}-{}", new Object[]{this.name, this.ledgerId, this.entryId});
            }
        }

        @Override
        public void readEntriesComplete(List<Entry> returnedEntries, Object ctx) {
            long reOpCount = this.reOpCount(ctx);
            AsyncCallbacks.ReadEntriesCallback callback = this.readEntriesCallback;
            Object cbCtx = this.cntx;
            if (this.recycle(reOpCount)) {
                callback.readEntriesComplete(returnedEntries, cbCtx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] read entry already completed for {}-{}", new Object[]{this.name, this.ledgerId, this.entryId});
            }
            returnedEntries.forEach(Entry::release);
        }

        @Override
        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            long reOpCount = this.reOpCount(ctx);
            AsyncCallbacks.ReadEntriesCallback callback = this.readEntriesCallback;
            Object cbCtx = this.cntx;
            if (this.recycle(reOpCount)) {
                callback.readEntriesFailed(exception, cbCtx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] read entry already completed for {}-{}", new Object[]{this.name, this.ledgerId, this.entryId});
            }
        }

        private long reOpCount(Object ctx) {
            return ctx instanceof Long ? (Long)ctx : -1L;
        }

        public void readFailed(ManagedLedgerException exception, Object ctx) {
            if (this.readEntryCallback != null) {
                this.readEntryFailed(exception, ctx);
            } else if (this.readEntriesCallback != null) {
                this.readEntriesFailed(exception, ctx);
            }
        }

        private boolean recycle(long readOpCount) {
            if (readOpCount != -1L && READ_OP_COUNT_UPDATER.compareAndSet(this, readOpCount, -1L)) {
                this.createdTime = -1L;
                this.readEntryCallback = null;
                this.readEntriesCallback = null;
                this.ledgerId = -1L;
                this.entryId = -1L;
                this.name = null;
                this.recyclerHandle.recycle((Object)this);
                return true;
            }
            return false;
        }
    }

    static interface ManagedLedgerInitializeLedgerCallback {
        public void initializeComplete();

        public void initializeFailed(ManagedLedgerException var1);
    }

    static interface LedgerInfoTransformation {
        public MLDataFormats.ManagedLedgerInfo.LedgerInfo transform(MLDataFormats.ManagedLedgerInfo.LedgerInfo var1) throws ManagedLedgerException;
    }

    static class OffloadConflict
    extends ManagedLedgerException {
        OffloadConflict(String msg) {
            super(msg);
        }
    }

    public static enum PositionBound {
        startIncluded,
        startExcluded;

    }
}

