/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.airlift.slice.Slice;
import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorResolvedIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SampleType;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorMetadata
implements ConnectorMetadata {
    private final ConnectorMetadata delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorMetadata(@ForClassLoaderSafe ConnectorMetadata delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getTableLayouts(session, table, constraint, desiredColumns);
            return list;
        }
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayout connectorTableLayout = this.delegate.getTableLayout(session, handle);
            return connectorTableLayout;
        }
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getCommonPartitioningHandle(session, left, right);
            return optional;
        }
    }

    public ConnectorTableLayoutHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayoutHandle connectorTableLayoutHandle = this.delegate.makeCompatiblePartitioning(session, tableLayoutHandle, partitioningHandle);
            return connectorTableLayoutHandle;
        }
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.makeCompatiblePartitioning(session, tableHandle, partitioningHandle);
            return connectorTableHandle;
        }
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getNewTableLayout(session, tableMetadata);
            return optional;
        }
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInsertLayout(session, tableHandle);
            return optional;
        }
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadataForWrite(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadata(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginStatisticsCollection(session, tableHandle);
            return connectorTableHandle;
        }
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
        }
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.schemaExists(session, schemaName);
            return bl;
        }
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listSchemaNames(session);
            return list;
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandle(session, tableName);
            return connectorTableHandle;
        }
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandleForStatisticsCollection(session, tableName, analyzeProperties);
            return connectorTableHandle;
        }
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getSystemTable(session, tableName);
            return optional;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata(session, table);
            return connectorTableMetadata;
        }
    }

    public Optional<Object> getInfo(ConnectorTableLayoutHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listTables(session, schemaName);
            return list;
        }
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getColumnHandles(session, tableHandle);
            return map;
        }
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.listTableColumns(session, prefix);
            return map;
        }
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatistics tableStatistics = this.delegate.getTableStatistics(session, tableHandle, constraint);
            return tableStatistics;
        }
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.addColumn(session, tableHandle, column);
        }
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, PrestoPrincipal owner) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createSchema(session, schemaName, properties, owner);
        }
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropSchema(session, schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameSchema(session, source, target);
        }
    }

    public void setSchemaAuthorization(ConnectorSession session, String source, PrestoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setSchemaAuthorization(session, source, principal);
        }
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createTable(session, tableMetadata, ignoreExisting);
        }
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropTable(session, tableHandle);
        }
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameColumn(session, tableHandle, source, target);
        }
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropColumn(session, tableHandle, column);
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameTable(session, tableHandle, newTableName);
        }
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setTableComment(session, tableHandle, comment);
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorOutputTableHandle connectorOutputTableHandle = this.delegate.beginCreateTable(session, tableMetadata, layout);
            return connectorOutputTableHandle;
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    public void beginQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.beginQuery(session);
        }
    }

    public void cleanupQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.cleanupQuery(session);
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle);
            return connectorInsertTableHandle;
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle, columns);
            return connectorInsertTableHandle;
        }
    }

    public boolean supportsMissingColumnsOnInsert() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.supportsMissingColumnsOnInsert();
            return bl;
        }
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.finishInsert(session, insertHandle, fragments, computedStatistics);
            return optional;
        }
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createView(session, viewName, definition, replace);
        }
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameView(session, source, target);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropView(session, viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listViews(session, schemaName);
            return list;
        }
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getViews(session, schemaName);
            return map;
        }
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getView(session, viewName);
            return optional;
        }
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getSchemaProperties(session, schemaName);
            return map;
        }
    }

    public Optional<PrestoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getSchemaOwner(session, schemaName);
            return optional;
        }
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getUpdateRowIdColumnHandle(session, tableHandle);
            return columnHandle;
        }
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginDelete(session, tableHandle);
            return connectorTableHandle;
        }
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishDelete(session, tableHandle, fragments);
        }
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.supportsMetadataDelete(session, tableHandle, tableLayoutHandle);
            return bl;
        }
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.metadataDelete(session, tableHandle, tableLayoutHandle);
            return optionalLong;
        }
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyDelete(session, handle);
            return optional;
        }
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.executeDelete(session, handle);
            return optionalLong;
        }
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return optional;
        }
    }

    public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createRole(session, role, grantor);
        }
    }

    public void dropRole(ConnectorSession session, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropRole(session, role);
        }
    }

    public Set<String> listRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listRoles(session);
            return set;
        }
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listRoleGrants(session, principal);
            return set;
        }
    }

    public void grantRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantRoles(connectorSession, roles, grantees, adminOption, grantor);
        }
    }

    public void revokeRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeRoles(connectorSession, roles, grantees, adminOption, grantor);
        }
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listApplicableRoles(session, principal);
            return set;
        }
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listEnabledRoles(session);
            return set;
        }
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listTablePrivileges(session, prefix);
            return list;
        }
    }

    public boolean usesLegacyTableLayouts() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.usesLegacyTableLayouts();
            return bl;
        }
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableProperties connectorTableProperties = this.delegate.getTableProperties(session, table);
            return connectorTableProperties;
        }
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyLimit(session, table, limit);
            return optional;
        }
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyFilter(session, table, constraint);
            return optional;
        }
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyProjection(session, table, projections, assignments);
            return optional;
        }
    }

    public Optional<ConnectorTableHandle> applySample(ConnectorSession session, ConnectorTableHandle table, SampleType sampleType, double sampleRatio) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applySample(session, table, sampleType, sampleRatio);
            return optional;
        }
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.validateScan(session, handle);
        }
    }
}

