/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;

public class SystemTopicNames {
    public static final String NAMESPACE_EVENTS_LOCAL_NAME = "__change_events";
    public static final String TRANSACTION_BUFFER_SNAPSHOT = "__transaction_buffer_snapshot";
    public static final String PENDING_ACK_STORE_SUFFIX = "__transaction_pending_ack";
    public static final String PENDING_ACK_STORE_CURSOR_NAME = "__pending_ack_state";
    public static final Set<String> EVENTS_TOPIC_NAMES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"__change_events", "__transaction_buffer_snapshot"}));
    public static final TopicName TRANSACTION_COORDINATOR_ASSIGN = TopicName.get(TopicDomain.persistent.value(), NamespaceName.SYSTEM_NAMESPACE, "transaction_coordinator_assign");
    public static final TopicName TRANSACTION_COORDINATOR_LOG = TopicName.get(TopicDomain.persistent.value(), NamespaceName.SYSTEM_NAMESPACE, "__transaction_log_");
    public static final TopicName RESOURCE_USAGE_TOPIC = TopicName.get(TopicDomain.non_persistent.value(), NamespaceName.SYSTEM_NAMESPACE, "resource-usage");

    public static boolean isEventSystemTopic(TopicName topicName) {
        return EVENTS_TOPIC_NAMES.contains(TopicName.get(topicName.getPartitionedTopicName()).getLocalName());
    }

    public static boolean isTransactionCoordinatorAssign(TopicName topicName) {
        return topicName != null && topicName.toString().startsWith(TRANSACTION_COORDINATOR_ASSIGN.toString());
    }

    public static boolean isTopicPoliciesSystemTopic(String topic) {
        if (topic == null) {
            return false;
        }
        return TopicName.getPartitionedTopicName(topic).getLocalName().equals(NAMESPACE_EVENTS_LOCAL_NAME);
    }

    public static boolean isTransactionInternalName(TopicName topicName) {
        String topic = topicName.toString();
        return topic.startsWith(TRANSACTION_COORDINATOR_ASSIGN.toString()) || topic.startsWith(TRANSACTION_COORDINATOR_LOG.toString()) || topic.endsWith(PENDING_ACK_STORE_SUFFIX);
    }

    public static boolean isSystemTopic(TopicName topicName) {
        TopicName nonPartitionedTopicName = TopicName.get(topicName.getPartitionedTopicName());
        return SystemTopicNames.isEventSystemTopic(nonPartitionedTopicName) || SystemTopicNames.isTransactionInternalName(nonPartitionedTopicName);
    }
}

