/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

public class ExecutionResult {
    static final ExecutionResult NONE = new ExecutionResult(null, null, true, 0L, true, true, true);
    private final Object result;
    private final Throwable failure;
    private final boolean nonResult;
    private final long waitNanos;
    private final boolean complete;
    private final boolean success;
    private final Boolean successAll;

    public ExecutionResult(Object result, Throwable failure) {
        this(result, failure, false, 0L, false, failure == null, null);
    }

    private ExecutionResult(Object result, Throwable failure, boolean nonResult, long waitNanos, boolean complete, boolean success, Boolean successAll) {
        this.nonResult = nonResult;
        this.result = result;
        this.failure = failure;
        this.waitNanos = waitNanos;
        this.complete = complete;
        this.success = success;
        this.successAll = successAll;
    }

    public static ExecutionResult success(Object result) {
        return new ExecutionResult(result, null);
    }

    public static ExecutionResult failure(Throwable failure) {
        return new ExecutionResult(null, failure, false, 0L, true, false, false);
    }

    public Object getResult() {
        return this.result;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public long getWaitNanos() {
        return this.waitNanos;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isNonResult() {
        return this.nonResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExecutionResult withResult(Object result) {
        return new ExecutionResult(result, null, this.nonResult, this.waitNanos, true, true, this.successAll);
    }

    public ExecutionResult withComplete() {
        return this.complete ? this : new ExecutionResult(this.result, this.failure, this.nonResult, this.waitNanos, true, this.success, this.successAll);
    }

    ExecutionResult with(boolean completed, boolean success) {
        return new ExecutionResult(this.result, this.failure, this.nonResult, this.waitNanos, completed, success, this.successAll == null ? success : success && this.successAll != false);
    }

    public ExecutionResult with(long waitNanos, boolean completed, boolean success) {
        return new ExecutionResult(this.result, this.failure, this.nonResult, waitNanos, completed, success, this.successAll == null ? success : success && this.successAll != false);
    }

    boolean getSuccessAll() {
        return this.successAll != null && this.successAll != false;
    }

    public String toString() {
        return "ExecutionResult[result=" + this.result + ", failure=" + this.failure + ", nonResult=" + this.nonResult + ", waitNanos=" + this.waitNanos + ", complete=" + this.complete + ", success=" + this.success + ", successAll=" + this.successAll + ']';
    }
}

