/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.exceptions.Code;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationClient;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationManager;

public abstract class AbstractMetadataDriver
implements Closeable {
    public static final String METADATA_STORE_SCHEME = "metadata-store";
    public static final String METADATA_STORE_INSTANCE = "metadata-store-instance";
    protected MetadataStoreExtended store;
    private boolean storeInstanceIsOwned;
    protected RegistrationClient registrationClient;
    protected RegistrationManager registrationManager;
    protected LedgerManagerFactory ledgerManagerFactory;
    protected LayoutManager layoutManager;
    protected AbstractConfiguration conf;
    protected String ledgersRootPath;

    protected void initialize(AbstractConfiguration conf) throws MetadataException {
        this.conf = conf;
        this.ledgersRootPath = this.resolveLedgersRootPath();
        this.createMetadataStore();
        this.registrationClient = new PulsarRegistrationClient(this.store, this.ledgersRootPath);
        this.createRegistrationManager();
        this.layoutManager = new PulsarLayoutManager(this.store, this.ledgersRootPath);
        this.ledgerManagerFactory = new PulsarLedgerManagerFactory();
        try {
            this.ledgerManagerFactory.initialize(conf, this.layoutManager, 1);
        }
        catch (IOException e) {
            throw new MetadataException(Code.METADATA_SERVICE_ERROR, (Throwable)e);
        }
    }

    public RegistrationManager createRegistrationManager() {
        if (this.registrationManager == null) {
            this.registrationManager = new PulsarRegistrationManager(this.store, this.ledgersRootPath, this.conf);
        }
        return this.registrationManager;
    }

    @Override
    public void close() {
        if (this.registrationClient != null) {
            this.registrationClient.close();
        }
        if (this.registrationManager != null) {
            this.registrationManager.close();
        }
        if (this.ledgerManagerFactory != null) {
            this.ledgerManagerFactory.close();
        }
        if (this.store != null && this.storeInstanceIsOwned) {
            this.store.close();
        }
    }

    void createMetadataStore() throws MetadataException {
        Object instance = this.conf.getProperty(METADATA_STORE_INSTANCE);
        if (instance != null) {
            this.store = (MetadataStoreExtended)instance;
            this.storeInstanceIsOwned = false;
        } else {
            String url;
            try {
                url = this.conf.getMetadataServiceUri().replaceFirst("metadata-store:", "").replace(";", ",");
            }
            catch (Exception e) {
                throw new MetadataException(Code.METADATA_SERVICE_ERROR, (Throwable)e);
            }
            try {
                this.store = MetadataStoreExtended.create(url, MetadataStoreConfig.builder().sessionTimeoutMillis(this.conf.getZkTimeout()).build());
                this.storeInstanceIsOwned = true;
            }
            catch (MetadataStoreException e) {
                throw new MetadataException(Code.METADATA_SERVICE_ERROR, (Throwable)e);
            }
        }
    }

    public String getScheme() {
        return METADATA_STORE_SCHEME;
    }

    private String resolveLedgersRootPath() {
        String metadataServiceUriStr = this.conf.getMetadataServiceUriUnchecked();
        if (metadataServiceUriStr == null) {
            return this.conf.getZkLedgersRootPath();
        }
        URI metadataServiceUri = URI.create(metadataServiceUriStr);
        String path = metadataServiceUri.getPath();
        return path == null ? "/ledgers" : path;
    }
}

