/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class DateTimeOperators {
    private static final DateTimeField MILLIS_OF_DAY = ISOChronology.getInstanceUTC().millisOfDay();
    private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

    private DateTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalDayToSecond(@SqlType(value="date") long date, @SqlType(value="interval day to second") long interval) {
        if (MILLIS_OF_DAY.get(interval) != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot add hour, minutes or seconds to a date");
        }
        return date + TimeUnit.MILLISECONDS.toDays(interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalDayToSecondPlusDate(@SqlType(value="interval day to second") long interval, @SqlType(value="date") long date) {
        return DateTimeOperators.datePlusIntervalDayToSecond(date, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long timePlusIntervalDayToSecond(ConnectorSession session, @SqlType(value="time") long time, @SqlType(value="interval day to second") long interval) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), time + interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long intervalDayToSecondPlusTime(ConnectorSession session, @SqlType(value="interval day to second") long interval, @SqlType(value="time") long time) {
        return DateTimeOperators.timePlusIntervalDayToSecond(session, time, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZonePlusIntervalDayToSecond(@SqlType(value="time with time zone") long time, @SqlType(value="interval day to second") long interval) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(time), DateTimeEncoding.unpackMillisUtc((long)time) + interval), (long)time);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long intervalDayToSecondPlusTimeWithTimeZone(@SqlType(value="interval day to second") long interval, @SqlType(value="time with time zone") long time) {
        return DateTimeOperators.timeWithTimeZonePlusIntervalDayToSecond(time, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long timestampPlusIntervalDayToSecond(@SqlType(value="timestamp") long timestamp, @SqlType(value="interval day to second") long interval) {
        return timestamp + interval;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long intervalDayToSecondPlusTimestamp(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp") long timestamp) {
        return DateTimeOperators.timestampPlusIntervalDayToSecond(timestamp, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZonePlusIntervalDayToSecond(@SqlType(value="timestamp with time zone") long timestamp, @SqlType(value="interval day to second") long interval) {
        return DateTimeEncoding.updateMillisUtc((long)(DateTimeEncoding.unpackMillisUtc((long)timestamp) + interval), (long)timestamp);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long intervalDayToSecondPlusTimestampWithTimeZone(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp with time zone") long timestamp) {
        return DateTimeOperators.timestampWithTimeZonePlusIntervalDayToSecond(timestamp, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalYearToMonth(@SqlType(value="date") long date, @SqlType(value="interval year to month") long interval) {
        long millis = MONTH_OF_YEAR_UTC.add(TimeUnit.DAYS.toMillis(date), interval);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalYearToMonthPlusDate(@SqlType(value="interval year to month") long interval, @SqlType(value="date") long date) {
        return DateTimeOperators.datePlusIntervalYearToMonth(date, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long timePlusIntervalYearToMonth(@SqlType(value="time") long time, @SqlType(value="interval year to month") long interval) {
        return time;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long intervalYearToMonthPlusTime(@SqlType(value="interval year to month") long interval, @SqlType(value="time") long time) {
        return time;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZonePlusIntervalYearToMonth(@SqlType(value="time with time zone") long time, @SqlType(value="interval year to month") long interval) {
        return time;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long intervalYearToMonthPlusTimeWithTimeZone(@SqlType(value="interval year to month") long interval, @SqlType(value="time with time zone") long time) {
        return time;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long timestampPlusIntervalYearToMonth(ConnectorSession session, @SqlType(value="timestamp") long timestamp, @SqlType(value="interval year to month") long interval) {
        if (session.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(timestamp, interval);
        }
        return MONTH_OF_YEAR_UTC.add(timestamp, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long intervalYearToMonthPlusTimestamp(ConnectorSession session, @SqlType(value="interval year to month") long interval, @SqlType(value="timestamp") long timestamp) {
        return DateTimeOperators.timestampPlusIntervalYearToMonth(session, timestamp, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZonePlusIntervalYearToMonth(@SqlType(value="timestamp with time zone") long timestamp, @SqlType(value="interval year to month") long interval) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeZoneIndex.unpackChronology(timestamp).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)timestamp), interval), (long)timestamp);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long intervalYearToMonthPlusTimestampWithTimeZone(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp with time zone") long timestamp) {
        return DateTimeOperators.timestampWithTimeZonePlusIntervalYearToMonth(timestamp, interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalDayToSecond(@SqlType(value="date") long date, @SqlType(value="interval day to second") long interval) {
        if (MILLIS_OF_DAY.get(interval) != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot subtract hour, minutes or seconds from a date");
        }
        return date - TimeUnit.MILLISECONDS.toDays(interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time")
    public static long timeMinusIntervalDayToSecond(ConnectorSession session, @SqlType(value="time") long time, @SqlType(value="interval day to second") long interval) {
        return DateTimeOperators.timePlusIntervalDayToSecond(session, time, -interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZoneMinusIntervalDayToSecond(@SqlType(value="time with time zone") long time, @SqlType(value="interval day to second") long interval) {
        return DateTimeOperators.timeWithTimeZonePlusIntervalDayToSecond(time, -interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp")
    public static long timestampMinusIntervalDayToSecond(@SqlType(value="timestamp") long timestamp, @SqlType(value="interval day to second") long interval) {
        return timestamp - interval;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZoneMinusIntervalDayToSecond(@SqlType(value="timestamp with time zone") long timestamp, @SqlType(value="interval day to second") long interval) {
        return DateTimeOperators.timestampWithTimeZonePlusIntervalDayToSecond(timestamp, -interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalYearToMonth(@SqlType(value="date") long date, @SqlType(value="interval year to month") long interval) {
        return DateTimeOperators.datePlusIntervalYearToMonth(date, -interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time")
    public static long timeMinusIntervalYearToMonth(@SqlType(value="time") long time, @SqlType(value="interval year to month") long interval) {
        return time;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZoneMinusIntervalYearToMonth(@SqlType(value="time with time zone") long time, @SqlType(value="interval year to month") long interval) {
        return time;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp")
    public static long timestampMinusIntervalYearToMonth(ConnectorSession session, @SqlType(value="timestamp") long timestamp, @SqlType(value="interval year to month") long interval) {
        return DateTimeOperators.timestampPlusIntervalYearToMonth(session, timestamp, -interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZoneMinusIntervalYearToMonth(@SqlType(value="timestamp with time zone") long timestamp, @SqlType(value="interval year to month") long interval) {
        return DateTimeOperators.timestampWithTimeZonePlusIntervalYearToMonth(timestamp, -interval);
    }

    public static int modulo24Hour(ISOChronology chronology, long millis) {
        return chronology.millisOfDay().get(millis) - chronology.getZone().getOffset(millis);
    }

    public static long modulo24Hour(long millis) {
        return MILLIS_OF_DAY.get(millis);
    }
}

