/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.transaction;

import com.google.common.base.Preconditions;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.Session;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionInfo;
import io.prestosql.transaction.TransactionManager;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class TransactionBuilder {
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private IsolationLevel isolationLevel = TransactionManager.DEFAULT_ISOLATION;
    private boolean readOnly = false;
    private boolean singleStatement;

    private TransactionBuilder(TransactionManager transactionManager, AccessControl accessControl) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public static TransactionBuilder transaction(TransactionManager transactionManager, AccessControl accessControl) {
        return new TransactionBuilder(transactionManager, accessControl);
    }

    public TransactionBuilder withIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = Objects.requireNonNull(isolationLevel, "isolationLevel is null");
        return this;
    }

    public TransactionBuilder readUncommitted() {
        return this.withIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
    }

    public TransactionBuilder readCommitted() {
        return this.withIsolationLevel(IsolationLevel.READ_COMMITTED);
    }

    public TransactionBuilder repeatableRead() {
        return this.withIsolationLevel(IsolationLevel.REPEATABLE_READ);
    }

    public TransactionBuilder serializable() {
        return this.withIsolationLevel(IsolationLevel.SERIALIZABLE);
    }

    public TransactionBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public TransactionBuilder singleStatement() {
        this.singleStatement = true;
        return this;
    }

    public void execute(Consumer<TransactionId> callback) {
        Objects.requireNonNull(callback, "callback is null");
        this.execute((TransactionId transactionId) -> {
            callback.accept((TransactionId)transactionId);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Function<TransactionId, T> callback) {
        Objects.requireNonNull(callback, "callback is null");
        TransactionId transactionId = this.transactionManager.beginTransaction(this.isolationLevel, this.readOnly, this.singleStatement);
        boolean success = false;
        try {
            T result = callback.apply(transactionId);
            success = true;
            T t = result;
            return t;
        }
        finally {
            if (success) {
                MoreFutures.getFutureValue(this.transactionManager.asyncCommit(transactionId));
            } else {
                this.transactionManager.asyncAbort(transactionId);
            }
        }
    }

    public void execute(Session session, Consumer<Session> callback) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(callback, "callback is null");
        this.execute(session, (Session transactionSession) -> {
            callback.accept((Session)transactionSession);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Session session, Function<Session, T> callback) {
        Session transactionSession;
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(callback, "callback is null");
        boolean managedTransaction = session.getTransactionId().isEmpty();
        if (managedTransaction) {
            TransactionId transactionId = this.transactionManager.beginTransaction(this.isolationLevel, this.readOnly, this.singleStatement);
            transactionSession = session.beginTransactionId(transactionId, this.transactionManager, this.accessControl);
        } else {
            TransactionInfo transactionInfo = this.transactionManager.getTransactionInfo(session.getTransactionId().get());
            Preconditions.checkState((boolean)transactionInfo.getIsolationLevel().meetsRequirementOf(this.isolationLevel), (String)"Cannot provide %s isolation with existing transaction isolation: %s", (Object)this.isolationLevel, (Object)transactionInfo.getIsolationLevel());
            Preconditions.checkState((!transactionInfo.isReadOnly() || this.readOnly ? 1 : 0) != 0, (Object)"Cannot provide read-write semantics with existing read-only transaction");
            Preconditions.checkState((!transactionInfo.isAutoCommitContext() && !this.singleStatement ? 1 : 0) != 0, (Object)"Cannot combine auto commit transactions");
            transactionSession = session;
        }
        boolean success = false;
        try {
            T result = callback.apply(transactionSession);
            success = true;
            T t = result;
            return t;
        }
        finally {
            if (managedTransaction && this.transactionManager.transactionExists(transactionSession.getTransactionId().get())) {
                if (success) {
                    MoreFutures.getFutureValue(this.transactionManager.asyncCommit(transactionSession.getTransactionId().get()));
                } else {
                    this.transactionManager.asyncAbort(transactionSession.getTransactionId().get());
                }
            }
        }
    }
}

