/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.ChildReplacer;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.UnionNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BeginTableWrite
implements PlanOptimizer {
    private final Metadata metadata;

    public BeginTableWrite(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(session), plan, new Context());
    }

    public static class Context {
        private Optional<TableWriterNode.WriterTarget> handle = Optional.empty();
        private Optional<TableWriterNode.WriterTarget> materializedHandle = Optional.empty();

        public void addMaterializedHandle(TableWriterNode.WriterTarget handle, TableWriterNode.WriterTarget materializedHandle) {
            Preconditions.checkState((boolean)this.handle.isEmpty(), (Object)"can only have one WriterTarget in a subtree");
            this.handle = Optional.of(handle);
            this.materializedHandle = Optional.of(materializedHandle);
        }

        public Optional<TableWriterNode.WriterTarget> getMaterializedHandle(TableWriterNode.WriterTarget handle) {
            Preconditions.checkState((boolean)this.handle.get().equals(handle), (Object)"can't find materialized handle for WriterTarget");
            return this.materializedHandle;
        }
    }

    private class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;

        public Rewriter(Session session) {
            this.session = session;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.WriterTarget writerTarget = context.get().getMaterializedHandle(node.getTarget()).get();
            return new TableWriterNode(node.getId(), node.getSource().accept(this, context), writerTarget, node.getRowCountSymbol(), node.getFragmentSymbol(), node.getColumns(), node.getColumnNames(), node.getPartitioningScheme(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            TableWriterNode.DeleteTarget deleteTarget = (TableWriterNode.DeleteTarget)context.get().getMaterializedHandle(node.getTarget()).get();
            return new DeleteNode(node.getId(), this.rewriteDeleteTableScan(node.getSource(), deleteTarget.getHandle()), deleteTarget, node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            PlanNode child = node.getSource();
            child = child.accept(this, context);
            StatisticsWriterNode.WriteStatisticsHandle analyzeHandle = new StatisticsWriterNode.WriteStatisticsHandle(BeginTableWrite.this.metadata.beginStatisticsCollection(this.session, ((StatisticsWriterNode.WriteStatisticsReference)node.getTarget()).getHandle()));
            return new StatisticsWriterNode(node.getId(), child, analyzeHandle, node.getRowCountSymbol(), node.isRowCountEnabled(), node.getDescriptor());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            PlanNode child = node.getSource();
            TableWriterNode.WriterTarget originalTarget = this.getTarget(child);
            TableWriterNode.WriterTarget newTarget = this.createWriterTarget(originalTarget);
            context.get().addMaterializedHandle(originalTarget, newTarget);
            child = child.accept(this, context);
            return new TableFinishNode(node.getId(), child, newTarget, node.getRowCountSymbol(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor());
        }

        public TableWriterNode.WriterTarget getTarget(PlanNode node) {
            if (node instanceof TableWriterNode) {
                return ((TableWriterNode)node).getTarget();
            }
            if (node instanceof DeleteNode) {
                return ((DeleteNode)node).getTarget();
            }
            if (node instanceof ExchangeNode || node instanceof UnionNode) {
                Set writerTargets = node.getSources().stream().map(this::getTarget).collect(Collectors.toSet());
                return (TableWriterNode.WriterTarget)Iterables.getOnlyElement(writerTargets);
            }
            throw new IllegalArgumentException("Invalid child for TableCommitNode: " + node.getClass().getSimpleName());
        }

        private TableWriterNode.WriterTarget createWriterTarget(TableWriterNode.WriterTarget target) {
            if (target instanceof TableWriterNode.CreateReference) {
                TableWriterNode.CreateReference create = (TableWriterNode.CreateReference)target;
                return new TableWriterNode.CreateTarget(BeginTableWrite.this.metadata.beginCreateTable(this.session, create.getCatalog(), create.getTableMetadata(), create.getLayout()), create.getTableMetadata().getTable());
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return new TableWriterNode.InsertTarget(BeginTableWrite.this.metadata.beginInsert(this.session, insert.getHandle(), insert.getColumns()), BeginTableWrite.this.metadata.getTableMetadata(this.session, insert.getHandle()).getTable());
            }
            if (target instanceof TableWriterNode.DeleteTarget) {
                TableWriterNode.DeleteTarget delete = (TableWriterNode.DeleteTarget)target;
                return new TableWriterNode.DeleteTarget(BeginTableWrite.this.metadata.beginDelete(this.session, delete.getHandle()), delete.getSchemaTableName());
            }
            throw new IllegalArgumentException("Unhandled target type: " + target.getClass().getSimpleName());
        }

        private PlanNode rewriteDeleteTableScan(PlanNode node, TableHandle handle) {
            JoinNode joinNode;
            if (node instanceof TableScanNode) {
                TableScanNode scan = (TableScanNode)node;
                return new TableScanNode(scan.getId(), handle, scan.getOutputSymbols(), scan.getAssignments(), scan.getEnforcedConstraint());
            }
            if (node instanceof FilterNode) {
                PlanNode source = this.rewriteDeleteTableScan(((FilterNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof ProjectNode) {
                PlanNode source = this.rewriteDeleteTableScan(((ProjectNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            if (node instanceof SemiJoinNode) {
                PlanNode source = this.rewriteDeleteTableScan(((SemiJoinNode)node).getSource(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)((SemiJoinNode)node).getFilteringSource()));
            }
            if (node instanceof JoinNode && (joinNode = (JoinNode)node).getType() == JoinNode.Type.INNER && QueryCardinalityUtil.isAtMostScalar(joinNode.getRight())) {
                PlanNode source = this.rewriteDeleteTableScan(joinNode.getLeft(), handle);
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source, (Object)joinNode.getRight()));
            }
            throw new IllegalArgumentException("Invalid descendant for DeleteNode: " + node.getClass().getName());
        }
    }
}

