/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.expression.Variable;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.util.MoreLists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class PruneTableScanColumns
extends ProjectOffPushDownRule<TableScanNode> {
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;

    public PruneTableScanColumns(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        super(Patterns.tableScan());
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TableScanNode node, Set<Symbol> referencedOutputs) {
        Session session = context.getSession();
        TypeProvider types = context.getSymbolAllocator().getTypes();
        return PruneTableScanColumns.pruneColumns(this.metadata, this.typeAnalyzer, types, session, node, referencedOutputs);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Optional<PlanNode> pruneColumns(Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, Session session, TableScanNode node, Set<Symbol> referencedOutputs) {
        Map newAssignments;
        List<Symbol> newOutputs = MoreLists.filteredCopy(node.getOutputSymbols(), referencedOutputs::contains);
        if (newOutputs.size() == node.getOutputSymbols().size()) {
            return Optional.empty();
        }
        List projections = (List)newOutputs.stream().map(symbol -> new Variable(symbol.getName(), types.get((Symbol)symbol))).collect(ImmutableList.toImmutableList());
        TableHandle handle = node.getTable();
        Optional<ProjectionApplicationResult<TableHandle>> result = metadata.applyProjection(session, handle, projections, (Map)newOutputs.stream().collect(ImmutableMap.toImmutableMap(Symbol::getName, node.getAssignments()::get)));
        if (result.isPresent()) {
            if (result.get().getProjections().stream().allMatch(Variable.class::isInstance)) {
                handle = (TableHandle)result.get().getHandle();
                Map assignments = (Map)result.get().getAssignments().stream().collect(ImmutableMap.toImmutableMap(ProjectionApplicationResult.Assignment::getVariable, ProjectionApplicationResult.Assignment::getColumn));
                ImmutableMap.Builder builder = ImmutableMap.builder();
                int i = 0;
                while (true) {
                    if (i >= newOutputs.size()) {
                        newAssignments = builder.build();
                        return Optional.of(new TableScanNode(node.getId(), handle, newOutputs, newAssignments, node.getEnforcedConstraint()));
                    }
                    Variable variable = (Variable)result.get().getProjections().get(i);
                    builder.put((Object)newOutputs.get(i), (Object)((ColumnHandle)assignments.get(variable.getName())));
                    ++i;
                }
            }
        }
        newAssignments = (Map)newOutputs.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), node.getAssignments()::get));
        return Optional.of(new TableScanNode(node.getId(), handle, newOutputs, newAssignments, node.getEnforcedConstraint()));
    }
}

