/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.analyzer.FieldId;
import io.prestosql.sql.analyzer.RelationId;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.SubscriptExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class GroupingOperationRewriter {
    private GroupingOperationRewriter() {
    }

    public static Expression rewriteGroupingOperation(GroupingOperation expression, List<Set<Integer>> groupingSets, Map<NodeRef<Expression>, FieldId> columnReferenceFields, Optional<Symbol> groupIdSymbol) {
        Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
        if (groupingSets.size() == 1) {
            return new LongLiteral("0");
        }
        Preconditions.checkState((boolean)groupIdSymbol.isPresent(), (Object)"groupId symbol is missing");
        RelationId relationId = columnReferenceFields.get(NodeRef.of((Node)((Expression)expression.getGroupingColumns().get(0)))).getRelationId();
        List columns = (List)expression.getGroupingColumns().stream().map(NodeRef::of).peek(groupingColumn -> Preconditions.checkState((boolean)columnReferenceFields.containsKey(groupingColumn), (Object)"the grouping column is not in the columnReferencesField map")).map(columnReferenceFields::get).map(fieldId -> GroupingOperationRewriter.translateFieldToInteger(fieldId, relationId)).collect(ImmutableList.toImmutableList());
        List groupingResults = (List)groupingSets.stream().map(groupingSet -> String.valueOf(GroupingOperationRewriter.calculateGrouping(groupingSet, columns))).map(LongLiteral::new).collect(ImmutableList.toImmutableList());
        return new SubscriptExpression((Expression)new ArrayConstructor(groupingResults), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)groupIdSymbol.get().toSymbolReference(), (Expression)new GenericLiteral("BIGINT", "1")));
    }

    private static int translateFieldToInteger(FieldId fieldId, RelationId requiredOriginRelationId) {
        Preconditions.checkState((boolean)fieldId.getRelationId().equals(requiredOriginRelationId), (Object)"grouping arguments must all come from the same relation");
        return fieldId.getFieldIndex();
    }

    static long calculateGrouping(Set<Integer> groupingSet, List<Integer> columns) {
        long grouping = (1L << columns.size()) - 1L;
        for (int index = 0; index < columns.size(); ++index) {
            int column = columns.get(index);
            if (!groupingSet.contains(column)) continue;
            grouping &= 1L << columns.size() - 1 - index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return grouping;
    }
}

