/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Defaults;
import com.google.common.base.Throwables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.connector.ConnectorSession;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InterpretedFunctionInvoker {
    private final Metadata metadata;

    public InterpretedFunctionInvoker(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, Object ... arguments) {
        return this.invoke(function, session, Arrays.asList(arguments));
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, List<Object> arguments) {
        ScalarFunctionImplementation implementation = this.metadata.getScalarFunctionImplementation(function);
        MethodHandle method = implementation.getMethodHandle();
        if ((method = InterpretedFunctionInvoker.bindInstanceFactory(method, implementation)).type().parameterCount() > 0 && method.type().parameterType(0) == ConnectorSession.class) {
            method = method.bindTo(session);
        }
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = implementation.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                if (implementation.getArgumentProperty(i).getNullConvention() == ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG) {
                    boolean isNull;
                    boolean bl = isNull = argument == null;
                    if (isNull) {
                        argument = Defaults.defaultValue((Class)method.type().parameterType(actualArguments.size()));
                    }
                    actualArguments.add(argument);
                    actualArguments.add(isNull);
                    continue;
                }
                actualArguments.add(argument);
                continue;
            }
            argument = MethodHandleProxies.asInterfaceInstance(argumentProperty.getLambdaInterface(), (MethodHandle)argument);
            actualArguments.add(argument);
        }
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static MethodHandle bindInstanceFactory(MethodHandle method, ScalarFunctionImplementation implementation) {
        if (implementation.getInstanceFactory().isEmpty()) {
            return method;
        }
        try {
            return method.bindTo(implementation.getInstanceFactory().get().invoke());
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

