/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Operator.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Operator.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression expression) {
        return ExpressionUtils.extractPredicates(expression.getOperator(), (Expression)expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression.Operator operator, Expression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ExpressionUtils.extractPredicates(operator, expression, (ImmutableList.Builder<Expression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractPredicates(LogicalBinaryExpression.Operator operator, Expression expression, ImmutableList.Builder<Expression> resultBuilder) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getOperator() == operator) {
            LogicalBinaryExpression logicalBinaryExpression = (LogicalBinaryExpression)expression;
            ExpressionUtils.extractPredicates(operator, logicalBinaryExpression.getLeft(), resultBuilder);
            ExpressionUtils.extractPredicates(operator, logicalBinaryExpression.getRight(), resultBuilder);
        } else {
            resultBuilder.add((Object)expression);
        }
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Operator.OR, expressions);
    }

    public static Expression binaryExpression(LogicalBinaryExpression.Operator operator, Collection<Expression> expressions) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (operator) {
                case AND: {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                case OR: {
                    return BooleanLiteral.FALSE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unsupported LogicalBinaryExpression operator");
        }
        ArrayDeque<Object> queue = new ArrayDeque<Expression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<Object> buffer = new ArrayDeque<Object>();
            while (queue.size() >= 2) {
                buffer.add(new LogicalBinaryExpression(operator, (Expression)queue.remove(), (Expression)queue.remove()));
            }
            if (!queue.isEmpty()) {
                buffer.add((Expression)queue.remove());
            }
            queue = buffer;
        }
        return (Expression)queue.remove();
    }

    public static Expression combinePredicates(Metadata metadata, LogicalBinaryExpression.Operator operator, Expression ... expressions) {
        return ExpressionUtils.combinePredicates(metadata, operator, Arrays.asList(expressions));
    }

    public static Expression combinePredicates(Metadata metadata, LogicalBinaryExpression.Operator operator, Collection<Expression> expressions) {
        if (operator == LogicalBinaryExpression.Operator.AND) {
            return ExpressionUtils.combineConjuncts(metadata, expressions);
        }
        return ExpressionUtils.combineDisjuncts(metadata, expressions);
    }

    public static Expression combineConjuncts(Metadata metadata, Expression ... expressions) {
        return ExpressionUtils.combineConjuncts(metadata, Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Metadata metadata, Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = ExpressionUtils.removeDuplicates(metadata, conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return ExpressionUtils.and(conjuncts);
    }

    public static Expression combineConjunctsWithDuplicates(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return ExpressionUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Metadata metadata, Expression ... expressions) {
        return ExpressionUtils.combineDisjuncts(metadata, Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Metadata metadata, Collection<Expression> expressions) {
        return ExpressionUtils.combineDisjunctsWithDefault(metadata, expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Metadata metadata, Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = ExpressionUtils.removeDuplicates(metadata, disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : ExpressionUtils.or(disjuncts);
    }

    public static Expression filterDeterministicConjuncts(Metadata metadata, Expression expression) {
        return ExpressionUtils.filterConjuncts(metadata, expression, expression1 -> DeterminismEvaluator.isDeterministic(expression1, metadata));
    }

    public static Expression filterNonDeterministicConjuncts(Metadata metadata, Expression expression) {
        return ExpressionUtils.filterConjuncts(metadata, expression, (Predicate<Expression>)Predicates.not(testExpression -> DeterminismEvaluator.isDeterministic(testExpression, metadata)));
    }

    public static Expression filterConjuncts(Metadata metadata, Expression expression, Predicate<Expression> predicate) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return ExpressionUtils.combineConjuncts(metadata, conjuncts);
    }

    public static boolean referencesAny(Expression expression, Collection<Symbol> variables) {
        Set<Symbol> references = SymbolsExtractor.extractUnique(expression);
        return variables.stream().anyMatch(references::contains);
    }

    public static Function<Expression, Expression> expressionOrNullSymbols(Predicate<Symbol> ... nullSymbolScopes) {
        return expression -> {
            ImmutableList.Builder resultDisjunct = ImmutableList.builder();
            resultDisjunct.add(expression);
            for (Predicate nullSymbolScope : nullSymbolScopes) {
                List symbols = (List)SymbolsExtractor.extractUnique(expression).stream().filter(nullSymbolScope).collect(ImmutableList.toImmutableList());
                if (Iterables.isEmpty((Iterable)symbols)) continue;
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate((Expression)symbol.toSymbolReference()));
                }
                resultDisjunct.add((Object)ExpressionUtils.and((Collection<Expression>)nullConjuncts.build()));
            }
            return ExpressionUtils.or((Collection<Expression>)resultDisjunct.build());
        };
    }

    private static List<Expression> removeDuplicates(Metadata metadata, List<Expression> expressions) {
        HashSet<Expression> seen = new HashSet<Expression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            if (!DeterminismEvaluator.isDeterministic(expression, metadata)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }

    public static Expression normalize(Expression expression) {
        if (expression instanceof NotExpression) {
            NotExpression not = (NotExpression)expression;
            if (not.getValue() instanceof ComparisonExpression && ((ComparisonExpression)not.getValue()).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression comparison = (ComparisonExpression)not.getValue();
                return new ComparisonExpression(comparison.getOperator().negate(), comparison.getLeft(), comparison.getRight());
            }
            if (not.getValue() instanceof NotExpression) {
                return ExpressionUtils.normalize(((NotExpression)not.getValue()).getValue());
            }
        }
        return expression;
    }

    public static Expression rewriteIdentifiersToSymbolReferences(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new LambdaExpression(node.getArguments(), treeRewriter.rewrite(node.getBody(), (Object)context));
            }
        }, (Expression)expression);
    }
}

