/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.prestosql.server.ui.ClusterResource;
import io.prestosql.server.ui.ClusterStatsResource;
import io.prestosql.server.ui.DisabledWebUiAuthenticationManager;
import io.prestosql.server.ui.UiQueryResource;
import io.prestosql.server.ui.WebUiAuthenticationManager;
import io.prestosql.server.ui.WebUiAuthenticationModule;
import io.prestosql.server.ui.WebUiConfig;

public class WebUiModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/ui", "webapp").withWelcomeFile("index.html");
        ConfigBinder.configBinder((Binder)binder).bindConfig(WebUiConfig.class);
        if (((WebUiConfig)this.buildConfigObject(WebUiConfig.class)).isEnabled()) {
            this.install((Module)new WebUiAuthenticationModule());
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterResource.class);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterStatsResource.class);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(UiQueryResource.class);
        } else {
            binder.bind(WebUiAuthenticationManager.class).to(DisabledWebUiAuthenticationManager.class).in(Scopes.SINGLETON);
        }
    }
}

