/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.protocol;

import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.jaxrs.AsyncResponseHandler;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.client.QueryResults;
import io.prestosql.execution.QueryManager;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.memory.context.SimpleLocalMemoryContext;
import io.prestosql.operator.ExchangeClient;
import io.prestosql.operator.ExchangeClientSupplier;
import io.prestosql.server.ForStatementResource;
import io.prestosql.server.protocol.Query;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/statement/executing")
public class ExecutingStatementResource {
    private static final Logger log = Logger.get(ExecutingStatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final DataSize DEFAULT_TARGET_RESULT_SIZE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_TARGET_RESULT_SIZE = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final QueryManager queryManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"execution-query-purger"));

    @Inject
    public ExecutingStatementResource(QueryManager queryManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                for (Map.Entry entry : this.queries.entrySet()) {
                    try {
                        queryManager.getQueryState((QueryId)entry.getKey());
                    }
                    catch (NoSuchElementException e) {
                        this.queries.remove(entry.getKey());
                    }
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @GET
    @Path(value="{queryId}/{slug}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token, @QueryParam(value="maxWait") Duration maxWait, @QueryParam(value="targetResultSize") DataSize targetResultSize, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Query query = this.getQuery(queryId, slug, token);
        this.asyncQueryResults(query, token, maxWait, targetResultSize, uriInfo, asyncResponse);
    }

    protected Query getQuery(QueryId queryId, String slug, long token) {
        Slug querySlug;
        Session session;
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug, token)) {
                throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
            }
            return query;
        }
        try {
            session = this.queryManager.getQuerySession(queryId);
            querySlug = this.queryManager.getQuerySlug(queryId);
            if (!querySlug.isValid(Slug.Context.EXECUTING_QUERY, slug, token)) {
                throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
            }
        }
        catch (NoSuchElementException e) {
            throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
        }
        query = this.queries.computeIfAbsent(queryId, id -> {
            ExchangeClient exchangeClient = this.exchangeClientSupplier.get((LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), ExecutingStatementResource.class.getSimpleName()));
            return Query.create(session, querySlug, this.queryManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde);
        });
        return query;
    }

    private void asyncQueryResults(Query query, long token, Duration maxWait, DataSize targetResultSize, UriInfo uriInfo, AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        targetResultSize = targetResultSize == null ? DEFAULT_TARGET_RESULT_SIZE : (DataSize)Ordering.natural().min((Object)targetResultSize, (Object)MAX_TARGET_RESULT_SIZE);
        ListenableFuture<QueryResults> queryResultsFuture = query.waitForResults(token, uriInfo, wait, targetResultSize);
        ListenableFuture response = Futures.transform(queryResultsFuture, queryResults -> ExecutingStatementResource.toResponse(query, queryResults), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)response, (Executor)this.responseExecutor);
    }

    private static Response toResponse(Query query, QueryResults queryResults) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetCatalog().ifPresent(catalog -> response.header("X-Presto-Set-Catalog", catalog));
        query.getSetSchema().ifPresent(schema -> response.header("X-Presto-Set-Schema", schema));
        query.getSetPath().ifPresent(path -> response.header("X-Presto-Set-Path", path));
        query.getSetSessionProperties().forEach((key, value) -> response.header("X-Presto-Set-Session", (Object)(key + "=" + ExecutingStatementResource.urlEncode(value))));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getSetRoles().forEach((key, value) -> response.header("X-Presto-Set-Role", (Object)(key + "=" + ExecutingStatementResource.urlEncode(value.toString()))));
        for (Map.Entry<String, String> entry : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = ExecutingStatementResource.urlEncode(entry.getKey());
            String encodedValue = ExecutingStatementResource.urlEncode(entry.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + "=" + encodedValue));
        }
        for (String name2 : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)ExecutingStatementResource.urlEncode(name2));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    @DELETE
    @Path(value="{queryId}/{slug}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token) {
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug, token)) {
                throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
            }
            query.cancel();
            return Response.noContent().build();
        }
        try {
            if (!this.queryManager.getQuerySlug(queryId).isValid(Slug.Context.EXECUTING_QUERY, slug, token)) {
                throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
            }
            this.queryManager.cancelQuery(queryId);
            return Response.noContent().build();
        }
        catch (NoSuchElementException e) {
            throw ExecutingStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
        }
    }

    @DELETE
    @Path(value="partialCancel/{queryId}/{stage}/{slug}/{token}")
    public void partialCancel(@PathParam(value="queryId") QueryId queryId, @PathParam(value="stage") int stage, @PathParam(value="slug") String slug, @PathParam(value="token") long token) {
        Query query = this.getQuery(queryId, slug, token);
        query.partialCancel(stage);
    }

    private static WebApplicationException badRequest(Response.Status status, String message) {
        throw new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

