/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.prestosql.spi.security.Identity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public final class ServletSecurityUtils {
    private ServletSecurityUtils() {
    }

    public static void sendErrorMessage(HttpServletResponse response, int errorCode, String errorMessage) throws IOException {
        response.setStatus(errorCode, errorMessage);
        response.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
        try (PrintWriter writer = response.getWriter();){
            writer.write(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withAuthenticatedIdentity(FilterChain nextFilter, HttpServletRequest request, HttpServletResponse response, Identity authenticatedIdentity) throws IOException, ServletException {
        request.setAttribute("presto.authenticated-identity", (Object)authenticatedIdentity);
        try {
            nextFilter.doFilter(ServletSecurityUtils.withPrincipal(request, authenticatedIdentity.getPrincipal()), (ServletResponse)response);
        }
        finally {
            Optional.ofNullable(request.getAttribute("presto.authenticated-identity")).map(Identity.class::cast).ifPresent(Identity::destroy);
        }
    }

    public static ServletRequest withPrincipal(HttpServletRequest request, final Optional<Principal> principal) {
        Objects.requireNonNull(principal, "principal is null");
        if (principal.isEmpty()) {
            return request;
        }
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return (Principal)principal.get();
            }
        };
    }

    public static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)ByteStreams.nullOutputStream());
        }
    }
}

