/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.SessionRepresentation;
import io.prestosql.security.AccessControl;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.security.Identity;
import java.util.List;
import java.util.Set;

public final class AccessControlUtil {
    private AccessControlUtil() {
    }

    public static void checkCanViewQueryOwnedBy(Identity identity, String queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner)) {
            return;
        }
        accessControl.checkCanViewQueryOwnedBy(identity, queryOwner);
    }

    public static List<BasicQueryInfo> filterQueries(Identity identity, List<BasicQueryInfo> queries, AccessControl accessControl) {
        String currentUser = identity.getUser();
        Set<String> owners = (Set<String>)queries.stream().map(BasicQueryInfo::getSession).map(SessionRepresentation::getUser).filter(owner -> !owner.equals(currentUser)).collect(ImmutableSet.toImmutableSet());
        owners = accessControl.filterQueriesOwnedBy(identity, owners);
        ImmutableSet allowedOwners = ImmutableSet.builder().add((Object)currentUser).addAll(owners).build();
        return (List)queries.stream().filter(arg_0 -> AccessControlUtil.lambda$filterQueries$1((Set)allowedOwners, arg_0)).collect(ImmutableList.toImmutableList());
    }

    public static void checkCanKillQueryOwnedBy(Identity identity, String queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner)) {
            return;
        }
        accessControl.checkCanKillQueryOwnedBy(identity, queryOwner);
    }

    private static /* synthetic */ boolean lambda$filterQueries$1(Set allowedOwners, BasicQueryInfo queryInfo) {
        return allowedOwners.contains(queryInfo.getSession().getUser());
    }
}

