/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Verify;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QualifiedTablePrefix {
    private final String catalogName;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;

    public QualifiedTablePrefix(String catalogName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(MetadataUtil.checkSchemaName(schemaName));
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName, String tableName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(MetadataUtil.checkSchemaName(schemaName));
        this.tableName = Optional.of(MetadataUtil.checkTableName(tableName));
    }

    @JsonCreator
    public QualifiedTablePrefix(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") Optional<String> schemaName, @JsonProperty(value="tableName") Optional<String> tableName) {
        MetadataUtil.checkTableName(catalogName, schemaName, tableName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public Optional<String> getTableName() {
        return this.tableName;
    }

    public boolean hasSchemaName() {
        return this.schemaName.isPresent();
    }

    public boolean hasTableName() {
        return this.tableName.isPresent();
    }

    public SchemaTablePrefix asSchemaTablePrefix() {
        if (this.schemaName.isEmpty()) {
            return new SchemaTablePrefix();
        }
        if (this.tableName.isEmpty()) {
            return new SchemaTablePrefix(this.schemaName.get());
        }
        return new SchemaTablePrefix(this.schemaName.get(), this.tableName.get());
    }

    public Optional<QualifiedObjectName> asQualifiedObjectName() {
        if (this.tableName.isPresent()) {
            Verify.verify((boolean)this.schemaName.isPresent());
            return Optional.of(new QualifiedObjectName(this.catalogName, this.schemaName.get(), this.tableName.get()));
        }
        return Optional.empty();
    }

    public boolean matches(QualifiedObjectName objectName) {
        return Objects.equals(this.catalogName, objectName.getCatalogName()) && this.schemaName.map(schema -> Objects.equals(schema, objectName.getSchemaName())).orElse(true) != false && this.tableName.map(table -> Objects.equals(table, objectName.getObjectName())).orElse(true) != false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedTablePrefix o = (QualifiedTablePrefix)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.tableName, o.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public String toString() {
        return this.catalogName + "." + this.schemaName.orElse("*") + "." + this.tableName.orElse("*");
    }
}

