/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FullConnectorSession
implements ConnectorSession {
    private final Session session;
    private final ConnectorIdentity identity;
    private final Map<String, String> properties;
    private final CatalogName catalogName;
    private final String catalog;
    private final SessionPropertyManager sessionPropertyManager;
    private final boolean isLegacyTimestamp;

    public FullConnectorSession(Session session, ConnectorIdentity identity) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = null;
        this.catalogName = null;
        this.catalog = null;
        this.sessionPropertyManager = null;
        this.isLegacyTimestamp = SystemSessionProperties.isLegacyTimestamp(session);
    }

    public FullConnectorSession(Session session, ConnectorIdentity identity, Map<String, String> properties, CatalogName catalogName, String catalog, SessionPropertyManager sessionPropertyManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.isLegacyTimestamp = SystemSessionProperties.isLegacyTimestamp(session);
    }

    public Session getSession() {
        return this.session;
    }

    public String getQueryId() {
        return this.session.getQueryId().toString();
    }

    public Optional<String> getSource() {
        return this.session.getSource();
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.session.getTimeZoneKey();
    }

    public Locale getLocale() {
        return this.session.getLocale();
    }

    public Instant getStart() {
        return this.session.getStart();
    }

    public Optional<String> getTraceToken() {
        return this.session.getTraceToken();
    }

    public boolean isLegacyTimestamp() {
        return this.isLegacyTimestamp;
    }

    public <T> T getProperty(String propertyName, Class<T> type) {
        if (this.properties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unknown session property: %s.%s", this.catalog, propertyName));
        }
        return this.sessionPropertyManager.decodeCatalogPropertyValue(this.catalogName, this.catalog, propertyName, this.properties.get(propertyName), type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("user", (Object)this.getUser()).add("source", this.getSource().orElse(null)).add("traceToken", this.getTraceToken().orElse(null)).add("timeZoneKey", (Object)this.getTimeZoneKey()).add("locale", (Object)this.getLocale()).add("start", (Object)this.getStart()).add("properties", this.properties).omitNullValues().toString();
    }
}

