/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import io.airlift.units.Duration;
import io.prestosql.cli.ClientOptions;
import io.prestosql.cli.Completion;
import io.prestosql.cli.Help;
import io.prestosql.cli.InputReader;
import io.prestosql.cli.Query;
import io.prestosql.cli.QueryPreprocessor;
import io.prestosql.cli.QueryPreprocessorException;
import io.prestosql.cli.QueryRunner;
import io.prestosql.cli.TableNameCompleter;
import io.prestosql.cli.ThreadInterruptor;
import io.prestosql.cli.VersionOption;
import io.prestosql.client.ClientSelectedRole;
import io.prestosql.client.ClientSession;
import io.prestosql.sql.parser.StatementSplitter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

@Command(name="presto", description="Presto command line interface")
public class Console {
    public static final Set<String> STATEMENT_DELIMITERS = ImmutableSet.of((Object)";", (Object)"\\G");
    private static final String PROMPT_NAME = "presto";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    @Inject
    public HelpOption helpOption;
    @Inject
    public VersionOption versionOption = new VersionOption();
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    public boolean run() {
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = this.clientOptions.execute != null;
        boolean isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        Console.initializeLogging(this.clientOptions.logLevelsFile);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.asCharSource((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8).read();
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        ThreadInterruptor interruptor = new ThreadInterruptor();
        CountDownLatch exited = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            interruptor.interrupt();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)exited, (long)EXIT_DELAY.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        }));
        try {
            QueryRunner queryRunner;
            block15: {
                queryRunner = new QueryRunner(session, this.clientOptions.debug, Optional.ofNullable(this.clientOptions.socksProxy), Optional.ofNullable(this.clientOptions.httpProxy), Optional.ofNullable(this.clientOptions.keystorePath), Optional.ofNullable(this.clientOptions.keystorePassword), Optional.ofNullable(this.clientOptions.truststorePath), Optional.ofNullable(this.clientOptions.truststorePassword), this.clientOptions.insecure, Optional.ofNullable(this.clientOptions.accessToken), Optional.ofNullable(this.clientOptions.user), this.clientOptions.password ? Optional.of(this.getPassword()) : Optional.empty(), Optional.ofNullable(this.clientOptions.krb5Principal), Optional.ofNullable(this.clientOptions.krb5ServicePrincipalPattern), Optional.ofNullable(this.clientOptions.krb5RemoteServiceName), Optional.ofNullable(this.clientOptions.krb5ConfigPath), Optional.ofNullable(this.clientOptions.krb5KeytabPath), Optional.ofNullable(this.clientOptions.krb5CredentialCachePath), !this.clientOptions.krb5DisableRemoteServiceHostnameCanonicalization);
                try {
                    if (!hasQuery) break block15;
                    boolean bl = Console.executeCommand(queryRunner, exiting, query, this.clientOptions.outputFormat, this.clientOptions.ignoreErrors, this.clientOptions.progress);
                    queryRunner.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        queryRunner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Console.runConsole(queryRunner, exiting);
            boolean bl = true;
            queryRunner.close();
            return bl;
        }
        finally {
            exited.countDown();
            interruptor.close();
        }
    }

    private String getPassword() {
        String string;
        block12: {
            Preconditions.checkState((this.clientOptions.user != null ? 1 : 0) != 0, (Object)"Username must be specified along with password");
            String defaultPassword = System.getenv("PRESTO_PASSWORD");
            if (defaultPassword != null) {
                return defaultPassword;
            }
            java.io.Console console = System.console();
            if (console != null) {
                char[] password = console.readPassword("Password: ", new Object[0]);
                if (password != null) {
                    return new String(password);
                }
                return "";
            }
            Terminal terminal = TerminalBuilder.terminal();
            try {
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
                string = reader.readLine("Password: ", Character.valueOf('\u0000'));
                if (terminal == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (terminal != null) {
                        try {
                            terminal.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EndOfFileException e) {
                    return "";
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read password from terminal", e);
                }
            }
            terminal.close();
        }
        return string;
    }

    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting) {
        try {
            TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
            try (InputReader reader = new InputReader(Console.getHistoryFile(), Completion.commandCompleter(), tableNameCompleter);){
                tableNameCompleter.populateCache();
                String remaining = "";
                block30: while (!exiting.get()) {
                    String line;
                    String prompt = PROMPT_NAME;
                    String schema = queryRunner.getSession().getSchema();
                    if (schema != null) {
                        prompt = prompt + ":" + schema.replace("%", "%%");
                    }
                    String commandPrompt = prompt + "> ";
                    try {
                        line = reader.readLine(commandPrompt, remaining);
                    }
                    catch (UserInterruptException e) {
                        if (!e.getPartialLine().isEmpty()) {
                            reader.getHistory().add(e.getPartialLine());
                        }
                        remaining = "";
                        continue;
                    }
                    catch (EndOfFileException e) {
                        System.out.println();
                        reader.close();
                        tableNameCompleter.close();
                        return;
                    }
                    String command = CharMatcher.is((char)';').or(CharMatcher.whitespace()).trimTrailingFrom((CharSequence)line);
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "history": {
                            for (History.Entry entry : reader.getHistory()) {
                                System.out.println(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(6)).append((CharSequence)String.format("%5d", entry.index() + 1)).style(AttributedStyle.DEFAULT).append((CharSequence)"  ").append((CharSequence)entry.line()).toAnsi(reader.getTerminal()));
                            }
                            continue block30;
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block30;
                        }
                    }
                    StatementSplitter splitter = new StatementSplitter(line, STATEMENT_DELIMITERS);
                    for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                        ClientOptions.OutputFormat outputFormat = ClientOptions.OutputFormat.ALIGNED;
                        if (split.terminator().equals("\\G")) {
                            outputFormat = ClientOptions.OutputFormat.VERTICAL;
                        }
                        Console.process(queryRunner, split.statement(), outputFormat, tableNameCompleter::populateCache, true, true, reader.getTerminal(), System.out, System.out);
                    }
                    remaining = CharMatcher.whitespace().trimTrailingFrom((CharSequence)splitter.getPartialStatement());
                }
            }
            finally {
                try {
                    tableNameCompleter.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean executeCommand(QueryRunner queryRunner, AtomicBoolean exiting, String query, ClientOptions.OutputFormat outputFormat, boolean ignoreErrors, boolean showProgress) {
        boolean success = true;
        StatementSplitter splitter = new StatementSplitter(query);
        Iterator iterator = splitter.getCompleteStatements().iterator();
        do {
            if (!iterator.hasNext()) {
                if (StatementSplitter.isEmptyStatement((String)splitter.getPartialStatement())) return success;
                System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
                return false;
            }
            StatementSplitter.Statement split = (StatementSplitter.Statement)iterator.next();
            if (StatementSplitter.isEmptyStatement((String)split.statement())) continue;
            try (Terminal terminal = TerminalBuilder.terminal();){
                if (Console.process(queryRunner, split.statement(), outputFormat, () -> {}, false, showProgress, terminal, System.out, System.err)) continue;
                if (!ignoreErrors) {
                    boolean bl = false;
                    return bl;
                }
                success = false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } while (!exiting.get());
        return success;
    }

    private static boolean process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, boolean usePager, boolean showProgress, Terminal terminal, PrintStream out, PrintStream errorChannel) {
        String finalSql;
        try {
            finalSql = QueryPreprocessor.preprocessQuery(terminal, Optional.ofNullable(queryRunner.getSession().getCatalog()), Optional.ofNullable(queryRunner.getSession().getSchema()), sql);
        }
        catch (QueryPreprocessorException e) {
            System.err.println(e.getMessage());
            if (queryRunner.isDebug()) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        Query query = queryRunner.startQuery(finalSql);
        try {
            boolean success = query.renderOutput(terminal, out, errorChannel, outputFormat, usePager, showProgress);
            ClientSession session = queryRunner.getSession();
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                session = ClientSession.builder((ClientSession)session).withCatalog(query.getSetCatalog().orElse(session.getCatalog())).withSchema(query.getSetSchema().orElse(session.getSchema())).build();
            }
            if (query.isClearTransactionId()) {
                session = ClientSession.stripTransactionId((ClientSession)session);
            }
            ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
            if (query.getStartedTransactionId() != null) {
                builder = builder.withTransactionId(query.getStartedTransactionId());
            }
            if (query.getSetPath().isPresent()) {
                builder = builder.withPath(query.getSetPath().get());
            }
            if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                sessionProperties.putAll(query.getSetSessionProperties());
                sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                builder = builder.withProperties(sessionProperties);
            }
            if (!query.getSetRoles().isEmpty()) {
                HashMap<String, ClientSelectedRole> roles = new HashMap<String, ClientSelectedRole>(session.getRoles());
                roles.putAll(query.getSetRoles());
                builder = builder.withRoles(roles);
            }
            if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                preparedStatements.putAll(query.getAddedPreparedStatements());
                preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                builder = builder.withPreparedStatements(preparedStatements);
            }
            session = builder.build();
            queryRunner.setSession(session);
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                schemaChanged.run();
            }
            boolean bl = success;
            if (query != null) {
                query.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (query != null) {
                    try {
                        query.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                System.err.println("Error running command: " + e.getMessage());
                if (queryRunner.isDebug()) {
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }
    }

    private static Path getHistoryFile() {
        String path = System.getenv("PRESTO_HISTORY_FILE");
        if (!Strings.isNullOrEmpty((String)path)) {
            return Paths.get(path, new String[0]);
        }
        return Paths.get(Strings.nullToEmpty((String)StandardSystemProperty.USER_HOME.value()), ".presto_history");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeLogging(String logLevelsFile) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            LoggingConfiguration config = new LoggingConfiguration();
            if (logLevelsFile == null) {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                config.setConsoleEnabled(false);
            } else {
                config.setLevelsFile(logLevelsFile);
            }
            Logging logging = Logging.initialize();
            logging.configure(config);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }
}

