/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Packages;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageName;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;

public class PackagesImpl
extends ComponentResource
implements Packages {
    private final WebTarget packages;
    private final AsyncHttpClient httpClient;

    public PackagesImpl(WebTarget webTarget, Authentication auth, AsyncHttpClient client, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.httpClient = client;
        this.packages = webTarget.path("/admin/v3/packages");
    }

    public PackageMetadata getMetadata(String packageName) throws PulsarAdminException {
        return (PackageMetadata)this.sync(() -> this.getMetadataAsync(packageName));
    }

    public CompletableFuture<PackageMetadata> getMetadataAsync(String packageName) {
        WebTarget path = this.packages.path(PackageName.get((String)packageName).toRestPath() + "/metadata");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PackageMetadata>(){});
    }

    public void updateMetadata(String packageName, PackageMetadata metadata) throws PulsarAdminException {
        this.sync(() -> this.updateMetadataAsync(packageName, metadata));
    }

    public CompletableFuture<Void> updateMetadataAsync(String packageName, PackageMetadata metadata) {
        WebTarget path = this.packages.path(PackageName.get((String)packageName).toRestPath() + "/metadata");
        return this.asyncPutRequest(path, Entity.entity(metadata, "application/json"));
    }

    public void upload(PackageMetadata metadata, String packageName, String path) throws PulsarAdminException {
        this.sync(() -> this.uploadAsync(metadata, packageName, path));
    }

    public CompletableFuture<Void> uploadAsync(PackageMetadata metadata, String packageName, String path) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post((String)this.packages.path(PackageName.get((String)packageName).toRestPath()).getUri().toASCIIString()).addBodyPart((Part)new FilePart("file", new File(path), "application/octet-stream"))).addBodyPart((Part)new StringPart("metadata", new Gson().toJson((Object)metadata), "application/json"));
            ((CompletableFuture)this.httpClient.executeRequest(this.addAuthHeaders(this.packages, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(PackagesImpl.getApiException(throwable));
                return null;
            });
        }
        catch (PulsarAdminException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void download(String packageName, String path) throws PulsarAdminException {
        this.sync(() -> this.downloadAsync(packageName, path));
    }

    public CompletableFuture<Void> downloadAsync(String packageName, String path) {
        WebTarget webTarget = this.packages.path(PackageName.get((String)packageName).toRestPath());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            Path destinyPath = Paths.get(path, new String[0]);
            if (destinyPath.getParent() != null) {
                Files.createDirectories(destinyPath.getParent(), new FileAttribute[0]);
            }
            final FileChannel os = new FileOutputStream(destinyPath.toFile()).getChannel();
            RequestBuilder builder = Dsl.get((String)webTarget.getUri().toASCIIString());
            CompletableFuture statusFuture = this.httpClient.executeRequest(this.addAuthHeaders(webTarget, builder).build(), (AsyncHandler)new AsyncHandler<HttpResponseStatus>(){
                private HttpResponseStatus status;

                public AsyncHandler.State onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
                    this.status = httpResponseStatus;
                    if (this.status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders httpHeaders) throws Exception {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
                    os.write(httpResponseBodyPart.getBodyByteBuffer());
                    return AsyncHandler.State.CONTINUE;
                }

                public void onThrowable(Throwable throwable) {
                }

                public HttpResponseStatus onCompleted() throws Exception {
                    return this.status;
                }
            }).toCompletableFuture();
            ((CompletableFuture)((CompletableFuture)statusFuture.whenComplete((status, throwable) -> {
                try {
                    os.close();
                }
                catch (IOException e) {
                    future.completeExceptionally(PackagesImpl.getApiException(throwable));
                }
            })).thenAccept(status -> {
                if (status.getStatusCode() < 200 || status.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(status.getStatusCode()).entity(status.getStatusText()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(PackagesImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(PackagesImpl.getApiException(e));
        }
        return future;
    }

    public void delete(String packageName) throws PulsarAdminException {
        this.sync(() -> this.deleteAsync(packageName));
    }

    public CompletableFuture<Void> deleteAsync(String packageName) {
        PackageName name = PackageName.get((String)packageName);
        WebTarget path = this.packages.path(name.toRestPath());
        return this.asyncDeleteRequest(path);
    }

    public List<String> listPackageVersions(String packageName) throws PulsarAdminException {
        return (List)this.sync(() -> this.listPackageVersionsAsync(packageName));
    }

    public CompletableFuture<List<String>> listPackageVersionsAsync(String packageName) {
        PackageName name = PackageName.get((String)packageName);
        WebTarget path = this.packages.path(String.format("%s/%s/%s/%s", name.getPkgType().toString(), name.getTenant(), name.getNamespace(), name.getName()));
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public List<String> listPackages(String type, String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.listPackagesAsync(type, namespace));
    }

    public CompletableFuture<List<String>> listPackagesAsync(String type, String namespace) {
        WebTarget path = this.packages.path(type + "/" + NamespaceName.get((String)namespace).toString());
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }
}

