/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.jmx.JavaVersion;
import io.airlift.jmx.JmxAgent;
import io.airlift.jmx.JmxAgent8;
import io.airlift.jmx.JmxAgent9;
import io.airlift.jmx.JmxConfig;
import io.airlift.jmx.StackTraceMBean;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.ExportBinder;

public class JmxModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        ConfigBinder.configBinder((Binder)binder).bindConfig(JmxConfig.class);
        ExportBinder.newExporter((Binder)binder).export(StackTraceMBean.class).withGeneratedName();
        binder.bind(StackTraceMBean.class).in(Scopes.SINGLETON);
        JmxConfig jmxConfig = (JmxConfig)this.buildConfigObject(JmxConfig.class);
        if (jmxConfig.getRmiRegistryPort() == null) {
            Preconditions.checkState((jmxConfig.getRmiServerPort() == null ? 1 : 0) != 0, (Object)"RMI registry port must be configured when RMI server port is configured");
        } else {
            DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement(JmxAnnouncementProvider.class);
            if (JavaVersion.current().getMajor() < 9) {
                binder.bind(JmxAgent8.class).in(Scopes.SINGLETON);
                binder.bind(JmxAgent.class).to(JmxAgent8.class);
            } else {
                binder.bind(JmxAgent9.class).in(Scopes.SINGLETON);
                binder.bind(JmxAgent.class).to(JmxAgent9.class);
            }
        }
    }

    static class JmxAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private JmxAgent jmxAgent;

        JmxAnnouncementProvider() {
        }

        @Inject
        public void setJmxAgent(JmxAgent jmxAgent) {
            this.jmxAgent = jmxAgent;
        }

        public ServiceAnnouncement get() {
            return ServiceAnnouncement.serviceAnnouncement((String)"jmx").addProperty("jmx", this.jmxAgent.getUrl().toString()).build();
        }
    }
}

